/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.ldapDriver.callbacks;

import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.users.BLdapUsersDeviceExt;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BAbsTime;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;

public abstract class LdapServerChangeObserver {
    protected boolean keepRunning = false;
    protected BLdapServer ldapServer;
    protected Logger log = Logger.getLogger("LdapChangeObserver");

    public LdapServerChangeObserver(BLdapServer ldapServer) {
        this.ldapServer = ldapServer;
    }

    public abstract void register();

    public abstract void unregister() throws NamingException;

    public DirContext getConnection() {
        try {
            return this.ldapServer.connect();
        }
        catch (NamingException e) {
            this.log.log(Level.SEVERE, "Unable to obtain connection : " + e.getLocalizedMessage());
            return null;
        }
    }

    protected void executeChangeQuery() {
        BLdapUsersDeviceExt userExt = this.ldapServer.getUsers();
        userExt.setLastUpdateTime(BAbsTime.now());
    }

    public void setKeepRunning(boolean keepRunning) {
        this.keepRunning = keepRunning;
    }
}

