/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.ldapDriver.callbacks;

import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.callbacks.LdapConnectionCallback;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;

public class LdapUpdateVendorDetailsCallback
extends LdapConnectionCallback {
    public LdapUpdateVendorDetailsCallback(BLdapServer server) {
        super(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke() throws NamingException {
        if (this.server == null) {
            return;
        }
        try (DirContext ldapContext = null;){
            Attribute globalCtlgRdy;
            Attribute supportedVersionAttr;
            Attribute vendorVersionAttr;
            ldapContext = this.getConnection();
            Attributes vendorAttrs = ldapContext.getAttributes("", new String[]{"vendorname", "vendorversion", "supportedLDAPVersion", "isGlobalCatalogReady"});
            Attribute vendorNameAttr = vendorAttrs.get("vendorname");
            if (vendorNameAttr != null) {
                this.server.setVendorName((String)vendorNameAttr.get());
            }
            if ((vendorVersionAttr = vendorAttrs.get("vendorversion")) != null) {
                this.server.setVendorVersion((String)vendorVersionAttr.get());
            }
            if ((supportedVersionAttr = vendorAttrs.get("supportedLDAPVersion")) != null) {
                String temp = (String)supportedVersionAttr.get();
                this.server.setSupportedLDAPVersion(Integer.parseInt(temp));
            }
            if ((globalCtlgRdy = vendorAttrs.get("isGlobalCatalogReady")) != null) {
                String flag = (String)globalCtlgRdy.get();
                this.server.setIsGlobalCatalogReady("true".equalsIgnoreCase(flag));
                if (vendorNameAttr == null) {
                    this.server.setVendorName("Active Directory");
                }
            }
        }
    }

    @Override
    public String getName() {
        return "vendorDetails";
    }

    @Override
    public void cleanUp() {
    }
}

