/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusTcp;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.message.Message;
import com.tridium.modbusCore.BModbusNetwork;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.messages.ModbusMessage;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusTcp.BModbusTcpGatewayDevice;
import com.tridium.modbusTcp.BModbusTcpGatewayDeviceFolder;
import com.tridium.modbusTcp.BModbusTcpNetwork;
import com.tridium.modbusTcp.BSocketStatusEnum;
import com.tridium.modbusTcp.comm.ModbusTcpComm;
import com.tridium.modbusTcp.comm.ModbusTcpRxDriver;
import java.net.InetAddress;
import javax.baja.agent.AgentList;
import javax.baja.driver.BDevice;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="ipAddress", type="String", defaultValue="ModbusMessageConst.DEFAULT_IP"), @NiagaraProperty(name="port", type="int", defaultValue="502", facets={@Facet(value="BFacets.makeInt(null, 0, 65535)")}), @NiagaraProperty(name="socketStatus", type="BSocketStatusEnum", defaultValue="BSocketStatusEnum.closed", flags=3), @NiagaraProperty(name="rxProcessMode", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.makeBoolean(\"packet\", \"byte\")")})})
public class BModbusTcpGateway
extends BModbusTcpNetwork {
    @Generated
    public static final Property ipAddress = BModbusTcpGateway.newProperty((int)0, (String)"###.###.###.###", null);
    @Generated
    public static final Property port = BModbusTcpGateway.newProperty((int)0, (int)502, (BFacets)BFacets.makeInt(null, (int)0, (int)65535));
    @Generated
    public static final Property socketStatus = BModbusTcpGateway.newProperty((int)3, (BValue)BSocketStatusEnum.closed, null);
    @Generated
    public static final Property rxProcessMode = BModbusTcpGateway.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"packet", (String)"byte"));
    @Generated
    public static final Type TYPE = Sys.loadType(BModbusTcpGateway.class);

    @Generated
    public String getIpAddress() {
        return this.getString(ipAddress);
    }

    @Generated
    public void setIpAddress(String v) {
        this.setString(ipAddress, v, null);
    }

    @Generated
    public int getPort() {
        return this.getInt(port);
    }

    @Generated
    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    @Generated
    public BSocketStatusEnum getSocketStatus() {
        return (BSocketStatusEnum)this.get(socketStatus);
    }

    @Generated
    public void setSocketStatus(BSocketStatusEnum v) {
        this.set(socketStatus, (BValue)v, null);
    }

    @Generated
    public boolean getRxProcessMode() {
        return this.getBoolean(rxProcessMode);
    }

    @Generated
    public void setRxProcessMode(boolean v) {
        this.setBoolean(rxProcessMode, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public Type getDeviceType() {
        return BModbusTcpGatewayDevice.TYPE;
    }

    @Override
    public Type getDeviceFolderType() {
        return BModbusTcpGatewayDeviceFolder.TYPE;
    }

    @Override
    protected Comm makeComm() {
        return new ModbusTcpComm((BModbusNetwork)this);
    }

    @Override
    protected boolean initializeNetwork() {
        if (this.networkInitialized) {
            return true;
        }
        this.commActive = true;
        if (!this.getComm().isCommStarted()) {
            if (this.getModbusLog().isTraceOn()) {
                this.getModbusLog().warning("Unable to start TCP/IP Comm for " + (Object)((Object)this));
            }
            this.commActive = false;
            return false;
        }
        this.networkInitialized = true;
        return true;
    }

    @Override
    public boolean isCommActive() {
        return this.getComm().isCommStarted() && this.commActive && !this.isDisabled() && !this.isDown() && !this.isFatalFault();
    }

    public InetAddress getInetAddr() {
        InetAddress newINet;
        try {
            String url = this.getIpAddress().trim();
            newINet = url.equalsIgnoreCase("###.###.###.###") || url.length() == 0 ? null : InetAddress.getByName(url);
        }
        catch (Exception e) {
            newINet = null;
        }
        return newINet;
    }

    public void changed(Property prop, Context context) {
        block9: {
            super.changed(prop, context);
            try {
                if (!prop.equals(ipAddress) && !prop.equals(port) || this.getComm() == null || !this.getComm().isCommStarted()) break block9;
                long ticks = Clock.ticks();
                while (this.getSocketStatus().equals((Object)BSocketStatusEnum.openPending)) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (Clock.ticks() - ticks <= 30000L) continue;
                }
                this.getComm().stop();
                InetAddress ipaddr = this.getInetAddr();
                if (ipaddr == null && this.getModbusLog() != null) {
                    this.getModbusLog().error("\nCould not resolve IP address [" + this.getIpAddress() + "].");
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.getComm().start();
                BDevice[] devices = this.getDevices();
                for (int i = 0; i < devices.length; ++i) {
                    devices[i].ping();
                }
            }
            catch (Exception e) {
                if (this.getModbusLog() == null) break block9;
                this.getModbusLog().error("Caught exception in BModbusTcpGateway.changed()", (Throwable)e);
            }
        }
    }

    public Message sendSync(Message msg, BRelTime responseTimeout, int retryCount) {
        if (!this.isCommActive()) {
            return null;
        }
        int socketStatus = this.getSocketStatus().getOrdinal();
        if (socketStatus == 0 || socketStatus == 2) {
            ((ModbusTcpRxDriver)this.getComm().getCommReceiver()).initSocketConnection();
            socketStatus = this.getSocketStatus().getOrdinal();
        }
        Message response = null;
        if (socketStatus == 3) {
            response = super.sendSync(msg, responseTimeout, retryCount);
        }
        try {
            BModbusClientDevice destDevice = this.findDeviceInNetwork(((ModbusMessage)msg).deviceAddress);
            if (destDevice != null) {
                if (response != null && ((ModbusResponse)response).exceptionCode != 10 && ((ModbusResponse)response).exceptionCode != 11) {
                    destDevice.pingOk();
                    destDevice.resetPingsFailed();
                } else if (destDevice.incrementPingsFailed() > this.getMaxFailsUntilDeviceDown()) {
                    String cause = this.getLexicon().getText("pingFail");
                    if (response != null) {
                        cause = cause + ": " + ((ModbusResponse)response).getExceptionString();
                    }
                    destDevice.pingFail(cause);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return response;
    }

    public AgentList getAgents(Context cx) {
        TypeInfo deviceManager = Sys.getRegistry().getType("modbusTcp:ModbusTcpDeviceManager");
        AgentList agents = super.getAgents(cx);
        agents.remove(deviceManager.getAgentInfo());
        return agents;
    }
}

