/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.serial;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBitString;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BSerialFlowControlMode
extends BBitString {
    public static final BSerialFlowControlMode none;
    public static final BSerialFlowControlMode DEFAULT;
    public static final Type TYPE;
    public static final int RTS_CTS_ON_INPUT = 1;
    public static final int RTS_CTS_ON_OUTPUT = 2;
    public static final int XON_XOFF_ON_INPUT = 4;
    public static final int XON_XOFF_ON_OUTPUT = 8;
    public static final BSerialFlowControlMode rtsCtsOnInput;
    public static final BSerialFlowControlMode rtsCtsOnOutput;
    public static final BSerialFlowControlMode xonXoffOnInput;
    public static final BSerialFlowControlMode xonXoffOnOutput;
    private static BBitString.Support support;
    private int bits;

    public Type getType() {
        return TYPE;
    }

    public static BSerialFlowControlMode make(int bits) {
        if (bits == 0) {
            return none;
        }
        return new BSerialFlowControlMode(bits);
    }

    public static BSerialFlowControlMode make(BSerialFlowControlMode orig, int bit, boolean bitState) {
        int newBits;
        int n = newBits = bitState ? orig.bits | bit : orig.bits & ~bit;
        if (newBits == 0) {
            return none;
        }
        if (orig.bits == newBits) {
            return orig;
        }
        return new BSerialFlowControlMode(newBits);
    }

    public static BSerialFlowControlMode makeRtsCtsOnInput(BSerialFlowControlMode orig, boolean state) {
        return BSerialFlowControlMode.make(orig, 1, state);
    }

    public static BSerialFlowControlMode makeRtsCtsOnOutput(BSerialFlowControlMode orig, boolean state) {
        return BSerialFlowControlMode.make(orig, 2, state);
    }

    public static BSerialFlowControlMode makeXonXoffOnInput(BSerialFlowControlMode orig, boolean state) {
        return BSerialFlowControlMode.make(orig, 4, state);
    }

    public static BSerialFlowControlMode makeXonXoffOnOutput(BSerialFlowControlMode orig, boolean state) {
        return BSerialFlowControlMode.make(orig, 8, state);
    }

    private BSerialFlowControlMode(int bits) {
        this.bits = bits;
    }

    public int getBits() {
        return this.bits;
    }

    public boolean isNone() {
        return this.bits == 0;
    }

    public boolean isRtsCtsOnInput() {
        return (this.bits & 1) != 0;
    }

    public boolean isRtsCtsOnOutput() {
        return (this.bits & 2) != 0;
    }

    public boolean isXonXoffOnInput() {
        return (this.bits & 4) != 0;
    }

    public boolean isXonXoffOnOutput() {
        return (this.bits & 8) != 0;
    }

    public boolean getBit(int ordinal) {
        return (this.bits & ordinal) != 0;
    }

    public boolean getBit(String tag) {
        return this.getBit(this.tagToOrdinal(tag));
    }

    public int[] getOrdinals() {
        return support.getOrdinals();
    }

    public boolean isOrdinal(int ordinal) {
        return support.isOrdinal(ordinal);
    }

    public String getTag(int ordinal) {
        return support.getTag(ordinal);
    }

    public String getDisplayTag(int ordinal, Context cx) {
        return support.getDisplayTag(ordinal, cx);
    }

    public BBitString getInstance(int[] ordinals) {
        int mask = 0;
        for (int i = 0; i < ordinals.length; ++i) {
            mask |= ordinals[i];
        }
        return BSerialFlowControlMode.make(mask);
    }

    public boolean isTag(String tag) {
        return support.isTag(tag);
    }

    public int tagToOrdinal(String tag) {
        return support.tagToOrdinal(tag);
    }

    public boolean isEmpty() {
        return this.bits == 0;
    }

    public String getEmptyTag() {
        return "none";
    }

    public int hashCode() {
        return this.bits;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BSerialFlowControlMode) {
            return ((BSerialFlowControlMode)((Object)obj)).bits == this.bits;
        }
        return false;
    }

    public String toString(Context context) {
        if (this.bits == 0) {
            return "{none}";
        }
        StringBuilder s = new StringBuilder();
        s.append('{');
        if (this.isRtsCtsOnInput()) {
            s.append("RtsCtsOnInput,");
        }
        if (this.isRtsCtsOnOutput()) {
            s.append("RtsCtsOnOutput,");
        }
        if (this.isXonXoffOnInput()) {
            s.append("XonXoffOnInput,");
        }
        if (this.isXonXoffOnOutput()) {
            s.append("XonXoffOnOutput,");
        }
        s.setCharAt(s.length() - 1, '}');
        return s.toString();
    }

    public void encode(DataOutput out) throws IOException {
        out.writeInt(this.bits);
    }

    public BObject decode(DataInput in) throws IOException {
        return BSerialFlowControlMode.make(in.readInt());
    }

    public String encodeToString() throws IOException {
        return Integer.toHexString(this.bits);
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            return BSerialFlowControlMode.make(Integer.parseInt(s, 16));
        }
        catch (Exception e) {
            throw new IOException("Invalid bits: " + s);
        }
    }

    static {
        DEFAULT = none = new BSerialFlowControlMode(0);
        TYPE = Sys.loadType(BSerialFlowControlMode.class);
        rtsCtsOnInput = new BSerialFlowControlMode(1);
        rtsCtsOnOutput = new BSerialFlowControlMode(2);
        xonXoffOnInput = new BSerialFlowControlMode(4);
        xonXoffOnOutput = new BSerialFlowControlMode(8);
        support = new BBitString.Support((BBitString)DEFAULT);
        support.add(1, "RtsCtsOnInput");
        support.add(2, "RtsCtsOnOutput");
        support.add(4, "XonXoffOnInput");
        support.add(8, "XonXoffOnOutput");
    }
}

