/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.util;

import com.tridium.cloud.util.HttpStatusException;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.baja.net.HttpsConnection;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public interface HttpUtils {
    public static final String JSON_MIME_TYPE = "application/json; charset=utf-8";
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 600000;
    public static final int DEFAULT_READ_TIMEOUT_MILLIS = 600000;

    public int getConnectTimeout();

    public void setConnectTimeout(int var1);

    public int getReadTimeout();

    public void setReadTimeout(int var1);

    public <R> R get(String var1, Map<String, Object> var2, Optional<Function<InputStream, R>> var3, Optional<Consumer<Map<String, List<String>>>> var4) throws IOException, HttpStatusException;

    public <R> R delete(String var1, Map<String, Object> var2, Optional<Function<InputStream, R>> var3, Optional<Consumer<Map<String, List<String>>>> var4) throws IOException, HttpStatusException;

    public <R> R post(String var1, String var2, Map<String, Object> var3, long var4, Optional<Consumer<OutputStream>> var6, Optional<Function<InputStream, R>> var7, Optional<Consumer<Map<String, List<String>>>> var8) throws IOException, HttpStatusException;

    public <R> R put(String var1, String var2, Map<String, Object> var3, long var4, Optional<Consumer<OutputStream>> var6, Optional<Function<InputStream, R>> var7, Optional<Consumer<Map<String, List<String>>>> var8) throws IOException, HttpStatusException;

    public <R> R http(Method var1, String var2, String var3, Map<String, Object> var4, long var5, Optional<Consumer<OutputStream>> var7, Optional<Function<InputStream, R>> var8, Optional<Consumer<Map<String, List<String>>>> var9) throws IOException, HttpStatusException;

    public static Map<String, Object> makeAuthHeaderMap(String token) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("Authorization", "Bearer " + token);
        return headers;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject fromInputStreamToJsonObject(InputStream in) {
        try (InputStreamReader reader = new InputStreamReader(in);){
            JSONObject jSONObject = new JSONObject(new JSONTokener((Reader)reader));
            return jSONObject;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONArray fromInputStreamToJsonArray(InputStream in) {
        try (InputStreamReader reader = new InputStreamReader(in);){
            JSONArray jSONArray = new JSONArray(new JSONTokener((Reader)reader));
            return jSONArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Consumer<OutputStream> fromStringToOutputStreamFunc(Object obj) {
        return out -> {
            try {
                out.write(obj.toString().getBytes("UTF-8"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static HttpURLConnection makeConnection(URI uri) throws IOException {
        URL parsedUrl = new URL(uri.toString());
        String protocol = parsedUrl.getProtocol().toLowerCase();
        HttpURLConnection connection = (HttpURLConnection)parsedUrl.openConnection();
        if ("https".equalsIgnoreCase(protocol)) {
            SSLSocketFactory socketFactory = (SSLSocketFactory)HttpsConnection.getDefaultSocketFactory();
            ((HttpsURLConnection)connection).setSSLSocketFactory(socketFactory);
        }
        connection.setConnectTimeout(600000);
        connection.setReadTimeout(600000);
        return connection;
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE,
        PATCH;

    }
}

