/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.util;

import com.tridium.cloud.util.HttpStatusException;
import com.tridium.cloud.util.HttpUtils;
import com.tridium.json.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class StandardHttpUtils
implements HttpUtils {
    private static final Logger log = Logger.getLogger("cloud.connector.http");
    private int connectTimeout = 600000;
    private int readTimeout = 600000;
    private static final String HDR_X_ACTIVITY_ID = "x-activity-id";
    private static final String HDR_CONTENT_TYPE = "Content-Type";

    private StandardHttpUtils() {
    }

    public static StandardHttpUtils getInstance() {
        return HttpUtilsHolder.INSTANCE;
    }

    public static StandardHttpUtils make() {
        return new StandardHttpUtils();
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public <R> R get(String uri, Map<String, Object> requestHeaders, Optional<Function<InputStream, R>> responseFunction, Optional<Consumer<Map<String, List<String>>>> responseHeaderConsumer) throws IOException, HttpStatusException {
        return this.http(HttpUtils.Method.GET, uri, "", requestHeaders, -1L, Optional.empty(), responseFunction, responseHeaderConsumer);
    }

    @Override
    public <R> R delete(String uri, Map<String, Object> requestHeaders, Optional<Function<InputStream, R>> responseFunction, Optional<Consumer<Map<String, List<String>>>> responseHeaderConsumer) throws IOException, HttpStatusException {
        return this.http(HttpUtils.Method.DELETE, uri, "", requestHeaders, -1L, Optional.empty(), responseFunction, responseHeaderConsumer);
    }

    @Override
    public <R> R post(String uri, String mimeType, Map<String, Object> requestHeaders, long contentLength, Optional<Consumer<OutputStream>> contentSupplier, Optional<Function<InputStream, R>> responseFunction, Optional<Consumer<Map<String, List<String>>>> responseHeaderConsumer) throws IOException, HttpStatusException {
        return this.http(HttpUtils.Method.POST, uri, mimeType, requestHeaders, contentLength, contentSupplier, responseFunction, responseHeaderConsumer);
    }

    @Override
    public <R> R put(String uri, String mimeType, Map<String, Object> requestHeaders, long contentLength, Optional<Consumer<OutputStream>> contentSupplier, Optional<Function<InputStream, R>> responseFunction, Optional<Consumer<Map<String, List<String>>>> responseHeaderConsumer) throws IOException, HttpStatusException {
        return this.http(HttpUtils.Method.PUT, uri, mimeType, requestHeaders, contentLength, contentSupplier, responseFunction, responseHeaderConsumer);
    }

    @Override
    public <R> R http(HttpUtils.Method method, String uri, String mimeType, Map<String, Object> requestHeaders, long contentLength, Optional<Consumer<OutputStream>> contentSupplier, Optional<Function<InputStream, R>> responseFunction, Optional<Consumer<Map<String, List<String>>>> responseHeaderConsumer) throws IOException, HttpStatusException {
        try {
            return (R)AccessController.doPrivileged(() -> {
                String activityId;
                Object retVal = null;
                log.finest("Making HTTP connection");
                HttpURLConnection conn = StandardHttpUtils.makeConnection(new URI(uri), method, mimeType, requestHeaders, contentLength, contentSupplier);
                conn.setConnectTimeout(this.connectTimeout);
                conn.setReadTimeout(this.readTimeout);
                log.finest("Getting HTTP connection response code");
                int responseCode = conn.getResponseCode();
                log.fine("HTTP Response Code:" + responseCode);
                if (log.isLoggable(Level.FINEST) && (activityId = conn.getHeaderField(HDR_X_ACTIVITY_ID)) != null) {
                    log.finest("Activity ID: " + activityId);
                }
                if (responseCode == 307) {
                    String activityId2;
                    if (method == HttpUtils.Method.POST || method == HttpUtils.Method.PUT || method == HttpUtils.Method.PATCH) {
                        log.warning("Redirects for POST, PUT or PATCH aren't currently supported");
                        throw new HttpStatusException(responseCode);
                    }
                    String newUri = Objects.toString(conn.getHeaderField("Location"), "");
                    if (newUri.isEmpty()) {
                        log.warning("Redirects Location header is missing or empty");
                        throw new HttpStatusException(responseCode);
                    }
                    conn = StandardHttpUtils.makeConnection(new URI(newUri), method, mimeType, requestHeaders, contentLength, contentSupplier);
                    responseCode = conn.getResponseCode();
                    if (log.isLoggable(Level.FINEST) && (activityId2 = conn.getHeaderField(HDR_X_ACTIVITY_ID)) != null) {
                        log.finest("Activity ID: " + activityId2);
                    }
                }
                if (responseCode != 200 && responseCode != 201) {
                    String message;
                    JSONObject jsonErr = new JSONObject();
                    try (InputStream err = conn.getErrorStream();){
                        if (Objects.toString(conn.getHeaderField(HDR_CONTENT_TYPE)).toLowerCase().contains("json")) {
                            if (err != null) {
                                jsonErr = HttpUtils.fromInputStreamToJsonObject(err);
                            }
                            message = jsonErr.optString("message", Objects.toString(jsonErr));
                        } else {
                            ByteArrayOutputStream result = new ByteArrayOutputStream();
                            if (err != null) {
                                int length;
                                byte[] buffer = new byte[1024];
                                while ((length = err.read(buffer)) != -1) {
                                    result.write(buffer, 0, length);
                                }
                            }
                            message = result.toString(StandardCharsets.UTF_8.name());
                        }
                    }
                    throw new HttpStatusException(responseCode, message);
                }
                try (InputStream in = conn.getInputStream();){
                    if (responseHeaderConsumer.isPresent()) {
                        Map<String, List<String>> headers = conn.getHeaderFields();
                        ((Consumer)responseHeaderConsumer.get()).accept(headers != null ? headers : Collections.emptyMap());
                    }
                    if (responseFunction.isPresent()) {
                        retVal = ((Function)responseFunction.get()).apply(in);
                    }
                }
                return retVal;
            });
        }
        catch (PrivilegedActionException e) {
            Exception inner = e.getException();
            if (inner instanceof IOException) {
                throw (IOException)inner;
            }
            if (inner instanceof HttpStatusException) {
                throw (HttpStatusException)inner;
            }
            if (inner instanceof RuntimeException) {
                throw (RuntimeException)inner;
            }
            throw new RuntimeException(inner);
        }
    }

    private static HttpURLConnection makeConnection(URI uri, HttpUtils.Method method, String mimeType, Map<String, Object> requestHeaders, long contentLength, Optional<Consumer<OutputStream>> contentSupplier) throws URISyntaxException, IOException {
        HttpURLConnection conn = HttpUtils.makeConnection(uri);
        conn.setInstanceFollowRedirects(false);
        conn.setUseCaches(false);
        if (method == HttpUtils.Method.POST || method == HttpUtils.Method.PUT || method == HttpUtils.Method.PATCH) {
            conn.setDoOutput(true);
        }
        conn.setRequestMethod(method.toString());
        if (!mimeType.isEmpty()) {
            conn.setRequestProperty(HDR_CONTENT_TYPE, mimeType);
        }
        requestHeaders.forEach((key, val) -> conn.setRequestProperty((String)key, val.toString()));
        if (method == HttpUtils.Method.POST || method == HttpUtils.Method.PUT || method == HttpUtils.Method.PATCH) {
            if (contentSupplier.isPresent()) {
                if (contentLength > -1L) {
                    conn.setFixedLengthStreamingMode(contentLength);
                }
                try (OutputStream out = conn.getOutputStream();){
                    contentSupplier.get().accept(out);
                }
            } else {
                conn.setFixedLengthStreamingMode(0);
            }
        }
        return conn;
    }

    private static final class HttpUtilsHolder {
        private static final StandardHttpUtils INSTANCE = new StandardHttpUtils();

        private HttpUtilsHolder() {
        }
    }
}

