/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.hx;

import com.tridium.weather.ui.BWeatherManager;
import javax.baja.hx.mgr.BHxAbstractManager;
import javax.baja.hx.mgr.HxMgrColumn;
import javax.baja.hx.mgr.HxMgrCommand;
import javax.baja.hx.mgr.HxMgrModel;
import javax.baja.hx.mgr.MgrOp;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BForecast;
import javax.baja.weather.BWeatherProvider;
import javax.baja.weather.BWeatherReport;
import javax.baja.weather.advisory.BAdvisory;
import javax.baja.weather.advisory.BAdvisoryContainer;

@NiagaraType(agent={@AgentOn(types={"weather:WeatherManager"}, requiredPermissions="W")})
@NiagaraSingleton
@Deprecated
public final class BHxWeatherManager
extends BHxAbstractManager {
    @Generated
    public static final BHxWeatherManager INSTANCE = new BHxWeatherManager();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxWeatherManager.class);
    private static HxMgrCommand[] cmds = new HxMgrCommand[]{new HxMgrCommand.New(), new HxMgrCommand.Edit(), new HxMgrCommand.Delete()};

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BHxWeatherManager() {
    }

    protected HxMgrModel makeModel() {
        return new Model();
    }

    private static class AdvisoryColumn
    extends HxMgrColumn {
        public AdvisoryColumn(Lexicon lex) {
            super(lex.getText("advisory"));
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            if (value != null) {
                return ((BAdvisory)value).getWeatherSummary().getValue();
            }
            return Lexicon.make((String)"weather", (Context)cx).getText("advisory.none");
        }

        public Object get(Object row) {
            BWeatherReport report = (BWeatherReport)row;
            BAdvisoryContainer adv = report.getCurrent().getAdvisories();
            Object[] advisories = adv.getChildren(BAdvisory.class);
            if (advisories.length > 0) {
                return advisories[0];
            }
            return null;
        }
    }

    private static class CurrentColumn
    extends HxMgrColumn.Prop {
        public CurrentColumn(Context cx) {
            super(BWeatherReport.current.getDefaultDisplayName(cx), BWeatherReport.current, 0);
        }
    }

    private static class SunriseColumn
    extends HxMgrColumn.Prop {
        public SunriseColumn(Lexicon lex) {
            super(lex.getText("sunrise.sunset"), BWeatherReport.current, 0);
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            BCurrentConditions r = (BCurrentConditions)value;
            return "" + r.getSunrise() + '/' + r.getSunset();
        }
    }

    private static class ForecastColumn
    extends HxMgrColumn.Prop {
        int myIndex = 0;

        public ForecastColumn(String name, int index) {
            super(name, BWeatherReport.current, 0);
            this.myIndex = index;
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            BCurrentConditions curr = (BCurrentConditions)value;
            BWeatherReport r = (BWeatherReport)curr.getParent();
            BForecast[] f = r.getForecast();
            if (this.myIndex < f.length) {
                return f[this.myIndex].toString(cx);
            }
            return "-";
        }
    }

    private static class WeatherName
    extends HxMgrColumn.Name {
        private WeatherName() {
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            return value.toString();
        }

        public String getHyperlink(Object row, Object value, Context cx) {
            return ((BComponent)row).getNavOrd().toString();
        }
    }

    private static class Model
    extends HxMgrModel {
        private Model() {
        }

        public String getTableTitle() {
            return BWeatherManager.TYPE.getDisplayName(null);
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BWeatherReport.TYPE};
        }

        public Type[] getNewTypes() {
            TypeInfo[] t = Sys.getRegistry().getConcreteTypes(BWeatherProvider.TYPE.getTypeInfo());
            Type[] types = new Type[t.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = t[i].getTypeSpec().getResolvedType();
            }
            return types;
        }

        public BComponent newInstance(Type type) throws Exception {
            BWeatherReport report = new BWeatherReport();
            report.setProvider((BWeatherProvider)type.getInstance());
            return report;
        }

        protected HxMgrColumn[] makeColumns() {
            MgrOp op = this.getMgrOp();
            Lexicon lex = Lexicon.make((String)"weather", (Context)this.getMgrOp());
            WeatherName colName = new WeatherName();
            CurrentColumn colCurrent = new CurrentColumn((Context)op);
            ForecastColumn colToday = new ForecastColumn(lex.getText("today"), 0);
            ForecastColumn colTomorrow = new ForecastColumn(lex.getText("tomorrow"), 1);
            AdvisoryColumn colAdvisory = new AdvisoryColumn(lex);
            SunriseColumn colSunrise = new SunriseColumn(lex);
            HxMgrColumn.Prop colProvider = new HxMgrColumn.Prop(BWeatherReport.provider, 3);
            return new HxMgrColumn[]{colName, colCurrent, colToday, colTomorrow, colAdvisory, colSunrise, colProvider};
        }

        protected HxMgrCommand[] makeCommands() {
            return cmds;
        }
    }
}

