/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.nws.ui;

import com.tridium.weather.nws.BNwsWeatherProvider;
import com.tridium.weather.nws.NwsStationList;
import java.util.Arrays;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"weather:NwsWeatherProvider"})})
@NiagaraAction(name="updateLocationList")
public class BNwsWeatherProviderFE
extends BWbFieldEditor {
    @Generated
    public static final Action updateLocationList = BNwsWeatherProviderFE.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNwsWeatherProviderFE.class);
    protected static final Lexicon LEX = Lexicon.make(BNwsWeatherProviderFE.class);
    BNwsWeatherProvider nws;
    NwsStationList stations = new NwsStationList();
    BListDropDown state = new BListDropDown();
    BListDropDown location = new BListDropDown();
    BLabel epaLabel = new BLabel(LEX.getText("airQuality.label"));
    BListDropDown epaEnabled = new BListDropDown();

    @Generated
    public void updateLocationList() {
        this.invoke(updateLocationList, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNwsWeatherProviderFE() {
        String[] s = this.stations.getStates();
        Arrays.sort(s, String.CASE_INSENSITIVE_ORDER);
        this.state.getList().addItem((Object)"");
        for (String value1 : s) {
            this.state.getList().addItem((Object)value1);
        }
        this.state.getList().setSelectedIndex(0);
        s = this.stations.getLocations(s[0]);
        Arrays.sort(s, String.CASE_INSENSITIVE_ORDER);
        this.location.getList().addItem((Object)"");
        for (String value : s) {
            this.location.getList().addItem((Object)value);
        }
        this.location.getList().setSelectedIndex(0);
        this.epaEnabled.getList().addItem((Object)LEX.getText("airQuality.enabled"));
        this.epaEnabled.getList().addItem((Object)LEX.getText("airQuality.disabled"));
        this.epaEnabled.getList().setSelectedIndex(0);
        BGridPane grid = new BGridPane(2);
        grid.add(null, (BValue)this.state);
        grid.add(null, (BValue)this.location);
        grid.add(null, (BValue)this.epaLabel);
        grid.add(null, (BValue)this.epaEnabled);
        this.setContent((BWidget)grid);
        this.linkTo("lk1", (BComponent)this.state, (Slot)BListDropDown.listActionPerformed, (Slot)updateLocationList);
        this.linkTo("lk0", (BComponent)this.state, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        this.linkTo("lk2", (BComponent)this.location, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        this.linkTo("lk3", (BComponent)this.epaEnabled, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
    }

    protected void doSetReadonly(boolean readonly) {
        boolean ro = readonly;
        if (this.nws != null) {
            ro |= Flags.isReadonly((BComplex)this.nws, (Slot)BNwsWeatherProvider.stationId);
            ro |= Flags.isHidden((BComplex)this.nws, (Slot)BNwsWeatherProvider.stationId);
        }
        this.state.setDropDownEnabled(!ro);
        this.location.setDropDownEnabled(!ro);
        this.epaEnabled.setDropDownEnabled(!ro);
    }

    protected void doLoadValue(BObject v, Context cx) {
        String temp;
        int i;
        this.nws = (BNwsWeatherProvider)v;
        NwsStationList.Station s = this.stations.getStation(this.nws.getStationId());
        ListModel model = this.state.getList().getModel();
        for (i = 0; i < model.getItemCount(); ++i) {
            temp = (String)model.getItem(i);
            if (s == null || !temp.equals(s.state)) continue;
            this.state.getList().setSelectedIndex(i);
            break;
        }
        this.doUpdateLocationList();
        model = this.location.getList().getModel();
        for (i = 0; i < model.getItemCount(); ++i) {
            temp = (String)model.getItem(i);
            if (s == null || !temp.equals(s.name)) continue;
            this.location.getList().setSelectedIndex(i);
            break;
        }
        this.epaEnabled.getList().setSelectedIndex(this.nws.getAirQualityEnabled() ? 0 : 1);
        this.doSetReadonly(this.isReadonly());
    }

    protected BObject doSaveValue(BObject v, Context cx) {
        BNwsWeatherProvider nws = (BNwsWeatherProvider)v;
        String loc = (String)this.location.getList().getSelectedItem();
        String sta = (String)this.state.getList().getSelectedItem();
        nws.setStationId(this.stations.getStationId(loc, sta));
        nws.setAirQualityEnabled(this.epaEnabled.getList().getSelectedIndex() == 0);
        return nws;
    }

    public void doUpdateLocationList() {
        this.location.getList().removeAllItems();
        String st = (String)this.state.getList().getSelectedItem();
        String[] s = this.stations.getLocations(st);
        Arrays.sort(s, String.CASE_INSENSITIVE_ORDER);
        for (String value : s) {
            this.location.getList().addItem((Object)value);
        }
        this.location.setVisible(s.length != 0);
        this.location.getList().setSelectedIndex(0);
    }
}

