/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.ui;

import com.tridium.weather.AirQualityIndexUtil;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BLayout;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BWeatherReport;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"weather:WeatherReport", "weather:CurrentConditions"})})
@NiagaraProperties(value={@NiagaraProperty(name="font", type="BFont", defaultValue="BFont.make(lex.getText(\"state.font\"))"), @NiagaraProperty(name="showAqi", type="boolean", defaultValue="false")})
public class BCurrentAirQualityView
extends BWbComponentView {
    private static final Lexicon lex = Lexicon.make((String)"weather");
    @Generated
    public static final Property font = BCurrentAirQualityView.newProperty((int)0, (BValue)BFont.make((String)lex.getText("state.font")), null);
    @Generated
    public static final Property showAqi = BCurrentAirQualityView.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCurrentAirQualityView.class);
    private BLabel label;

    @Generated
    public BFont getFont() {
        return (BFont)this.get(font);
    }

    @Generated
    public void setFont(BFont v) {
        this.set(font, (BValue)v, null);
    }

    @Generated
    public boolean getShowAqi() {
        return this.getBoolean(showAqi);
    }

    @Generated
    public void setShowAqi(boolean v) {
        this.setBoolean(showAqi, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (this.getCurrentValue() == null) {
            return;
        }
        if (prop.equals(font) || prop.equals(showAqi)) {
            this.loadValue(this.getCurrentValue(), this.getCurrentContext());
        }
    }

    protected void doLoadValue(BObject v, Context cx) {
        BCurrentConditions current;
        if (v instanceof BWeatherReport) {
            current = ((BWeatherReport)v).getCurrent();
        } else if (v instanceof BCurrentConditions) {
            current = (BCurrentConditions)v;
        } else {
            throw new IllegalStateException("No current conditions available from " + v.getType());
        }
        current.lease();
        this.label = new BLabel();
        this.label.setLayout(BLayout.FILL);
        this.label.setFont(this.getFont());
        int o3 = -1;
        int pm25 = -1;
        if (!current.getOzone().getStatus().isNull()) {
            o3 = AirQualityIndexUtil.ozoneConcentrationToAqi((double)current.getOzone().getValue());
        }
        if (!current.getParticulateMatter().getStatus().isNull()) {
            pm25 = AirQualityIndexUtil.particulateConcentrationToAqi((double)current.getParticulateMatter().getValue());
        }
        int aqi = Math.max(o3, pm25);
        StringBuilder text = new StringBuilder();
        if (aqi == -1 || !this.getEnabled()) {
            text.append(lex.get("airQuality.unknown"));
            this.label.setForeground(BBrush.makeSolid((BColor)BColor.black));
            this.label.setBackground(BBrush.makeSolid((BColor)BColor.white));
        } else if (aqi <= 50) {
            text.append(lex.get("airQuality.good"));
            this.label.setForeground(BBrush.makeSolid((BColor)BColor.black));
            this.label.setBackground(BBrush.makeSolid((BColor)BColor.make((int)0, (int)228, (int)0)));
        } else if (aqi <= 100) {
            text.append(lex.get("airQuality.moderate"));
            this.label.setForeground(BBrush.makeSolid((BColor)BColor.black));
            this.label.setBackground(BBrush.makeSolid((BColor)BColor.make((int)255, (int)255, (int)0)));
        } else if (aqi <= 150) {
            text.append(lex.get("airQuality.unhealthyForSensitiveGroups"));
            this.label.setForeground(BBrush.makeSolid((BColor)BColor.black));
            this.label.setBackground(BBrush.makeSolid((BColor)BColor.make((int)255, (int)126, (int)0)));
        } else if (aqi <= 200) {
            text.append(lex.get("airQuality.unhealthy"));
            this.label.setForeground(BBrush.makeSolid((BColor)BColor.white));
            this.label.setBackground(BBrush.makeSolid((BColor)BColor.make((int)255, (int)0, (int)0)));
        } else if (aqi <= 300) {
            text.append(lex.get("airQuality.veryUnhealthy"));
            this.label.setForeground(BBrush.makeSolid((BColor)BColor.white));
            this.label.setBackground(BBrush.makeSolid((BColor)BColor.make((int)143, (int)63, (int)151)));
        } else {
            text.append(lex.get("airQuality.hazardous"));
            this.label.setForeground(BBrush.makeSolid((BColor)BColor.white));
            this.label.setBackground(BBrush.makeSolid((BColor)BColor.make((int)126, (int)0, (int)35)));
        }
        if (this.getShowAqi() && aqi != -1 && this.getEnabled()) {
            text.append(" (").append(aqi).append(')');
        }
        this.label.setText(text.toString());
        this.setContent((BWidget)this.label);
        this.registerForComponentEvents((BComponent)current);
    }

    public void handleComponentEvent(BComponentEvent event) {
        BComponent c = event.getSourceComponent();
        if (c instanceof BCurrentConditions) {
            BCurrentConditions current = (BCurrentConditions)c;
            if (event.getSlot().equals((Object)BCurrentConditions.ozone) || event.getSlot().equals((Object)BCurrentConditions.particulateMatter)) {
                this.loadValue((BObject)current.getParent(), this.getCurrentContext());
            }
        }
    }
}

