/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hdk8000;

import java.util.Vector;

public class Hdk8000 {
    private Vector<PortSpecifier> whitelist = new Vector();

    public Hdk8000() {
        this.whitelist.add(new PortSpecifier("0x03eb", "0x2425", "Tridium", "Tridium485-2_"));
        this.whitelist.add(new PortSpecifier("0x03eb", "0x2404", "Tridium", "Tridium232-1_"));
    }

    public boolean validatePort(String vid, String pid, String vendorStr, String productStr) {
        for (int i = 0; i < this.whitelist.size(); ++i) {
            PortSpecifier validPort = this.whitelist.elementAt(i);
            if (!validPort.vid.equalsIgnoreCase(vid) || !validPort.pid.equalsIgnoreCase(pid) || !validPort.vendorStr.equals(vendorStr) || productStr.indexOf(validPort.productStr, 0) != 0) continue;
            return true;
        }
        return false;
    }

    public String getVendorString(String vid, String pid) {
        vid = vid.toLowerCase().trim();
        pid = pid.toLowerCase().trim();
        for (int i = 0; i < this.whitelist.size(); ++i) {
            PortSpecifier validPort = this.whitelist.elementAt(i);
            if (!validPort.vid.equalsIgnoreCase(vid) || !validPort.pid.equalsIgnoreCase(pid)) continue;
            return validPort.vendorStr;
        }
        return "Unknown";
    }

    public String getProductString(String vid, String pid) {
        vid = vid.toLowerCase().trim();
        pid = pid.toLowerCase().trim();
        for (int i = 0; i < this.whitelist.size(); ++i) {
            PortSpecifier validPort = this.whitelist.elementAt(i);
            if (!validPort.vid.equalsIgnoreCase(vid) || !validPort.pid.equalsIgnoreCase(pid)) continue;
            return validPort.productStr;
        }
        return "Unknown";
    }

    private class PortSpecifier {
        private String pid;
        private String vid;
        private String vendorStr;
        private String productStr;

        PortSpecifier(String vid, String pid, String vendorStr, String productStr) {
            this.vid = vid;
            this.pid = pid;
            this.vendorStr = vendorStr;
            this.productStr = productStr;
        }
    }
}

