/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

function setElementDisabled(elements, disable)
{
  if ((elements != null) && (elements[0] != null))
  {
    elements[0].disabled = disable;
    elements[0].readOnly = disable;
  }
}

function executeHostOnLoad(prefix)
{
  var operatorCanWrite         = (document.getElementsByName(prefix + ".operatorCanWrite.hidden")[0].value === "true");
  var hostReadonly             = (document.getElementsByName(prefix + ".hostReadonly.hidden")[0].value === "true");
  var linkSettingsReadonly     = (document.getElementsByName(prefix + ".linkSettingsReadonly.hidden")[0].value === "true");
  var linkModeEnabled          = (document.getElementsByName(prefix + ".linkModeEnabled.hidden")[0].value);
  var canUseStp                = (document.getElementsByName(prefix + ".canUseStp.hidden")[0].value === "true");
  var stpEnabled               = (document.getElementsByName(prefix + ".stpEnabled.hidden")[0].value === "true");

  setElementDisabled(document.getElementsByName(prefix + ".linkModeEnabled.value"),          (hostReadonly || linkSettingsReadonly || !operatorCanWrite));

  //TODO: Controlling the disable state of the STP field editors by daisy chain selected will not be fully functional
  //TODO: until onLinkModeChanged() can be implemented. See that method for additional information. Until then, always
  //TODO: assume daisy chain settings can be changed as if daisy chaining was enabled.
  var daisyChainEnabled = ((linkModeEnabled === "daisychain") || true);

  setElementDisabled(document.getElementsByName(prefix + ".stpEnabled.value"),               (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !canUseStp || !operatorCanWrite));

  if (canUseStp)
  {
    setElementDisabled(document.getElementsByName(prefix + ".stpBridgePriority.value"),      (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpPortPriority1.value"),       (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpPortPriority2.value"),       (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpHelloTime.bigHour"),         (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpHelloTime.min"),             (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpHelloTime.sec"),             (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpForwardDelayTime.bigHour"),  (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpForwardDelayTime.min"),      (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpForwardDelayTime.sec"),      (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpMaxAgingTime.bigHour"),      (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpMaxAgingTime.min"),          (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpMaxAgingTime.sec"),          (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
  }
}

function onLinkModeChanged(event)
{
  //TODO: This method will not be called until I implement a HxLinkModeHelper. As the LinkMode settings are readonly from the Station
  //TODO: at this time, it is not required.

  var element = (event.target) ? event.target : window.event.srcElement;

  //We will typically expect to see the scope passed here as:
  //
  //  [host].stpEnabled.value
  //
  //We want to get the [host] level scope, so peel off the last 2 items to get back to
  //
  //  [host]
  //
  var prefix = element.name.substring(0, element.name.lastIndexOf("."));
  prefix = prefix.substring(0, prefix.lastIndexOf("."));

  var operatorCanWrite         = (document.getElementsByName(prefix + ".operatorCanWrite.hidden")[0].value === "true");
  var hostReadonly             = (document.getElementsByName(prefix + ".hostReadonly.hidden")[0].value === "true");
  var linkSettingsReadonly     = (document.getElementsByName(prefix + ".linkSettingsReadonly.hidden")[0].value === "true");
  var canUseStp                = (document.getElementsByName(prefix + ".canUseStp.hidden")[0].value === "true");
  var stpEnabled               = (document.getElementsByName(prefix + ".stpEnabled.hidden")[0].value === "true");

  var linkModeEnabled = (element.value);

  var daisyChainEnabled = (linkModeEnabled === "daisychain");

  setElementDisabled(document.getElementsByName(prefix + ".stpEnabled.value"),               (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !canUseStp || !operatorCanWrite));

  if (canUseStp)
  {
    setElementDisabled(document.getElementsByName(prefix + ".stpBridgePriority.value"),      (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpPortPriority1.value"),       (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpPortPriority2.value"),       (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpHelloTime.bigHour"),         (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpHelloTime.min"),             (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpHelloTime.sec"),             (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpForwardDelayTime.bigHour"),  (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpForwardDelayTime.min"),      (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpForwardDelayTime.sec"),      (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpMaxAgingTime.bigHour"),      (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpMaxAgingTime.min"),          (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpMaxAgingTime.sec"),          (hostReadonly || linkSettingsReadonly || !daisyChainEnabled || !stpEnabled || !operatorCanWrite));
  }
}

function onStpEnabledChanged(event)
{
  var element = (event.target) ? event.target : window.event.srcElement;

  //We will typically expect to see the scope passed here as:
  //
  //  [host].linkModeEnabled.value
  //
  //We want to get the [host] level scope, so peel off the last 2 items to get back to
  //
  //  [host]
  //
  var prefix = element.name.substring(0, element.name.lastIndexOf("."));
  prefix = prefix.substring(0, prefix.lastIndexOf("."));

  var operatorCanWrite         = (document.getElementsByName(prefix + ".operatorCanWrite.hidden")[0].value === "true");
  var hostReadonly             = (document.getElementsByName(prefix + ".hostReadonly.hidden")[0].value === "true");
  var linkSettingsReadonly     = (document.getElementsByName(prefix + ".linkSettingsReadonly.hidden")[0].value === "true");
  var canUseStp                = (document.getElementsByName(prefix + ".canUseStp.hidden")[0].value === "true");

  var stpEnabled  = (element.value === "true");

  if (canUseStp)
  {
    setElementDisabled(document.getElementsByName(prefix + ".stpBridgePriority.value"),      (hostReadonly || linkSettingsReadonly || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpPortPriority1.value"),       (hostReadonly || linkSettingsReadonly || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpPortPriority2.value"),       (hostReadonly || linkSettingsReadonly || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpHelloTime.bigHour"),         (hostReadonly || linkSettingsReadonly || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpHelloTime.min"),             (hostReadonly || linkSettingsReadonly || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpHelloTime.sec"),             (hostReadonly || linkSettingsReadonly || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpForwardDelayTime.bigHour"),  (hostReadonly || linkSettingsReadonly || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpForwardDelayTime.min"),      (hostReadonly || linkSettingsReadonly || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpForwardDelayTime.sec"),      (hostReadonly || linkSettingsReadonly || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpMaxAgingTime.bigHour"),      (hostReadonly || linkSettingsReadonly || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpMaxAgingTime.min"),          (hostReadonly || linkSettingsReadonly || !stpEnabled || !operatorCanWrite));
    setElementDisabled(document.getElementsByName(prefix + ".stpMaxAgingTime.sec"),          (hostReadonly || linkSettingsReadonly || !stpEnabled || !operatorCanWrite));
  }
}
