function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bql/rc/builder/ExpressionChooser
 */

define(['baja!', 'baja!query:Null,baja:IComparable', 'log!nmodule.bql.rc.builder.ExpressionChooser', 'underscore', 'bajaux/spandrel', 'Promise', 'nmodule/bajaui/rc/ux/UxCommandButton', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/wb/commands/PopOutCommand'], function (baja, types, log, _, spandrel, Promise, UxCommandButton, OrderedMapEditor, PopOutCommand) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var contains = _.contains;
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-BqlBuilder-expression'
      }
    };
  };
  var objectOperators = ['=', '!='];
  var stringOperators = ['=', '!=', '<', '<=', '>', '>=', 'like'];
  var comparableOperators = ['=', '!=', '<', '<=', '>', '>='];
  function getOperators(matchValue) {
    var matchValueType = matchValue.getType();
    if (matchValueType.is('baja:String')) {
      return stringOperators;
    }
    if (!matchValueType.is('baja:IComparable') || matchValueType.is('baja:Boolean')) {
      return objectOperators;
    }
    return comparableOperators;
  }
  function getDataList(props) {
    var predefinedColumns = props.predefinedColumns;
    return predefinedColumns.map(function (column) {
      return column.fieldPath;
    }).join(';');
  }

  /**
   * @param {String} fieldPath
   * @param {Array.<object>} predefinedColumns
   * @return {String|Type}
   */
  function getColumnType(fieldPath, predefinedColumns) {
    var type = 'baja:String';
    predefinedColumns.forEach(function (column) {
      if (column.fieldPath === fieldPath && column.type) {
        type = column.type;
      }
    });
    return type;
  }

  /**
   * @param {String|Type} type
   * @param {baja.Value} matchValue
   * @return {Promise}
   */
  function typeToMatchValue(type, matchValue) {
    return baja.importTypes([type]).then(function () {
      var defaultInstance = baja.$(type);
      if (baja.hasType(matchValue, 'query:Null')) {
        return defaultInstance;
      }

      //not a simple or BIEncodable
      if (!_.isFunction(defaultInstance.decodeAsync)) {
        return String(matchValue || ''); //fallback to string
      }
      if (baja.hasType(matchValue, type)) {
        return matchValue;
      }
      if (matchValue) {
        return Promise["try"](function () {
          if (baja.hasType(matchValue, 'baja:String')) {
            return defaultInstance.decodeAsync(matchValue);
          }
          return defaultInstance;
        })["catch"](function (err) {
          //user could type in a bad encoding when in mini mode
          logSevere(err);
          return defaultInstance;
        });
      }
      return defaultInstance;
    });
  }
  var ExpressionChooser = /*#__PURE__*/function (_spandrel) {
    function ExpressionChooser(params) {
      var _this;
      _classCallCheck(this, ExpressionChooser);
      _this = _callSuper(this, ExpressionChooser, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$popoutCmd = new PopOutCommand();
      return _this;
    }

    /**
     * @private
     * @param {string} fieldPath the newly entered field path
     * @returns {Promise} to be resolved once the corresponding value editor has
     * its new value loaded
     */
    _inherits(ExpressionChooser, _spandrel);
    return _createClass(ExpressionChooser, [{
      key: "$updateMatchValueFromNewFieldPath",
      value: function $updateMatchValueFromNewFieldPath(fieldPath) {
        var _this2 = this;
        var predefinedColumns = this.$getPredefinedColumns();
        var type = getColumnType(fieldPath, predefinedColumns);
        return typeToMatchValue(type).then(function (matchValue) {
          return _this2.state({
            matchValue: matchValue
          });
        });
      }

      /**
       * @param {module:nmodule/bql/rc/util/parseBql~simpleExpression} simpleExpression
       * @return {module:nmodule/bql/rc/builder/ExpressionChooser~ExpressionChooserState}
       */
    }, {
      key: "toState",
      value: function toState(simpleExpression) {
        var fieldPath = simpleExpression.fieldPath,
          operator = simpleExpression.operator,
          matchValue = simpleExpression.matchValue;
        var type = simpleExpression.type || getColumnType(fieldPath, this.$getPredefinedColumns());
        return typeToMatchValue(type, matchValue).then(function (matchValue) {
          return {
            fieldPath: fieldPath,
            operator: operator,
            matchValue: matchValue
          };
        });
      }

      /**
       * @param {module:nmodule/bql/rc/builder/ExpressionChooser~ExpressionChooserState} state
       * @returns {module:nmodule/bql/rc/util/parseBql~simpleExpression}
       */
    }, {
      key: "fromState",
      value: function fromState(state) {
        return _.pick(state, 'fieldPath', 'operator', 'matchValue');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getFieldPathEditor",
      value: function $getFieldPathEditor() {
        return this.queryWidget('fieldPath');
      }

      /**
       * @private
       * @return {module:bajaux/Widget}
       */
    }, {
      key: "$getOperatorEditor",
      value: function $getOperatorEditor() {
        return this.queryWidget('operator');
      }
    }, {
      key: "$getPredefinedColumns",
      value: function $getPredefinedColumns() {
        return this.properties().getValue('predefinedColumns');
      }

      /**
       * @private
       * @returns {Array.<module:bajaux/Widget>}
       */
    }, {
      key: "$getPopOutCommandButton",
      value: function $getPopOutCommandButton() {
        return this.queryWidget('popOutCommandButton');
      }

      /**
       * @private
       * @return {module:bajaux/Widget}
       */
    }, {
      key: "$getMatchValueEditor",
      value: function $getMatchValueEditor() {
        return this.queryWidget('matchValue');
      }
    }]);
  }(spandrel(function (value, _ref) {
    var fieldPath = _ref.fieldPath,
      matchValue = _ref.matchValue,
      operator = _ref.operator,
      props = _ref.props,
      self = _ref.self,
      writable = _ref.writable;
    var datalist = getDataList(props);
    var operators = getOperators(matchValue);
    if (operator && !contains(operators, operator)) {
      operator = operators[0];
    }
    return [spandrel.jsx("any", {
      value: fieldPath,
      bind: true,
      spandrelKey: "fieldPath",
      className: "-t-fieldPath",
      onUxModifiedValue: function onUxModifiedValue(fieldPath) {
        return self.$updateMatchValueFromNewFieldPath(fieldPath);
      },
      properties: {
        datalist: datalist,
        filterWhileTyping: false
      }
    }), spandrel.jsx(OrderedMapEditor, {
      value: operator,
      properties: {
        map: operators
      },
      className: "-t-operator",
      lax: true,
      bind: true,
      spandrelKey: "operator"
    }), spandrel.jsx("any", {
      value: matchValue,
      className: "-t-matchValue",
      lax: true,
      bind: true,
      spandrelKey: "matchValue",
      properties: {
        allowHyperlink: false
      },
      onUxLoad: function onUxLoad(e, ed) {
        return self.$popoutCmd.setWatchedEditor(ed);
      }
    }), spandrel.jsx(UxCommandButton, {
      value: self.$popoutCmd,
      properties: {
        enabled: writable,
        buttonStyle: baja.$('bajaui:ButtonStyle', 'toolBar')
      },
      spandrelKey: "popOutCommandButton",
      className: "-t-popOutCommandButton"
    })];
  }, {
    strategy: 'niagara'
  }));
  return ExpressionChooser;
});

/**
 * @typedef module:nmodule/bql/rc/builder/ExpressionChooser~ExpressionChooserState
 * @extends module:bajaux/spandrel/SpandrelWidget~WidgetState
 * @property {string} fieldPath - the entered field path
 * @property {string} operator - the chosen operator
 * @property {*} matchValue - the value to match on
 */
