function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bql/rc/builder/ExtentTypeChooser
 */

define(['baja!', 'bajaux/spandrel', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor'], function (baja, spandrel, BaseWidget, OrderedMapEditor) {
  'use strict';

  var VALUE_READY_EVENT = BaseWidget.VALUE_READY_EVENT;
  var EXTENT_TYPES = {};
  var CUSTOM_TYPE_VALUE = "custom";
  var toTypeSpec = function toTypeSpec(s) {
    return baja.$('baja:TypeSpec', s);
  };
  var addExtentType = function addExtentType(key, value) {
    EXTENT_TYPES["bqlQueryBuilder.".concat(key)] = value;
  };
  var NON_CUSTOM_TYPES = [];
  var predefinedTypeSpec = function predefinedTypeSpec(str) {
    var typeSpec = toTypeSpec(str);
    var typeSpecStr = typeSpec.encodeToString();
    NON_CUSTOM_TYPES.push(typeSpecStr);
    return typeSpecStr;
  };
  addExtentType('common.component', predefinedTypeSpec('baja:Component'));
  addExtentType('common.folder', predefinedTypeSpec('baja:Folder'));
  addExtentType('common.control', predefinedTypeSpec('control:ControlPoint'));
  addExtentType('common.boolean', predefinedTypeSpec('control:BooleanPoint'));
  addExtentType('common.enum', predefinedTypeSpec('control:EnumPoint'));
  addExtentType('common.numeric', predefinedTypeSpec('control:NumericPoint'));
  addExtentType('common.string', predefinedTypeSpec('control:StringPoint'));
  addExtentType('common.alarmClass', predefinedTypeSpec('alarm:AlarmClass'));
  addExtentType('common.program', predefinedTypeSpec('program:Program'));
  addExtentType('common.schedule', predefinedTypeSpec('schedule:AbstractSchedule'));
  addExtentType('common.custom', CUSTOM_TYPE_VALUE);
  var isCustomType = function isCustomType(typeSpec) {
    return typeSpec === CUSTOM_TYPE_VALUE || !NON_CUSTOM_TYPES.includes(typeSpec);
  };
  var DEFAULT_TYPE_STR = 'baja:Component';
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-BqlBuilder-extentType'
      }
    };
  };
  var ExtentTypeChooser = /*#__PURE__*/function (_spandrel) {
    function ExtentTypeChooser(params) {
      var _this;
      _classCallCheck(this, ExtentTypeChooser);
      _this = _callSuper(this, ExtentTypeChooser, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.on(VALUE_READY_EVENT, function () {
        var customTypeEditor = _this.$getCustomTypeEditor();
        if (!customTypeEditor) {
          return;
        }
        var _this$state = _this.state(),
          customTypeSpec = _this$state.customTypeSpec;
        customTypeEditor.emit(VALUE_READY_EVENT, customTypeSpec);
      });
      return _this;
    }

    /**
     * @param {baja.Simple} extent extent as `baja:TypeSpec`
     * @returns {module:nmodule/bql/rc/builder/ExtentTypeChooser~ExtentTypeChooserState}
     */
    _inherits(ExtentTypeChooser, _spandrel);
    return _createClass(ExtentTypeChooser, [{
      key: "toState",
      value: function toState(extent) {
        var extentString = extent && String(extent);
        if (!extentString || extentString === 'null') {
          extentString = DEFAULT_TYPE_STR;
        }
        return {
          mainExtent: isCustomType(extentString) ? CUSTOM_TYPE_VALUE : extentString,
          customTypeSpec: toTypeSpec(extentString)
        };
      }

      /**
       * @param {module:nmodule/bql/rc/builder/ExtentTypeChooser~ExtentTypeChooserState} state
       * @returns {baja.Simple} extent as `baja:TypeSpec`
       */
    }, {
      key: "fromState",
      value: function fromState(_ref) {
        var mainExtent = _ref.mainExtent,
          customTypeSpec = _ref.customTypeSpec;
        return mainExtent === CUSTOM_TYPE_VALUE ? customTypeSpec : toTypeSpec(mainExtent);
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getMainExtentEditor",
      value: function $getMainExtentEditor() {
        return this.queryWidget('mainExtent');
      }

      /**
       * @private
       * @return {module:bajaux/Widget|undefined}
       */
    }, {
      key: "$getCustomTypeEditor",
      value: function $getCustomTypeEditor() {
        return this.queryWidget('customTypeSpec');
      }
    }]);
  }(spandrel(function (extent, _ref2) {
    var customTypeSpec = _ref2.customTypeSpec,
      mainExtent = _ref2.mainExtent;
    return [spandrel.jsx(OrderedMapEditor, {
      value: mainExtent,
      bind: true,
      spandrelKey: "mainExtent",
      className: "-t-mainDropDown",
      properties: {
        lexicon: 'workbench',
        lexiconIcons: true,
        map: EXTENT_TYPES
      }
    }), isCustomType(mainExtent) && spandrel.jsx("any", {
      value: customTypeSpec,
      className: "-t-customTypeSpec",
      lax: true,
      bind: true,
      spandrelKey: "customTypeSpec",
      properties: {
        showAbstract: true,
        showInterface: true
      }
    })];
  }, {
    strategy: 'niagara'
  }));
  return ExtentTypeChooser;
});

/**
 * @typedef module:nmodule/bql/rc/builder/ExtentTypeChooser~ExtentTypeChooserState
 * @property {string} mainExtent
 * @property {baja.Simple} customTypeSpec
 */
