function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bql/rc/builder/commands/SaveToUserDataCommand
 */
define(['lex!bql', 'log!nmodule.bql.rc.builder.commands.SaveToUserDataCommand', 'bajaux/commands/Command', 'bajaux/spandrel', 'dialogs', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/servlets/userData'], function (lexs, log, Command, spandrel, dialogs, Promise, _, feDialogs, userData) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    bql = _lexs[0];
  var logSevere = log.severe.bind(log);
  var SAVE_QUERY_TEXT = bql.get('commands.SaveToUserDataCommand.label');
  var NAME_TEXT = bql.get('commands.SaveToUserDataCommand.InfoWidget.name');
  var VALUE_TEXT = bql.get('commands.SaveToUserDataCommand.InfoWidget.value');
  var OVERWRITE_TEXT = bql.get('commands.SaveToUserDataCommand.InfoWidget.overwrite'); // NCCB-53848

  function getUserDataObj(userDataKey) {
    return userData.getJson(userDataKey, {});
  }
  var infoWidgetDefaults = function infoWidgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-InfoWidget'
      }
    };
  };
  var InfoWidget = /*#__PURE__*/function (_spandrel) {
    function InfoWidget(params) {
      _classCallCheck(this, InfoWidget);
      return _callSuper(this, InfoWidget, [{
        params: params,
        defaults: infoWidgetDefaults()
      }]);
    }
    _inherits(InfoWidget, _spandrel);
    return _createClass(InfoWidget, [{
      key: "doRead",
      value: function doRead() {
        return Promise.all([this.queryWidget('name').read(), this.queryWidget('value').read()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            readName = _ref2[0],
            readValue = _ref2[1];
          return {
            name: readName,
            value: readValue
          };
        });
      }
    }]);
  }(spandrel(function (_ref3) {
    var value = _ref3.value,
      name = _ref3.name;
    return [spandrel.jsx("label", {
      spandrelKey: "nameLabel"
    }, NAME_TEXT), spandrel.jsx("any", {
      spandrelKey: "name",
      value: name,
      className: "-t-InfoWidget-string"
    }), spandrel.jsx("label", {
      spandrelKey: "valueLabel"
    }, VALUE_TEXT), spandrel.jsx("any", {
      spandrelKey: "value",
      value: value,
      className: "-t-InfoWidget-string"
    })];
  }, {
    strategy: 'niagara'
  }));
  function saveToUserData(userDataKey, dataObj, name, value) {
    dataObj[name] = value;
    return userData.putJson(userDataKey, dataObj);
  }
  function showInfoDialog(userDataKey, name, value) {
    return Promise.resolve(_.isFunction(value) ? value() : value).then(function (str) {
      return Promise.all([feDialogs.showFor({
        title: SAVE_QUERY_TEXT,
        value: {
          name: name,
          value: str
        },
        type: InfoWidget
      }), getUserDataObj(userDataKey)]);
    }).then(function (_ref4) {
      var _ref5 = _slicedToArray(_ref4, 2),
        dialogResult = _ref5[0],
        dataObj = _ref5[1];
      if (!dialogResult) {
        return;
      }
      var name = dialogResult.name,
        value = dialogResult.value;
      if (!dataObj[name]) {
        return saveToUserData(userDataKey, dataObj, name, value);
      }
      dialogs.showOkCancel({
        text: OVERWRITE_TEXT,
        ok: function ok() {
          return saveToUserData(userDataKey, dataObj, name, value)["catch"](logSevere);
        }
      });
    });
  }

  /**
   * A command to save a provided value in user data.
   *
   * The data will be stored as a string encoded JSON object. This allows a given user data key to
   * support different value slots to be extracted from later.
   *
   * @class
   * @alias module:nmodule/bql/rc/builder/SaveToUserDataCommand
   * @extends module:bajaux/commands/Command
   */
  var SaveToUserDataCommand = /*#__PURE__*/function (_Command) {
    /**
     * Save the provided information to user data.
     *
     * @param {Object} params
     * @param {String} params.userDataKey the key to get the user's data from in storage
     * @param {String} params.name the item's key for the object stored in user data.
     * @param {Function|String} params.value a function that returns a string or a promise that
     * resolves to a string.
     */
    function SaveToUserDataCommand(_ref6) {
      var userDataKey = _ref6.userDataKey,
        _ref6$name = _ref6.name,
        name = _ref6$name === void 0 ? '' : _ref6$name,
        value = _ref6.value;
      _classCallCheck(this, SaveToUserDataCommand);
      return _callSuper(this, SaveToUserDataCommand, [{
        module: 'bql',
        lex: 'commands.SaveToUserDataCommand',
        func: function func() {
          return showInfoDialog(userDataKey, name, value);
        }
      }]);
    }
    _inherits(SaveToUserDataCommand, _Command);
    return _createClass(SaveToUserDataCommand);
  }(Command);
  return SaveToUserDataCommand;
});
