function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module module:nmodule/bql/rc/util/DynamicTimeRange
 */

define(['baja!', 'baja!bql:DynamicTimeRangeType', 'underscore'], function (baja, types, _) {
  'use strict';

  var TIME_RANGE_TAG = 'timeRange';
  var CUSTOM_RANGE_TYPE = baja.$('bql:DynamicTimeRangeType', TIME_RANGE_TAG);
  var DEFAULT_ABS_TIME = baja.AbsTime.DEFAULT;

  /**
   * Representation of a `bql:DynamicTimeRange`.
   * @alias module:nmodule/bql/rc/util/DynamicTimeRange
   */
  var DynamicTimeRange = /*#__PURE__*/function (_baja$Simple) {
    /**
     * Creates a {module:nmodule/bql/rc/util/DynamicTimeRange} instance.
     *
     * @param {Object} obj the parameters to create the dynamic time range with
     * @param {baja.AbsTime} [obj.startTime=baja.AbsTime.DEFAULT] the fixed start time for this
     * dynamic time range if needed.
     * @param {baja.AbsTime} [obj.endTime=baja.AbsTime.DEFAULT] the fixed end time for this
     * dynamic time range if needed.
     * @param {baja.FrozenEnum} [obj.rangeType='timeRange'] where the frozen enum is a
     * `bql:DynamicTimeRangeType`. This determines the underlying type of time range to use for
     * this dynamic time range. This can be a custom time range that will allow for specification of
     * a fixed start and/or end time, or it can be a predetermined time rage such as `today` or
     * `lastWeek`.
     */
    function DynamicTimeRange(obj) {
      var _this;
      _classCallCheck(this, DynamicTimeRange);
      _this = _callSuper(this, DynamicTimeRange);
      var _obj$startTime = obj.startTime,
        startTime = _obj$startTime === void 0 ? DEFAULT_ABS_TIME : _obj$startTime,
        _obj$endTime = obj.endTime,
        endTime = _obj$endTime === void 0 ? DEFAULT_ABS_TIME : _obj$endTime,
        _obj$rangeType = obj.rangeType,
        rangeType = _obj$rangeType === void 0 ? CUSTOM_RANGE_TYPE : _obj$rangeType;
      _this.$startTime = startTime;
      _this.$endTime = endTime;
      _this.$rangeType = rangeType;
      return _this;
    }

    /**
     * If provided a string, it will use that to create the underlying time range such as `today` or
     * `lastWeek`; otherwise, the provided object will be passed directly to the constructor. See
     * the constructor for details.
     *
     * @param {Object|string} obj
     * @returns {module:nmodule/bql/rc/util/DynamicTimeRange}
     */
    _inherits(DynamicTimeRange, _baja$Simple);
    return _createClass(DynamicTimeRange, [{
      key: "make",
      value: function make() {
        return DynamicTimeRange.make.apply(DynamicTimeRange, arguments);
      }

      /**
       * Turns the query parameters part of a history query into a `bql:DynamicTimeRange`.
       *
       * @param {String} ordParams the ordParams to parse to a `bql:DynamicTimeRange`. Ex:
       * `period=today`, `period=lastWeek`, or `period=yesterday`. If the timeRange encoding is
       * provided, it will parse out the fixed start and end times.
       * @returns {module:nmodule/bql/rc/util/DynamicTimeRange}
       */
    }, {
      key: "encodeToString",
      value:
      /**
       * Encodes this `bql:DynamicTimeRange` into a string.
       * @returns {string}
       */
      function encodeToString() {
        var tag = this.$rangeType.getTag();
        if (tag !== TIME_RANGE_TAG) {
          return tag;
        }
        return "".concat(tag, ":startTime=").concat(this.$startTime.encodeToString(), ";endTime=").concat(this.$endTime.encodeToString());
      }

      /**
       * Decodes the given string into `bql:DynamicTimeRange`.
       * @params {str} the string to decode
       * @returns {module:nmodule/bql/rc/util/DynamicTimeRange}
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(str) {
        var colon = str.indexOf(":");
        if (colon === -1) {
          return DynamicTimeRange.make(str);
        }
        var typeString = str.substring(0, colon);
        if (typeString !== TIME_RANGE_TAG) {
          throw new Error("Invalid string encoding: ".concat(str));
        }
        var rangeType = CUSTOM_RANGE_TYPE;
        var semi = str.indexOf(";");
        var startParam = str.substring(colon + 1, semi);
        var startEq = startParam.indexOf("=");
        if (startEq === -1) {
          throw new Error("Invalid string encoding: ".concat(str));
        }
        if (startParam.substring(0, startEq) !== "startTime") {
          throw new Error("Invalid string encoding: ".concat(str));
        }
        var startTime = DEFAULT_ABS_TIME.decodeFromString(startParam.substring(startEq + 1));
        var endParam = str.substring(semi + 1);
        var endEq = endParam.indexOf("=");
        if (endParam.substring(0, endEq) !== "endTime") {
          throw new Error("Invalid string encoding: ".concat(str));
        }
        var endTime = DEFAULT_ABS_TIME.decodeFromString(endParam.substring(endEq + 1));
        return DynamicTimeRange.make({
          rangeType: rangeType,
          startTime: startTime,
          endTime: endTime
        });
      }

      /**
       * Gets the fixed start time. This is the start time applied if the `timeRange` range type is
       * being used.
       * @returns {baja.AbsTime} the fixed start time. If there is no fixed start time, this will
       * return baja.AbsTime.DEFAULT.
       */
    }, {
      key: "getFixedStartTime",
      value: function getFixedStartTime() {
        return this.$startTime;
      }

      /**
       * Gets the fixed end time. This is the end time applied if the `timeRange` range type is
       * being used.
       *
       * @returns {baja.AbsTime} the fixed end time. If there is no fixed end time, this will
       * return baja.AbsTime.DEFAULT.
       */
    }, {
      key: "getFixedEndTime",
      value: function getFixedEndTime() {
        return this.$endTime;
      }

      /**
       * Gets the range type for different ranges such as `today`, `lastWeek`, or `timeRange`.
       * @returns {baja.FrozenEnum} where the enum is a `bql:DynamicTimeRangeType`
       */
    }, {
      key: "getRangeType",
      value: function getRangeType() {
        return this.$rangeType;
      }

      /**
       * Turns this `bql:DynamicTimeRange` into param string to be used in a history query.
       *
       * @returns {string}
       */
    }, {
      key: "toOrdParams",
      value: function toOrdParams() {
        var tag = this.$rangeType.getTag();
        if (tag !== TIME_RANGE_TAG) {
          return "period=".concat(tag);
        }
        var startTime = this.$startTime;
        var endTime = this.$endTime;
        var str = "period=".concat(tag);
        if (startTime !== DEFAULT_ABS_TIME) {
          str += ";start=".concat(startTime.encodeToString());
        }
        if (endTime !== DEFAULT_ABS_TIME) {
          str += ";end=".concat(endTime.encodeToString());
        }
        return str;
      }
    }], [{
      key: "make",
      value: function make(obj) {
        if (_.isString(obj)) {
          return new DynamicTimeRange({
            rangeType: baja.$('bql:DynamicTimeRangeType', obj)
          });
        }
        return new DynamicTimeRange(obj);
      }
    }, {
      key: "fromOrdParams",
      value: function fromOrdParams(ordParams) {
        var rangeTag = ordParams.substring("period=".length);
        if (!rangeTag.startsWith(TIME_RANGE_TAG)) {
          return DynamicTimeRange.DEFAULT.decodeFromString(rangeTag);
        }
        var startTime = DEFAULT_ABS_TIME;
        var endTime = DEFAULT_ABS_TIME;
        var params = ordParams.split(";").map(function (param) {
          return param.trim();
        });
        params.forEach(function (param) {
          if (param.startsWith("start=")) {
            startTime = DEFAULT_ABS_TIME.decodeFromString(param.substring("start=".length));
          }
          if (param.startsWith("end=")) {
            endTime = DEFAULT_ABS_TIME.decodeFromString(param.substring("end=".length));
          }
        });
        return DynamicTimeRange.make({
          startTime: startTime,
          endTime: endTime,
          rangeType: CUSTOM_RANGE_TYPE
        });
      }
    }]);
  }(baja.Simple);
  DynamicTimeRange.DEFAULT = DynamicTimeRange.make({
    startTime: DEFAULT_ABS_TIME,
    endTime: DEFAULT_ABS_TIME,
    rangeType: CUSTOM_RANGE_TYPE
  });
  return DynamicTimeRange;
});
