/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @module bajaux/container/wb/StringList
 */
define(["jquery"], function ($) {
  "use strict";

  /**
   * A fake DOMStringList for use with the Clipboard in the Workbench
   * Web Browser.
   *
   * @class
   * @alias module:bajaux/container/wb/StringList
   * @see module:bajaux/container/wb/Clipboard
   * @see http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMStringList
   */
  var StringList = function StringList() {
    /**
     * The current size of the StringList.
     * @type {Number}
     * @readonly
     */
    this.length = 0;
    this.$list = [];
  };

  /**
   * Return an item from list via its index.
   * 
   * @param  {Number} index
   * @returns a String from the list.
   */
  StringList.prototype.item = function (index) {
    return this.$list[index];
  };

  /**
   * Returns true if the string is the list.
   * 
   * @param  {String} str The String to query the list with.
   * @returns {Boolean} true if the string is in the list.
   */
  StringList.prototype.contains = function (str) {
    return $.inArray(str, this.$list) > -1;
  };

  /**
   * Add a string to the list.
   * 
   * @param {String} str The string to add.
   */
  StringList.prototype.add = function (str) {
    var that = this;
    if (!that.contains(str)) {
      that.$list.push(str);
      that.length = that.$list.length;
    }
  };

  /**
   * Remove an item for the list.
   * 
   * @param  {String} str The string to remove.
   */
  StringList.prototype.remove = function (str) {
    var i,
      that = this;
    for (i = 0; i < that.$list.length; ++i) {
      if (that.$list[i] === str) {
        that.$list.splice(i, 1);
        break;
      }
    }
    that.length = that.$list.length;
  };
  return StringList;
});
