function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @private
 * @module bajaux/registry/impl/JsRegistry
 */
define(['underscore', 'bajaux/registry/RegistryEntry'], function (_, RegistryEntry) {
  'use strict';

  ////////////////////////////////////////////////////////////////
  // JsRegistry
  ////////////////////////////////////////////////////////////////

  /**
   * A simple registry for keeping a collection of JS information. This is
   * used to map different keys to collections of RequireJS modules. Each
   * entry gets tagged with different metadata so that you can map many
   * different RequireJS modules of different types to the same key, and query
   * them as needed.
   *
   * In a BajaScript environment, for instance, the key will be a Type Spec,
   * and a collection of RequireJS modules (e.g. Widgets, MenuAgents) will be
   * mapped to those type specs.
   *
   * @private
   * @class
   * @alias module:bajaux/registry/impl/JsRegistry
   * @param {Object} [db] a JSON object to use to initially build this registry
   * (typically will be used to reconstitute a registry using the previous
   * output of `toJSON`). If omitted, registry will be empty on creation.
   * @since Niagara 4.10
   */
  return /*#__PURE__*/function () {
    function JsRegistry(db) {
      _classCallCheck(this, JsRegistry);
      this.$db = fromObj(db || {});
      this.$matchers = [];
    }

    /**
     * Returns the backing database object.
     *
     * @private
     * @returns {Object}
     */
    return _createClass(JsRegistry, [{
      key: "$getDatabase",
      value: function $getDatabase() {
        return this.$db;
      }

      /**
       * Register a RequireJS module, along with other optional metadata, under the
       * given key. You can also register a matcher function that will receive an
       * object to match against, as well as additional query params.
       *
       * @param {String|Function} key
       * @param {Object|String} params object literal containing metadata. This may
       * be a string, which is equivalent to registering the RequireJS module ID
       * directly with no metadata at all.
       * @param {String} params.rjs the RequireJS module ID
       * @param {Array.<String>} [params.deps] Dependencies to require before
       * loading the RequireJS module
       *
       * @example
       * <caption>Register MyStringEditor for any query for the 'string'
       * key.</caption>
       * db.register('string', { rjs: 'nmodule/myModule/rc/MyStringEditor' });
       *
       * @example
       * <caption>Register MyStringEditor only if querying for a mini editor on a
       * string.</caption>
       * db.register(function (value, params) {
       *    return typeof value === 'string' &&
       *      (params.tags || []).contains('web:IFormFactorMini');
       * }, { rjs: 'nmodule/myModule/rc/MyStringEditor' });
       */
    }, {
      key: "register",
      value: function register(key, params) {
        var db = this.$db;
        if (typeof params === 'string') {
          params = {
            rjs: params
          };
        }
        if (!key || !params) {
          throw new Error('key and params required');
        }
        if (!params.rjs) {
          throw new Error('RequireJS module id required');
        }
        if (typeof key === 'function') {
          this.$matchers.push({
            matcher: key,
            entry: new RegistryEntry(params)
          });
        } else {
          var records = db[key] || (db[key] = []),
            existing = findAllMatching(records, params);
          if (!existing.length) {
            records.push(new RegistryEntry(params));
          }
        }
      }

      /**
       * When querying entries for a value, the entries will be stored under a key
       * that is derived from that value. Override this to specify how a database
       * key is derived for a particular value.
       *
       * @param {*} value
       * @returns {string} by default, just String(value)
       */
    }, {
      key: "valueToKey",
      value: function valueToKey(value) {
        return String(value);
      }

      /**
       * Find all entries registered for this value, that match the requested
       * params. The resolved array will be returned in insertion order: the oldest
       * entry will be at index 0.
       *
       * @param {*} value
       * @param {Object} [params] query parameters. These will be passed to the
       * `matches` function of each entry to determine whether it is included in
       * the resolved array.
       * @returns {Array.<module:bajaux/registry/RegistryEntry>}
       * array of `RegistryEntry`s (empty if no matching entries found).
       */
    }, {
      key: "queryAll",
      value: function queryAll(value, params) {
        var matcherEntries = this.$matchers.map(function (_ref) {
          var matcher = _ref.matcher,
            entry = _ref.entry;
          return matcher(value, params || {}) && entry;
        }).filter(_.identity);
        return findAllMatching(this.$db[this.valueToKey(value)], params).concat(matcherEntries);
      }

      /**
       * Find the first entry registered under this key that matches the requested
       * params. Entries registered later chronologically are considered first;
       * that is, this will return the most-recently-registered matching entry.
       *
       * @param {*} value
       * @param params
       * @returns {module:bajaux/registry/RegistryEntry|undefined}
       */
    }, {
      key: "queryFirst",
      value: function queryFirst(value, params) {
        var matchers = this.$matchers;
        for (var i = matchers.length - 1; i >= 0; i--) {
          var _matchers$i = matchers[i],
            matcher = _matchers$i.matcher,
            entry = _matchers$i.entry;
          if (matcher(value, params || {})) {
            return entry;
          }
        }
        return findFirstMatching(this.$db[this.valueToKey(value)], params);
      }

      /**
       * Return an object suitable for serialization using `JSON.stringify` or
       * similar. The returned object can be passed right back to a `JsRegistry`
       * constructor to reconstitute later.
       *
       * @returns {Object}
       */
    }, {
      key: "toJSON",
      value: function toJSON() {
        var json = {};
        _.each(this.$db, function (arr, key) {
          json[key] = _.map(arr, function (entry) {
            return entry.toJSON();
          });
        });
        return json;
      }
    }]);
  }();

  ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////

  /**
   * Find all entries that match the given parameters.
   *
   * @inner
   * @param {Array.<module:bajaux/registry/RegistryEntry>} entries
   * @param {Object} params
   * @returns {Array.<module:bajaux/registry/RegistryEntry>}
   * array of matching entries
   */
  function findAllMatching(entries, params) {
    return _.filter(entries || [], function (entry) {
      return entry.matches(params);
    });
  }

  /**
   * Find the first matching entry in the array of entries. Will start looking
   * at the end first - so more recently registered entries come back first.
   *
   * @inner
   * @param {Array.<module:bajaux/registry/RegistryEntry>} entries
   * @param {Object} params
   * @returns {module:bajaux/registry/RegistryEntry|undefined}
   * matching entry, or undefined if none found
   */
  function findFirstMatching(entries, params) {
    if (!entries) {
      return;
    }
    for (var i = entries.length - 1; i >= 0; i--) {
      if (entries[i].matches(params)) {
        return entries[i];
      }
    }
  }

  /**
   * Reconstitutes a database object from a plain JSON object (output previously
   * from `toJSON()`.
   *
   * @inner
   * @param {Object} db raw JSON object
   * @returns {Object} reconstituted database object
   */
  function fromObj(db) {
    _.each(db, function (arr) {
      _.each(arr, function (obj, i) {
        arr[i] = new RegistryEntry(obj);
      });
    });
    return db;
  }
});
