function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/httpClient/rc/column/PropertyPathEditorMgrColumn
 */
define(['baja!', 'bajaux/events', 'bajaux/util/CommandButton', 'jquery', 'log!nmodule.httpClient.rc.column.PropertyPathEditorMgrColumn', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/ValueWithPopoutWidget', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn'], function (baja, events, CommandButton, $, log, fe, ValueWithPopoutWidget, PropertyPathMgrColumn) {
  'use strict';

  var logSevere = log.severe.bind(log),
    MODIFY_EVENT = events.MODIFY_EVENT;

  /**
   * Column that shows an editor for its value.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn
   * @alias module:nmodule/httpClient/rc/column/PropertyPathEditorMgrColumn
   * @since Niagara 4.14
   */
  return /*#__PURE__*/function (_PropertyPathMgrColum) {
    function PropertyPathEditorMgrColumn(propertyName, params) {
      var _this;
      _classCallCheck(this, PropertyPathEditorMgrColumn);
      _this = _callSuper(this, PropertyPathEditorMgrColumn, [propertyName.replaceAll('.', '/'), params]); // PropertyPathMgrColumn wants /'s, not .'s
      _this.$propertyName = propertyName;
      return _this;
    }

    /**
     * @returns {String}
     */
    _inherits(PropertyPathEditorMgrColumn, _PropertyPathMgrColum);
    return _createClass(PropertyPathEditorMgrColumn, [{
      key: "getEditorColumnPropertyName",
      value: function getEditorColumnPropertyName() {
        return this.$propertyName;
      }

      /**
       * Shows a display string of the desired property value of the row's
       * loaded Complex.
       *
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @param {JQuery} dom
       * @returns {Promise} resolves when the cell has been built
       */
    }, {
      key: "buildCell",
      value: function buildCell(row, dom) {
        var _this2 = this;
        var nameForCss = this.$getNameForCss();
        return fe.buildFor({
          dom: $('<span class="value-editor-' + nameForCss + '"/>').appendTo(dom),
          formFactor: 'mini',
          value: this.getValueFor(row),
          type: ValueWithPopoutWidget
        }).then(function (ed) {
          _this2.$setEditorFor(ed, row);
        }).then(function () {
          var editor = _this2.getEditorFor(row);
          // need to save any changes, so that when the table refreshes, for example adding columns/rows,
          // the values already entered are remembered.
          editor.jq().on(MODIFY_EVENT, function () {
            editor.read().then(function (value) {
              return _this2.commit(value, row, {});
            })["catch"](logSevere);
          });
        });
      }

      /**
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @returns {module:bajaux/Widget} the field editor being used for the column on this row
       *
       */
    }, {
      key: "getEditorFor",
      value: function getEditorFor(row) {
        return row[this.$getEditorObjectKey()];
      }

      /**
       * set the field editor being used for the column on this row
       * @private
       * @param {module:bajaux/Widget} editor
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       */
    }, {
      key: "$setEditorFor",
      value: function $setEditorFor(editor, row) {
        row[this.$getEditorObjectKey()] = editor;
      }

      /**
       * @private
       * @returns {String}
       */
    }, {
      key: "$getEditorObjectKey",
      value: function $getEditorObjectKey() {
        return 'editor-' + this.getEditorColumnPropertyName().replaceAll('.', '-');
      }

      /**
       * @private
       * @returns {String}
       */
    }, {
      key: "$getNameForCss",
      value: function $getNameForCss() {
        return this.getEditorColumnPropertyName().replaceAll('.', '-');
      }
    }]);
  }(PropertyPathMgrColumn);
});
