function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/* global niagara */

/**
 * API Status: **Private**
 * @module nmodule/niagaraDriver/rc/wb/mgr/commands/NiagaraCertManagerHyperlinkCommand
 */

define(['baja!', 'bajaux/commands/Command', 'nmodule/webEditors/rc/wb/mgr/commands/MgrCommand'], function (baja, Command, MgrCommand) {
  'use strict';

  var ACTION_BAR = MgrCommand.flags.ACTION_BAR;
  var CERT_ORD = baja.isOffline() ? baja.Ord.make("tool:platCrypto:UxCertManagerTool|slot:/") : baja.Ord.make("station:|service:platCrypto:CertManagerService|view:platCrypto:UxCertManager");

  /**
   * A command that provides a hyperlink to the UX certificate manager
   * @class
   * @since Niagara 4.13
   * @alias module:nmodule/niagaraDriver/rc/wb/mgr/commands/NiagaraCertManagerHyperlinkCommand
   * @extends module:bajaux/commands/Command
   */
  var NiagaraCertManagerHyperlinkCommand = /*#__PURE__*/function (_Command) {
    function NiagaraCertManagerHyperlinkCommand() {
      _classCallCheck(this, NiagaraCertManagerHyperlinkCommand);
      return _callSuper(this, NiagaraCertManagerHyperlinkCommand, [{
        module: 'niagaraDriver',
        lex: 'commands.mgr.certManagerHyperlink',
        enabled: false,
        flags: ACTION_BAR,
        /**
         * Hyperlink to the certificate manager
         *
         * @alias module:nmodule/webEditors/rc/wb/mgr/commands/MatchCommand#invoke
         * @returns {Promise}
         */
        func: function func() {
          niagara.env.hyperlink(CERT_ORD);
        }
      }]);
    }

    /**
     * Sets the commands initial state, specifically if it is enabled or not
     * @returns {Promise}
     */
    _inherits(NiagaraCertManagerHyperlinkCommand, _Command);
    return _createClass(NiagaraCertManagerHyperlinkCommand, [{
      key: "init",
      value: function init() {
        var _this = this;
        return this.$chkPermissions().then(function (enable) {
          _this.setEnabled(enable);
        });
      }

      /**
       * Performs the necessary changes to determine if the command should be enabled or not
       * @private
       * @returns {Promise<boolean>}
       */
    }, {
      key: "$chkPermissions",
      value: function $chkPermissions() {
        return CERT_ORD.resolve().then(function (ordTarget) {
          return ordTarget.canWrite();
        })["catch"](function (ignore) {
          return false;
        });
      }

      /**
       * Creates a new NiagaraCertManagerHyperlinkCommand
       * @returns {Promise<module:nmodule/niagaraDriver/rc/wb/mgr/commands/NiagaraCertManagerHyperlinkCommand>}
       */
    }], [{
      key: "make",
      value: function make() {
        var cmd = new NiagaraCertManagerHyperlinkCommand();
        return cmd.init().then(function () {
          return cmd;
        });
      }
    }]);
  }(Command);
  return NiagaraCertManagerHyperlinkCommand;
});
