function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/niagaraDriver/rc/wb/mgr/model/NiagaraHistoryExportLearnNode
 */

define(['baja!', 'Promise', 'nmodule/history/rc/baja/HistoryId', 'nmodule/webEditors/rc/wb/tree/TreeNode'], function (baja, Promise, HistoryId, TreeNode) {
  'use strict';

  function getName(value) {
    var deviceName = value.deviceName;
    var name = value.displayName;
    return deviceName || name;
  }
  function getDisplayName(value) {
    return getName(value);
  }

  /**
   * A history node for the Niagara History Export Discovery
   * @class
   * @alias module:nmodule/niagaraDriver/rc/wb/mgr/model/NiagaraHistoryExportLearnNode
   * @extends module:nmodule/webEditors/rc/wb/tree/TreeNode
   * @since Niagara 4.14
   */
  return /*#__PURE__*/function (_TreeNode) {
    function NiagaraHistoryExportLearnNode(value, name, displayName) {
      var _this;
      _classCallCheck(this, NiagaraHistoryExportLearnNode);
      var nodeName = name || getName(value);
      var nodeDisplayName = displayName || getDisplayName(value);
      _this = _callSuper(this, NiagaraHistoryExportLearnNode, [nodeName, nodeDisplayName]);
      _this.$value = value;
      _this.$parent = null;
      _this.$historyId = HistoryId.DEFAULT.decodeFromString(_this.getId());
      return _this;
    }
    _inherits(NiagaraHistoryExportLearnNode, _TreeNode);
    return _createClass(NiagaraHistoryExportLearnNode, [{
      key: "getIcon",
      value: function getIcon() {
        return baja.Icon.make([this.$value.icon]);
      }
    }, {
      key: "getId",
      value: function getId() {
        var value = this.$value;
        var id = value.id;
        var name = value.deviceName;
        if (!id) {
          return "/" + name + "/";
        }
        return id;
      }
    }, {
      key: "getHistoryId",
      value: function getHistoryId() {
        return this.$historyId;
      }
    }, {
      key: "getSystemTags",
      value: function getSystemTags() {
        var value = this.$value;
        return value.systemTags || "";
      }
    }, {
      key: "mayHaveKids",
      value: function mayHaveKids() {
        var navChildren = this.$value.navChildren;
        return !!navChildren;
      }
    }, {
      key: "value",
      value: function value() {
        return {
          displayName: getDisplayName(this.$value),
          historyId: this.$historyId,
          systemTagPatterns: this.getSystemTags(),
          type: this.$isKid() ? "history:History" : "history:HistoryDevice"
        };
      }

      /**
       * @private
       * @returns {boolean}
       */
    }, {
      key: "$isKid",
      value: function $isKid() {
        return !!this.getParent();
      }

      /**
       * @private
       * @override
       * @returns {Promise<Array.<module:nmodule/niagaraDriver/rc/wb/mgr/NiagaraPointLearnNode>>}
       */
    }, {
      key: "$loadKids",
      value: function $loadKids() {
        var _this2 = this;
        var children = this.$value.navChildren;
        return Promise.all(children.map(function (child) {
          var kid = new NiagaraHistoryExportLearnNode(child);
          kid.$parent = _this2;
          return kid;
        }));
      }
    }]);
  }(TreeNode);
});
