/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/baja/config/BacnetAnalog
 */
define(['nmodule/bacnet/rc/baja/BacnetObject', 'nmodule/webEditors/rc/baja/bajaUtils'], function (BacnetObject, bajaUtils) {
  'use strict';

  var proxySlotFacets = bajaUtils.proxySlotFacets;

  /**
   * BajaScript representation of an `bacnet:BacnetAnalog` value.
   *
   * @class
   * @extends {module:nmodule/bacnet/rc/baja/BacnetObject}
   * @alias {module:nmodule/bacnet/rc/baja/config/BacnetAnalog}
   */
  var BacnetAnalog = function BacnetAnalog() {
    BacnetObject.apply(this, arguments);
    proxySlotFacets(this, {
      '^presentValue|highLimit|lowLimit|deadband|resolution|covIncrement$': 'facets'
    });
  };
  BacnetAnalog.prototype = Object.create(BacnetObject.prototype);
  BacnetAnalog.prototype.constructor = BacnetAnalog;
  return BacnetAnalog;
});
