/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/baja/datatypes/BacnetScale
 */
define(['baja!'], function (baja) {
  'use strict';

  var Struct = baja.Struct,
    FLOAT = 0;

  /**
   * BajaScript representation of a `bacnet:BacnetScale`.
   * @class
   * @alias module:nmodule/bacnet/rc/datatypes/BacnetScale
   * @extends baja.Struct
   */
  var BacnetScale = function BacnetScale() {
    Struct.apply(this, arguments);
  };
  BacnetScale.prototype = Object.create(Struct.prototype);
  BacnetScale.prototype.constructor = BacnetScale;

  /**
   * Return the `scale` slot formatted as an int or float depending on the
   * `choice` slot.
   * @returns {String}
   */
  BacnetScale.prototype.toString = function () {
    var choice = this.get('choice').valueOf(),
      scale = this.get('scale');
    if (choice === FLOAT) {
      return isInteger(scale) ? scale + '.0' : String(scale);
    } else {
      return scale.valueOf().toFixed(0);
    }
  };
  function isInteger(n) {
    return n % 1 === 0;
  }
  return BacnetScale;
});
