/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/baja/enums/ExtensibleEnumList
 */
define(['baja!', 'baja!bacnet:BacnetErrorClass,' + 'bacnet:BacnetErrorCode,' + 'bacnet:BacnetAbortReason,' + 'bacnet:BacnetDeviceStatus,' + 'bacnet:BacnetEngineeringUnits,' + 'bacnet:BacnetEventState,' + 'bacnet:BacnetEventType,' + 'bacnet:BacnetLifeSafetyMode,' + 'bacnet:BacnetLifeSafetyOperation,' + 'bacnet:BacnetLifeSafetyState,' + 'bacnet:BacnetMaintenance,' + 'bacnet:BacnetObjectType,' + 'bacnet:BacnetProgramError,' + 'bacnet:BacnetPropertyIdentifier,' + 'bacnet:BacnetReliability,' + 'bacnet:BacnetRejectReason,' + 'bacnet:BacnetSilencedState,' + 'bacnet:BacnetVtClass'], function (baja) {
  'use strict';

  var Struct = baja.Struct,
    ERROR_CLASS_TYPE = 'bacnet:BacnetErrorClass',
    ERROR_CODE_TYPE = 'bacnet:BacnetErrorCode',
    ABORT_REASON_TYPE = 'bacnet:BacnetAbortReason',
    DEVICE_STATUS_TYPE = 'bacnet:BacnetDeviceStatus',
    ENGINEERING_UNITS_TYPE = 'bacnet:BacnetEngineeringUnits',
    EVENT_STATE_TYPE = 'bacnet:BacnetEventState',
    EVENT_TYPE_TYPE = 'bacnet:BacnetEventType',
    LIFE_SAFETY_MODE_TYPE = 'bacnet:BacnetLifeSafetyMode',
    LIFE_SAFETY_OPERATION_TYPE = 'bacnet:BacnetLifeSafetyOperation',
    LIFE_SAFETY_STATE_TYPE = 'bacnet:BacnetLifeSafetyState',
    MAINTENANCE_TYPE = 'bacnet:BacnetMaintenance',
    OBJECT_TYPE_TYPE = 'bacnet:BacnetObjectType',
    PROGRAM_ERROR_TYPE = 'bacnet:BacnetProgramError',
    PROPERTY_IDENTIFIER_TYPE = 'bacnet:BacnetPropertyIdentifier',
    RELIABILITY_TYPE = 'bacnet:BacnetReliability',
    REJECT_REASON_TYPE = 'bacnet:BacnetRejectReason',
    SILENCED_STATE_TYPE = 'bacnet:BacnetSilencedState',
    VT_CLASS_TYPE = 'bacnet:BacnetVtClass';
  var ExtensibleEnumList = function ExtensibleEnumList() {
    Struct.apply(this, arguments);
  };
  ExtensibleEnumList.prototype = Object.create(Struct.prototype);
  ExtensibleEnumList.prototype.constructor = ExtensibleEnumList;
  function range(facets) {
    return facets.get('range');
  }

  /**
   * Return the range facets for the given property type.
   *
   * @param {String} type - the baja type for a particular property
   * @returns {baja.Facets} - the enum range obtained from the facets.
   */
  ExtensibleEnumList.prototype.getEnumRange = function (type) {
    var that = this;
    if (type) {
      switch (String(type)) {
        case ERROR_CLASS_TYPE:
          {
            return range(that.getErrorClassFacets());
          }
        case ERROR_CODE_TYPE:
          {
            return range(that.getErrorCodeFacets());
          }
        case ABORT_REASON_TYPE:
          {
            return range(that.getAbortReasonFacets());
          }
        case DEVICE_STATUS_TYPE:
          {
            return range(that.getDeviceStatusFacets());
          }
        case ENGINEERING_UNITS_TYPE:
          {
            return range(that.getEngineeringUnitsFacets());
          }
        case EVENT_STATE_TYPE:
          {
            return range(that.getEventStateFacets());
          }
        case EVENT_TYPE_TYPE:
          {
            return range(that.getEventTypeFacets());
          }
        case LIFE_SAFETY_MODE_TYPE:
          {
            return range(that.getLifeSafetyModeFacets());
          }
        case LIFE_SAFETY_OPERATION_TYPE:
          {
            return range(that.getLifeSafetyOperationFacets());
          }
        case LIFE_SAFETY_STATE_TYPE:
          {
            return range(that.getLifeSafetyStateFacets());
          }
        case MAINTENANCE_TYPE:
          {
            return range(that.getMaintenanceFacets());
          }
        case OBJECT_TYPE_TYPE:
          {
            return range(that.getObjectTypeFacets());
          }
        case PROGRAM_ERROR_TYPE:
          {
            return range(that.getProgramErrorFacets());
          }
        case PROPERTY_IDENTIFIER_TYPE:
          {
            return range(that.getPropertyIdFacets());
          }
        case RELIABILITY_TYPE:
          {
            return range(that.getReliabilityFacets());
          }
        case REJECT_REASON_TYPE:
          {
            return range(that.getRejectReasonFacets());
          }
        case SILENCED_STATE_TYPE:
          {
            return range(that.getSilencedStateFacets());
          }
        case VT_CLASS_TYPE:
          {
            return range(that.getVtClassFacets());
          }
        default:
          {
            return null;
          }
      }
    }
    return null;
  };
  return ExtensibleEnumList;
});
