/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/baja/util/BacnetBitStringUtil
 */
define(['baja!', 'lex!bacnet', 'underscore'], function (baja, lexs, _) {
  'use strict';

  var bacnetLex = lexs[0],
    bitStringFacets = {};
  function generateBitStringFacets(name) {
    var keys = ['bsName'],
      values = [name],
      numBits = parseInt(bacnetLex.get(name + '.numBits'), 10);
    if (isNaN(numBits)) {
      //couldn't parse key from lexicon
      return null;
    }
    _.each(_.range(0, numBits), function (b) {
      keys.push('bit' + b);
      values.push(bacnetLex.get(name + '.bit' + b));
    });
    return baja.Facets.make(keys, values);
  }
  var exports = {};
  exports.getBitStringFacets = function (name) {
    var facets = bitStringFacets[name];
    if (!facets) {
      facets = bitStringFacets[name] = generateBitStringFacets(name);
    }
    return facets;
  };

  /**
   *  Get the number of bits for a BacnetBitString
   *
   * @param {module:nmodule/bacnet/rc/baja/datatypes/BacnetBitString} bbs
   * @param {Object} props
   * @returns {Number}
   */
  exports.getNumBits = function (bbs, props) {
    if (props && 'bsName' in props) {
      return parseInt(bacnetLex.get(props.bsName + '.numBits'), 10);
    } else {
      return bbs.getNumBits();
    }
  };

  /**
   *  Get the bit label for the specified bit.
   *
   * @param {module:nmodule/bacnet/rc/baja/datatypes/BacnetBitString} bbs
   * @param {Object} props
   * @param {Number} bitNumber - Indexed bit number
   * @returns {String}
   */
  exports.getBitLabel = function (bbs, props, bitNumber) {
    var bitLabel = 'bit' + bitNumber;
    if (props) {
      if (bitLabel in props) {
        return props[bitLabel];
      } else {
        if ('bsName' in props) {
          return bacnetLex.get(props.bsName + '.' + bitLabel);
        }
      }
    }
    return bitLabel;
  };
  return exports;
});
