function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2025 Tridium, Inc. All Rights Reserved.
 * @author Uday Rapuru on 26-Mar-2025
 *
 * @since Niagara 4.14u2
 * @since Niagara 4.15u1
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/fe/BacnetDateTimeEditor
 */
define(['baja!', 'baja!bacnet:BacnetDateTime', 'jquery', 'Promise', 'bajaux/events', 'bajaux/spandrel', 'bajaux/mixin/batchSaveMixin'], function (baja, types, $, Promise, events, spandrel, batchSaveMixin) {
  'use strict';

  /**
   * Field editor for working with `bacnet:BacnetDateTime` instances.
   *
   * @class
   * @alias module:nmodule/bacnet/rc/fe/BacnetDateTimeEditor
   * @extends module:bajaux/spandrel/SpandrelWidget
   */
  var BacnetDateTimeEditor = /*#__PURE__*/function (_spandrel) {
    function BacnetDateTimeEditor() {
      _classCallCheck(this, BacnetDateTimeEditor);
      return _callSuper(this, BacnetDateTimeEditor, arguments);
    }
    _inherits(BacnetDateTimeEditor, _spandrel);
    return _createClass(BacnetDateTimeEditor, [{
      key: "fromState",
      value:
      /**
       *
       * @param {module:nmodule/bacnet/rc/fe/BacnetDateTimeEditor~BacnetDateTimeEditorState} { date, time }
       * @returns {baja.Struct} a Struct of type `bacnet:BacnetDateTime`
       */
      function fromState(_ref) {
        var date = _ref.date,
          time = _ref.time;
        return baja.$('bacnet:BacnetDateTime', {
          date: date,
          time: time
        });
      }

      /**
       * @param {baja.Struct} value Struct of type `bacnet:BacnetDateTime`
       * @returns {module:nmodule/bacnet/rc/fe/BacnetDateTimeEditor~BacnetDateTimeEditorState} { date, time }
       */
    }, {
      key: "toState",
      value: function toState(value) {
        return {
          date: value.getDate(),
          time: value.getTime()
        };
      }

      /**
       * @private
       * @returns {module:nmodule/bacnet/rc/fe/BacnetDateEditor} the editor for the `date` slot.
       */
    }, {
      key: "$getDateEditor",
      value: function $getDateEditor() {
        return this.queryWidget('date');
      }

      /**
       * @private
       * @returns {module:nmodule/bacnet/rc/fe/BacnetTimeEditor} the editor for the `time` slot.
       */
    }, {
      key: "$getTimeEditor",
      value: function $getTimeEditor() {
        return this.queryWidget('time');
      }

      /**
       * Overridden version of the doSave() function. save the currently entered
       * `date` and `time` values back to the `BacnetDateTime`. Respects the `batchSaveMixin` contract.
       * @param {baja.Struct} bacnetDateTime Struct of type `bacnet:BacnetDateTime` to be passed to `doSave()`
       * @param {Object} [params] Additional parameters to be passed to `doSave()`
       *
       * @returns {Promise.<baja.Component>}
       */
    }, {
      key: "doSave",
      value: function doSave(bacnetDateTime, params) {
        var batch = params && params.batch,
          progressCallback = params && params.progressCallback,
          value = this.value(),
          prom;
        prom = Promise.all([value.set({
          slot: 'date',
          value: bacnetDateTime.getDate(),
          batch: batch
        }), value.set({
          slot: 'time',
          value: bacnetDateTime.getTime(),
          batch: batch
        })]);
        if (progressCallback) {
          progressCallback(batchSaveMixin.COMMIT_READY);
        }
        return prom;
      }
    }]);
  }(spandrel(function (value, _ref2) {
    var date = _ref2.date,
      time = _ref2.time;
    return [spandrel.jsx("any", {
      tagName: "span",
      value: date,
      bind: true,
      spandrelKey: "date"
    }), spandrel.jsx("any", {
      tagName: "span",
      value: time,
      bind: true,
      spandrelKey: "time"
    })];
  }, {
    strategy: 'niagara'
  }));
  return BacnetDateTimeEditor;
});
/**
 * @typedef module:nmodule/bacnet/rc/fe/BacnetDateTimeEditor~BacnetDateTimeEditorState
 * @property {module:nmodule/bacnet/rc/baja/datatypes/BacnetDate} date currently selected date value
 * @property {module:nmodule/bacnet/rc/baja/datatypes/BacnetTime} time currently selected time value
 */
