function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2025 Tridium, Inc. All Rights Reserved.
 * @author Uday Rapuru on 21-Apr-2025
 *
 * @since Niagara 4.14u3
 * @since Niagara 4.15u2
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/fe/BacnetOptionalCharacterStringEditor
 */
define(['baja!', 'baja!bacnet:BacnetOptionalCharacterString', 'jquery', 'Promise', 'bajaux/spandrel', 'bajaux/mixin/batchSaveMixin'], function (baja, types, $, Promise, spandrel, batchSaveMixin) {
  'use strict';

  /**
   * Field editor for working with `bacnet:BacnetOptionalCharacterString` instances.
   *
   * @class
   * @alias module:nmodule/bacnet/rc/fe/BacnetOptionalCharacterStringEditor
   * @extends module:bajaux/spandrel/SpandrelWidget
   */
  var BacnetOptionalCharacterStringEditor = /*#__PURE__*/function (_spandrel) {
    function BacnetOptionalCharacterStringEditor() {
      _classCallCheck(this, BacnetOptionalCharacterStringEditor);
      return _callSuper(this, BacnetOptionalCharacterStringEditor, arguments);
    }
    _inherits(BacnetOptionalCharacterStringEditor, _spandrel);
    return _createClass(BacnetOptionalCharacterStringEditor, [{
      key: "fromState",
      value:
      /**
       *
       * @param {module:nmodule/bacnet/rc/fe/BacnetOptionalCharacterStringEditor~BacnetOptionalCharacterStringEditorState} { choice, characterString, isNull, value }
       * @returns {baja.Struct} a Struct of type `bacnet:BacnetOptionalCharacterString`
       */
      function fromState(_ref) {
        var choice = _ref.choice,
          characterString = _ref.characterString,
          isNull = _ref.isNull,
          value = _ref.value;
        return baja.$(this.value().getType(), {
          choice: isNull !== undefined ? isNull ? 0 : 1 : choice,
          characterString: value !== undefined ? value : characterString
        });
      }

      /**
       * @param {baja.Struct} value Struct of type `bacnet:BacnetOptionalCharacterString`
       * @returns {module:nmodule/bacnet/rc/fe/BacnetOptionalCharacterStringEditor~BacnetOptionalCharacterStringEditorState} { choice, characterString }
       */
    }, {
      key: "toState",
      value: function toState(value) {
        return {
          choice: value.getChoice(),
          characterString: value.getCharacterString()
        };
      }

      /**
       * Overridden version of the doSave() function. save the currently entered
       * `choice` and `characterString` values back to the `BacnetOptionalCharacterString`.
       * Respects the `batchSaveMixin` contract.
       * @param {baja.Struct} optionalCharacterString Struct of type `bacnet:BacnetOptionalCharacterString` to be passed to `doSave()`
       * @param {Object} [params] Additional parameters to be passed to `doSave()`
       *
       * @returns {Promise.<baja.Component>}
       */
    }, {
      key: "doSave",
      value: function doSave(optionalCharacterString, params) {
        var batch = params && params.batch,
          progressCallback = params && params.progressCallback,
          value = this.value(),
          prom;
        prom = Promise.all([value.set({
          slot: 'choice',
          value: optionalCharacterString.getChoice(),
          batch: batch
        }), value.set({
          slot: 'characterString',
          value: optionalCharacterString.getCharacterString(),
          batch: batch
        })]);
        if (progressCallback) {
          progressCallback(batchSaveMixin.COMMIT_READY);
        }
        return prom;
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/fe/baja/BooleanEditor} the editor for the `isNull` slot.
       */
    }, {
      key: "$getNullEditor",
      value: function $getNullEditor() {
        return this.queryWidget('isNull');
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/fe/baja/StringEditor} the editor for the `value` slot.
       */
    }, {
      key: "$getValueEditor",
      value: function $getValueEditor() {
        return this.queryWidget('value');
      }
    }]);
  }(spandrel(function (value) {
    var isNull = value.getChoice() === 0;
    return [spandrel.jsx("any", {
      value: isNull,
      displayType: "checkbox",
      properties: {
        trueText: 'null',
        falseText: 'null'
      },
      bind: true,
      spandrelKey: "isNull"
    }), spandrel.jsx("any", {
      value: value.getCharacterString(),
      readonly: isNull,
      bind: true,
      spandrelKey: "value"
    })];
  }, {
    strategy: 'niagara'
  }));
  return BacnetOptionalCharacterStringEditor;
});
/**
 * @typedef module:nmodule/bacnet/rc/fe/BacnetOptionalCharacterStringEditor~BacnetOptionalCharacterStringEditorState
 * @property {module:nmodule/bajaui/rc/ux/CheckBox} isNull currently selected checkBox value
 * @property {String} value currently selected String value
 */
