function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/fe/BacnetScaleEditor
 */
define(['baja!', 'lex!bacnet', 'bajaux/events', 'bajaux/Widget', 'bajaux/mixin/batchSaveMixin', 'Promise', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'css!nmodule/bacnet/rc/bacnet'], function (baja, lexs, events, Widget, batchSaveMixin, Promise, fe, BaseEditor, OrderedMapEditor, compUtils) {
  'use strict';

  var bacnetLex = lexs[0],
    bulkCopy = compUtils.bulkCopy,
    MODIFY_EVENT = events.MODIFY_EVENT,
    FLOAT_CHOICE = 0,
    INT_CHOICE = 1;
  var CHOICES = function () {
    var map = new baja.OrderedMap();
    map.put(bacnetLex.get({
      key: 'bacnetScale.float',
      def: 'Float'
    }), FLOAT_CHOICE);
    map.put(bacnetLex.get({
      key: 'bacnetScale.int',
      def: 'Int'
    }), INT_CHOICE);
    return map;
  }();

  /**
   * Field editor for working with `bacnet:BacnetScale` instances.
   *
   * @class
   * @alias module:nmodule/bacnet/rc/fe/BacnetScaleEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   */
  var BacnetScaleEditor = function BacnetScaleEditor() {
    BaseEditor.apply(this, arguments);
    batchSaveMixin(this);
  };
  BacnetScaleEditor.prototype = Object.create(BaseEditor.prototype);
  BacnetScaleEditor.prototype.constructor = BacnetScaleEditor;

  /**
   * Set event handlers to rebuild the `scale` editor as either a double or
   * integer editor, depending on which choice is selected.
   * @param {JQuery} dom
   */
  BacnetScaleEditor.prototype.doInitialize = function (dom) {
    var that = this;
    dom.html('<div class="js-choice"/><div class="js-scale"/>');
    dom.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });
    dom.on(MODIFY_EVENT, '.js-choice', function () {
      var choice = that.$getChoiceEditor().getSelectedValue(),
        scaleEd = that.$getScaleEditor();
      scaleEd.read().then(function (scale) {
        return that.$loadScale(choice, scale);
      })["catch"](baja.error);
    });
    return fe.buildFor({
      dom: dom.children('.js-choice'),
      type: OrderedMapEditor,
      value: CHOICES,
      formFactor: 'mini'
    });
  };

  /**
   * @param {baja.Struct} bacnetScale the `bacnet:BacnetScale` to load
   * @returns {Promise}
   */
  BacnetScaleEditor.prototype.doLoad = function (bacnetScale) {
    return this.$loadScale(bacnetScale.get('choice'), bacnetScale.get('scale'));
  };

  /**
   * Read a new `BacnetScale` with currently selected values.
   * @returns {Promise.<baja.Struct>}
   */
  BacnetScaleEditor.prototype.doRead = function () {
    return this.getChildEditors().readAll().then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        choice = _ref2[0],
        scale = _ref2[1];
      return baja.$('bacnet:BacnetScale', {
        choice: choice,
        scale: scale
      });
    });
  };

  /**
   * Apply the currently entered `choice` and `scale` values back to the
   * `BacnetScale`. Respects the `batchSaveMixin` contract.
   *
   * @param {baja.Struct} bacnetScale a `bacnet:BacnetScale` to save
   * @param {Object} params
   */
  BacnetScaleEditor.prototype.doSave = function (bacnetScale, params) {
    var batch = params && params.batch,
      progressCallback = params && params.progressCallback;
    var prom = bulkCopy(bacnetScale, this.value(), ['choice', 'scale'], batch);
    if (progressCallback) {
      progressCallback(batchSaveMixin.COMMIT_READY);
    }
    return prom;
  };

  /**
   * Set all child editors enabled/disabled.
   * @param {boolean} enabled
   * @returns {Promise}
   */
  BacnetScaleEditor.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };

  /**
   * Set all child editors readonly/writable.
   * @param {boolean} readonly
   * @returns {Promise}
   */
  BacnetScaleEditor.prototype.doReadonly = function (readonly) {
    return this.getChildEditors().setAllReadonly(readonly);
  };

  /**
   * Destroy all child editors.
   * @returns {Promise}
   */
  BacnetScaleEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };

  /**
   * Update the selected choice and scale values, rebuilding the `scale` editor
   * in the process as the choice may have changed.
   *
   * @private
   * @param {number|baja.Integer} choice
   * @param {number|baja.Integer} scale
   * @returns {Promise}
   */
  BacnetScaleEditor.prototype.$loadScale = function (choice, scale) {
    var that = this,
      scaleEd = that.$getScaleEditor();
    choice = choice.valueOf();
    scale = scale.valueOf();
    if (choice !== FLOAT_CHOICE) {
      scale = baja.Integer.make(scale);
    }
    return Promise.resolve(scaleEd && scaleEd.destroy()).then(function () {
      that.$getChoiceEditor().setSelectedValue(choice, true);
      return fe.buildFor({
        value: scale,
        dom: that.$getScaleElement(),
        formFactor: 'mini'
      });
    });
  };

  /**
   * Get the editor for the selected choice.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/OrderedMapEditor}
   */
  BacnetScaleEditor.prototype.$getChoiceEditor = function () {
    return Widget["in"](this.jq().children('.js-choice'));
  };

  /**
   * Get the editor for the `scale` slot (this can contain either a
   * `baja:Double` or `baja:Integer` depending on selected choice).
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/NumericEditor}
   */
  BacnetScaleEditor.prototype.$getScaleEditor = function () {
    return Widget["in"](this.$getScaleElement());
  };

  /**
   * @private
   * @returns {JQuery} element containing the `scale` editor
   */
  BacnetScaleEditor.prototype.$getScaleElement = function () {
    return this.jq().children('.js-scale');
  };
  return BacnetScaleEditor;
});
