function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/fe/BacnetTimeEditor
 */
define(['baja!', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder', 'Promise', 'jquery', 'nmodule/bacnet/rc/baja/datatypes/BacnetTime', 'nmodule/webEditors/rc/fe/fe', 'hbs!nmodule/bacnet/rc/fe/templates/BacnetTimeEditor', 'bajaux/commands/Command', 'bajaux/util/CommandButtonGroup', 'css!nmodule/bacnet/rc/bacnet'], function (baja, CompositeEditor, CompositeBuilder, Promise, $, BacnetTime, fe, templateEditor, Command, CommandButtonGroup) {
  'use strict';

  var KEY_HOUR = 'h',
    KEY_MINUTE = 'm',
    KEY_SECOND = 's',
    KEY_HUNDREDTH = 'hs';
  var keys = [KEY_HOUR, KEY_MINUTE, KEY_SECOND, KEY_HUNDREDTH];

  ////////////////////////////////////////////////////////////////
  // Commands
  ////////////////////////////////////////////////////////////////

  /**
   * Command to add a new point spec with x and y values.
   *
   * @inner
   * @class
   * @extends {module:bajaux/commands/Command}
   * @param {module:nmodule/bacnet/rc/fe/BacnetTimeEditor} ed
   */
  var AsteriskCommand = function AsteriskCommand(ed) {
    Command.call(this, {
      module: 'bacnet',
      lex: "BacnetEd.asteriskCommand",
      func: function func() {
        ed.setModified(true);
        return ed.doLoad(BacnetTime.DEFAULT);
      }
    });
  };
  AsteriskCommand.prototype = Object.create(Command.prototype);
  AsteriskCommand.prototype.constructor = AsteriskCommand;

  /**
   * Bajaux editor for bacnet:BacnetTime type
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   * @alias module:nmodule/bacnet/rc/fe/BacnetTimeEditor
   */
  var BacnetTimeEditor = function BacnetTimeEditor() {
    var that = this;
    CompositeEditor.apply(this, arguments);
    that.getCommandGroup().add(new AsteriskCommand(that));
  };
  BacnetTimeEditor.prototype = Object.create(CompositeEditor.prototype);
  BacnetTimeEditor.prototype.constructor = BacnetTimeEditor;

  /**
   * @overrides module:nmodule/webEditors/rc/fe/CompositeEditor
   * @returns {*}
   */
  BacnetTimeEditor.prototype.makeBuilder = function () {
    var that = this,
      builder = new CompositeBuilder();
    builder.getDomFor = function (i) {
      return $('.time-part-' + i, that.jq());
    };
    builder.getKeys = function () {
      return keys;
    };
    builder.getValueFor = function (key) {
      var bacnetTime = this.getDataSource();
      switch (key) {
        case KEY_HOUR:
          var h = bacnetTime.getHour();
          return h === -1 ? "**" : h;
        case KEY_MINUTE:
          var m = bacnetTime.getMinute();
          return m === -1 ? "**" : m;
        case KEY_SECOND:
          var s = bacnetTime.getSecond();
          return s === -1 ? "**" : s;
        case KEY_HUNDREDTH:
          var hs = bacnetTime.getHundredth();
          return hs === -1 ? "**" : hs;
      }
      return "**";
    };
    builder.getConfigFor = function () {
      return {
        value: baja.Integer.DEFAULT,
        properties: {
          uxFieldEditor: "webEditors:StringEditor"
        },
        formFactor: 'mini'
      };
    };
    return builder;
  };

  /**
   * Build the BacnetTime editor with fields to change hour, minute, second
   * and hundredth of a second.
   * @param {JQuery} dom the DOM element into which to load this widget
   */
  BacnetTimeEditor.prototype.doInitialize = function (dom) {
    var that = this;
    dom.html(templateEditor({
      labels: {
        h: KEY_HOUR,
        m: KEY_MINUTE,
        s: KEY_SECOND,
        hs: KEY_HUNDREDTH
      }
    }));
    return Promise.all([fe.buildFor({
      dom: $('.commands', that.jq()),
      type: CommandButtonGroup,
      value: this.getCommandGroup(),
      properties: {
        toolbar: true
      },
      formFactor: 'mini'
    }), CompositeEditor.prototype.doInitialize.apply(this, arguments)]).then(function () {
      that.jq().find("button").removeClass("ux-btn");
      that.jq().find("button").addClass("ux-btn-tb");
    });
  };

  /**
   * Reads the editor data into a BacnetTime object
   * @returns {Promise} promise to be resolved with the current value
   */
  BacnetTimeEditor.prototype.doRead = function () {
    return this.getBuilder().readAll().then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 4),
        hr = _ref2[0],
        min = _ref2[1],
        sec = _ref2[2],
        hth = _ref2[3];
      var hour = hr === "**" ? -1 : hr,
        minute = min === "**" ? -1 : min,
        second = sec === "**" ? -1 : sec,
        hundredth = hth === "**" ? -1 : hth;
      return BacnetTime.make(hour, minute, second, hundredth);
    });
  };
  /**
   * Destroy all child editors.
   *
   * @returns {Promise}
   */
  BacnetTimeEditor.prototype.doDestroy = function () {
    return this.getChildWidgets().destroyAll();
  };

  /**
   * Set all child editors readonly/writable.
   *
   * @param {Boolean} readonly
   * @returns {Promise}
   */
  BacnetTimeEditor.prototype.doReadonly = function (readonly) {
    return this.getChildWidgets().setAllReadonly(readonly);
  };

  /**
   * Set all child editors enabled/disabled.
   *
   * @param {Boolean} enabled
   * @returns {Promise}
   */
  BacnetTimeEditor.prototype.doEnabled = function (enabled) {
    return this.getChildWidgets().setAllEnabled(enabled);
  };

  ///////////////////Private functions///////////////////////////////
  /**
   * Get the editor corresponding to the time parts
   * @private
   * @returns {JQuery}
   */
  BacnetTimeEditor.prototype.$getEditorsElement = function () {
    return this.jq().find('.editors');
  };

  /**
   * @private
   * @returns {module:bajaux/commands/Command}
   */
  BacnetTimeEditor.prototype.$getAsteriskCommand = function () {
    return this.getCommandGroup().get(0);
  };
  return BacnetTimeEditor;
});
