function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/fe/BacnetTimeValueEditor
 */
define(['baja!', 'jquery', 'Promise', 'bajaux/events', 'bajaux/Widget', 'bajaux/mixin/batchSaveMixin', 'bajaux/mixin/subscriberMixIn', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'nmodule/webEditors/rc/fe/fe', 'nmodule/bacnet/rc/fe/BacnetAnyEditor', 'lex!bacnet', 'hbs!nmodule/bacnet/rc/fe/templates/BacnetTimeValueEditor'], function (baja, $, Promise, events, Widget, batchSaveMixin, subscriberMixIn, DepthSubscriber, BaseEditor, DisplayOnlyEditor, fe, BacnetAnyEditor, lexs, tmplEditor) {
  'use strict';

  var bacnetLex = lexs[0];
  var DESTROY_EVENT = events.DESTROY_EVENT,
    INITIALIZE_EVENT = events.INITIALIZE_EVENT,
    LOAD_EVENT = events.LOAD_EVENT,
    ENABLE_EVENT = events.ENABLE_EVENT,
    DISABLE_EVENT = events.DISABLE_EVENT,
    MODIFY_EVENT = events.MODIFY_EVENT,
    READONLY_EVENT = events.READONLY_EVENT,
    WRITABLE_EVENT = events.WRITABLE_EVENT;

  /**
   * Editor for handling `bacnet:BacnetTimeValue` values.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/bacnet/rc/fe/BacnetTimeValueEditor
   */
  var BacnetTimeValueEditor = function BacnetTimeValueEditor(params) {
    var that = this;
    BaseEditor.apply(that, arguments);
    if (that.getFormFactor() === Widget.formfactor.mini) {
      DisplayOnlyEditor.$mixin(that);
    } else {
      batchSaveMixin(that);
    }
    //subscribe BacnetTimeValue and BacnetAny slot
    that.$subscriber = new DepthSubscriber(2);
    subscriberMixIn(that);
  };
  BacnetTimeValueEditor.prototype = Object.create(BaseEditor.prototype);
  BacnetTimeValueEditor.prototype.constructor = BacnetTimeValueEditor;
  BacnetTimeValueEditor.prototype.valueToString = function (value) {
    var dispVal = "";
    if (baja.hasType(value, 'bacnet:BacnetTimeValue')) {
      dispVal = value.getDisplay();
      if (!dispVal) {
        dispVal = value.getTime().encodeToString() + ";" + value.getValue().toString();
      }
    }
    return dispVal;
  };

  /**
   *
   * @param {JQuery} dom
   */
  BacnetTimeValueEditor.prototype.doInitialize = function (dom) {
    var that = this;
    //Disable events from bubbling up
    dom.on([DESTROY_EVENT, INITIALIZE_EVENT, LOAD_EVENT, ENABLE_EVENT, DISABLE_EVENT, READONLY_EVENT, WRITABLE_EVENT].join(' '), '.editor', false);
    dom.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });
    dom.html(tmplEditor({
      labels: {
        time: bacnetLex.get("BacnetTV.editor.label.time"),
        value: bacnetLex.get("BacnetTV.editor.label.value")
      }
    }));
    return Promise.all([fe.buildFor({
      value: baja.$("bacnet:BacnetTime"),
      dom: $('.js-time', dom),
      formFactor: 'mini'
    }), fe.buildFor({
      value: baja.$('bacnet:BacnetAny'),
      type: BacnetAnyEditor,
      dom: $('.js-any', dom),
      formFactor: 'mini'
    })]);
  };

  /**
   * @param {baja.Complex} value the `bacnet:BacnetTimeValue` value to load
   */
  BacnetTimeValueEditor.prototype.doLoad = function (value) {
    var that = this;
    return Promise.all([that.$getTimeEditor().load(value.getTime()), that.$getValueEditor().load(value.getValue())]);
  };
  BacnetTimeValueEditor.prototype.doRead = function () {
    var that = this;
    return that.getChildEditors().readAll().then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        time = _ref2[0],
        value = _ref2[1];
      var btv = baja.$('bacnet:BacnetTimeValue');
      btv.setTime(time);
      btv.setValue(value);
      return btv;
    });
  };
  BacnetTimeValueEditor.prototype.doSave = function (readValue, params) {
    var batch = params && params.batch,
      progressCallback = params && params.progressCallback,
      value = this.value(),
      prom;
    prom = Promise.all([value.set({
      slot: 'time',
      value: readValue.get('time'),
      batch: batch
    }), this.$getValueEditor().save(params)]);
    if (progressCallback) {
      progressCallback(batchSaveMixin.COMMIT_READY);
    }
    return prom;
  };
  BacnetTimeValueEditor.prototype.$getTimeEditor = function () {
    return Widget["in"](this.jq().find('.js-time'));
  };
  BacnetTimeValueEditor.prototype.$getValueEditor = function () {
    return Widget["in"](this.jq().find('.js-any'));
  };

  /**
   * Set all child editors readonly/writable.
   *
   * @param {Boolean} readonly
   * @returns {Promise}
   */
  BacnetTimeValueEditor.prototype.doReadonly = function (readonly) {
    return this.getChildEditors().setAllReadonly(readonly);
  };

  /**
   * Set all child editors enabled/disabled.
   *
   * @param {Boolean} enabled
   * @returns {Promise}
   */
  BacnetTimeValueEditor.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };
  BacnetTimeValueEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };
  return BacnetTimeValueEditor;
});
