function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/wb/mgr/commands/ChangeIdCommand
 */
define(['baja!', 'lex!bacnet', 'Promise', 'underscore', 'dialogs', 'bajaux/commands/Command', 'nmodule/bacnet/rc/wb/mgr/model/columns/DeviceIdMgrColumn', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/mgr/BatchComponentEditor', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/webEditors/rc/wb/mgr/commands/MgrCommand', 'nmodule/webEditors/rc/wb/mgr/model/MgrModel', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/source/ArrayComponentSource', 'baja!bacnet:ChangeDeviceIdConfig'], function (baja, lexs, Promise, _, dialogs, Command, DeviceIdMgrColumn, feDialogs, BatchComponentEditor, mgrUtils, MgrCommand, MgrModel, NameMgrColumn, Column, ArrayComponentSource) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    bacnetLex = _lexs[0];
  var getMainTableSelectedSubjects = mgrUtils.getMainTableSelectedSubjects;
  var _MgrCommand$flags = MgrCommand.flags,
    ALL_BARS = _MgrCommand$flags.ALL_BARS,
    MAIN_CONTEXT_MENU = _MgrCommand$flags.MAIN_CONTEXT_MENU;

  ////////////////////////////////////////////////////////////////
  // ChangeIdBatchComponentEditor
  ////////////////////////////////////////////////////////////////

  /**
   * ChangeIdBatchComponentEditor is a customized version of the batch component editor
   * that will not commit the modified device ids back to the components in the model,
   * but will instead set them as properties on a configuration object that will be
   * passed as the parameter to a job.
   *
   * @private
   * @constructor
   */
  var ChangeIdBatchComponentEditor = function ChangeIdBatchComponentEditor() {
    BatchComponentEditor.apply(this, arguments);
  };
  ChangeIdBatchComponentEditor.prototype = Object.create(BatchComponentEditor.prototype);
  ChangeIdBatchComponentEditor.prototype.constructor = ChangeIdBatchComponentEditor;

  /**
   * Override of doInitialize() sets an extra CSS class, that allows us to configure
   * the UI slightly differently.
   *
   * @param {JQuery} dom
   * @returns {*}
   */
  ChangeIdBatchComponentEditor.prototype.doInitialize = function (dom) {
    dom.addClass('ChangeIdBatchComponentEditor');
    return BatchComponentEditor.prototype.doInitialize.apply(this, arguments);
  };

  /**
   * Overridden version of the doSave() function; we don't want the changed values
   * committed back to the source components, we want to obtain the values to set
   * as old/new properties on a configuration component.
   *
   * @returns {Promise}
   */
  ChangeIdBatchComponentEditor.prototype.doSave = function () {
    return Promise.resolve();
  };

  /**
   * @returns {Promise}
   */
  ChangeIdBatchComponentEditor.prototype.doDestroy = function () {
    var model = this.value();
    var rows = model.getRows();
    rows.map(function (row) {
      row.data('lastProposals', row.data('mgr:proposals') || {});
    });
    return BatchComponentEditor.prototype.doDestroy.apply(this, arguments);
  };

  /**
   * Create a manager model for showing in the component editor. This contains
   * columns for the device name and device id.
   *
   * @static
   * @param {Array.<baja.Component>} comps - the selected device components
   * @returns {module:nmodule/webEditors/rc/wb/mgr/model/MgrModel}
   */
  ChangeIdBatchComponentEditor.makeEditModel = function (comps) {
    var columns = [new NameMgrColumn({
      flags: Column.flags.READONLY | Column.flags.EDITABLE
    }), new DeviceIdMgrColumn('config/deviceObject/objectId', {
      displayName: bacnetLex.get('deviceManager.deviceId'),
      type: baja.lt('bacnet:BacnetDeviceObject'),
      flags: Column.flags.EDITABLE
    })];
    return new MgrModel({
      componentSource: new ArrayComponentSource(comps),
      columns: columns
    });
  };

  ////////////////////////////////////////////////////////////////
  // ChangeIdCommand
  ////////////////////////////////////////////////////////////////

  function appendValueString(str, currentId, newId) {
    if (str.length) {
      str = str + ';';
    }
    return str + currentId + '->' + newId;
  }

  /**
   * Called to save the proposed values from the ChangeIdBatchComponentEditor
   * on a new instance of a ChangeDeviceIdConfig component. This is the component
   * that will be submitted as the argument when creating the job to change the
   * ids.
   *
   * @returns {baja.Component} a ChangeDeviceIdConfig instance.
   */
  function createConfig(model) {
    var cfg = baja.$('bacnet:ChangeDeviceIdConfig'),
      devIdColumn = model.getColumn('objectId'),
      str = '';
    _.map(model.getRows(), function (row) {
      var lastProposals = row.data('lastProposals');
      row.deleteData('lastProposals');
      var currentId = devIdColumn.getValueFor(row),
        newId = lastProposals[devIdColumn.getName()] || currentId;
      str = appendValueString(str, currentId, newId);
      cfg.add({
        slot: 'currentId?',
        value: currentId,
        flags: baja.Flags.READONLY
      });
      cfg.add({
        slot: 'changeTo?',
        value: newId,
        flags: baja.Flags.READONLY
      });
    });
    cfg.setValue(str);
    return cfg;
  }

  /**
   * `Command` allowing the user to change the device id instance number
   * of one or more devices in the manager table.
   *
   * @class
   * @alias module:nmodule/bacnet/rc/wb/mgr/commands/ChangeIdCommand
   * @extends module:bajaux/commands/Command
   */
  var ChangeIdCommand = function ChangeIdCommand(mgr) {
    var that = this;
    Command.call(this, {
      displayName: bacnetLex.get('changeId.label'),
      description: bacnetLex.get('changeId.description'),
      icon: bacnetLex.get('changeId.icon'),
      enabled: false,
      flags: ALL_BARS | MAIN_CONTEXT_MENU,
      /**
       * For the devices currently selected in the main table, display a
       * batch component editor, with columns for the device name and device
       * id. The values from the id column are used to create slots on a
       * ChangeDeviceIdConfig instance.
       *
       * @alias module:nmodule/bacnet/rc/wb/mgr/commands/ChangeIdCommand#invoke
       * @returns {Promise}
       */
      func: function func() {
        var network = mgr.getNetwork();
        dialogs.showYesNo({
          title: bacnetLex.get('changeId.title'),
          text: bacnetLex.get('changeId.confirm'),
          yes: function yes() {
            var selection = getMainTableSelectedSubjects(mgr),
              model;
            if (selection.length && selection[0].getType().is('bacnet:BacnetDevice')) {
              model = ChangeIdBatchComponentEditor.makeEditModel(selection);
              mgr.getOrdBase().then(function (ordBase) {
                return feDialogs.showFor({
                  value: model,
                  properties: {
                    ordBase: ordBase
                  },
                  type: ChangeIdBatchComponentEditor
                });
              }).then(function (editModel) {
                if (editModel) {
                  var config = createConfig(editModel);
                  return network.submitDeviceManagerJob(config).then(function (ord) {
                    mgr.setJob(baja.Ord.make({
                      base: baja.Ord.make('station:'),
                      child: ord.relativizeToSession()
                    }));
                  });
                }
              })["catch"](baja.error);
            }
          }
        });
      }
    });
    mgr.on('jobcomplete', function (job) {
      if (job.getType().is('bacnet:ChangeDeviceIdJob')) {
        that.complete(job);
      }
    });
  };

  /**
   * Function to obtain the text to be displayed once the change id job has completed,
   * either some generic success text or a failure message based on a string obtained
   * from the job.
   *
   * @param {baja.Component} job - the ChangeDeviceIdJob created by invoking this command
   * @returns {String} the string to be displayed in the dialog.
   */
  function getCompletionMessage(job) {
    var cause;
    if (job.getJobState().getTag() === 'success') {
      return bacnetLex.get('changeId.success');
    } else {
      cause = job.get('failureCause') || '';
      return bacnetLex.get({
        key: 'changeId.fail',
        args: [cause]
      });
    }
  }
  ChangeIdCommand.prototype = Object.create(Command.prototype);
  ChangeIdCommand.prototype.constructor = ChangeIdCommand;

  /**
   * Function called when the submitted job completes. Will display a message to the
   * user, informing them of success or failure.
   *
   * @static
   * @param {baja.Component} job
   */
  ChangeIdCommand.prototype.complete = function (job) {
    dialogs.showOk({
      title: bacnetLex.get('changeId.title'),
      text: getCompletionMessage(job)
    });
  };
  return ChangeIdCommand;
});
