function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */
/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/history/rc/DeviceHistoriesUxView
 */
define(['baja!', 'baja!history:History', 'lex!history', 'log!nmodule.history.rc.DeviceHistoriesUxView', 'bajaux/mixin/subscriberMixIn', 'bajaux/spandrel', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/wb/mixin/ContextMenuSupport', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'nmodule/webEditors/rc/wb/table/model/columns/IconColumn', 'css!nmodule/history/rc/history'], function (baja, types, lexs, log, subscriberMixIn, spandrel, Promise, _, compUtils, ContextMenuSupport, Table, Column, TableModel, IconColumn) {
  'use strict';

  var NavNode = require('bajaScript/baja/nav/NavNode');
  var logSevere = log.severe.bind(log);
  var logFine = log.fine.bind(log);
  var _lexs = _slicedToArray(lexs, 1),
    historyLex = _lexs[0];
  var NAME_TEXT = historyLex.get('DeviceHistoriesUxView.columns.name');
  var DESCRIPTION_TEXT = historyLex.get('DeviceHistoriesUxView.columns.description');
  var HEADER_TEXT_KEY = 'deviceHistoriesView.title';
  var HISTORY_SHORTCUT_ICON = baja.Icon.make('module://icons/x16/historyShortcut.png');
  var FACETS_ENCODING = baja.Facets.make({
    includeDescription: true
  }).encodeToString();
  var HISTORY_SPACE_NAV_ORD = "local:|history:";
  var HISTORY_ALL_DEVICES_NAV_NAME = 'history:///';
  var HISTORY_ALL_DEVICES_FOLDER_NAV_ORD = 'local:|' + HISTORY_ALL_DEVICES_NAV_NAME;
  var NameColumn = /*#__PURE__*/function (_Column) {
    function NameColumn() {
      _classCallCheck(this, NameColumn);
      return _callSuper(this, NameColumn, arguments);
    }
    _inherits(NameColumn, _Column);
    return _createClass(NameColumn, [{
      key: "getValueFor",
      value: function getValueFor(row) {
        return row.getSubject().getNavDisplayName();
      }
    }]);
  }(Column);
  var DescriptionColumn = /*#__PURE__*/function (_Column2) {
    function DescriptionColumn() {
      _classCallCheck(this, DescriptionColumn);
      return _callSuper(this, DescriptionColumn, arguments);
    }
    _inherits(DescriptionColumn, _Column2);
    return _createClass(DescriptionColumn, [{
      key: "getValueFor",
      value: function getValueFor(row) {
        return row.getSubject().getNavDescription();
      }
    }]);
  }(Column);
  var nameColumn = new NameColumn('displayName', {
    displayName: NAME_TEXT
  });
  var descColumn = new DescriptionColumn('navDescription', {
    displayName: DESCRIPTION_TEXT
  });
  var iconColumn = new IconColumn('icon');
  iconColumn.getValueFor = function () {
    return HISTORY_SHORTCUT_ICON;
  };
  var columns = [iconColumn, nameColumn, descColumn];

  /**
   * Widget layout that is used by Spandrel.
   */
  function layoutWidget(value, state) {
    var deviceName = state.deviceName;
    var model = stateToTableModel(state);
    return [spandrel.jsx("div", null, spandrel.jsx("div", {
      "class": "-t-DeviceHistoriesUxView-header"
    }, historyLex.get(HEADER_TEXT_KEY, deviceName)), spandrel.jsx(DeviceHistoriesTable, {
      className: "ux-select-none",
      value: model,
      spandrelKey: "table"
    }))];
  }

  /**
   * @param {baja.Ord|String} ord
   * @returns {boolean}
   */
  function isHistorySpaceOrAllDevices(ord) {
    var ordString = ord.toString();
    return ordString === HISTORY_SPACE_NAV_ORD || ordString === HISTORY_ALL_DEVICES_FOLDER_NAV_ORD;
  }
  var DeviceHistoriesTable = /*#__PURE__*/function (_Table) {
    function DeviceHistoriesTable() {
      var _this;
      _classCallCheck(this, DeviceHistoriesTable);
      _this = _callSuper(this, DeviceHistoriesTable, arguments);
      ContextMenuSupport(_this);
      return _this;
    }
    _inherits(DeviceHistoriesTable, _Table);
    return _createClass(DeviceHistoriesTable, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        dom.on('dblclick', 'tr', function () {
          var rows = _this2.getSelectedRows();
          if (rows.length === 1) {
            var row = rows[0];
            row.getSubject().getNavOrd();
            window.niagara.env.hyperlink(row.getSubject().getNavOrd().relativizeToSession());
          }
        });
        return _superPropGet(DeviceHistoriesTable, "doInitialize", this, 3)(arguments);
      }
    }, {
      key: "getContextMenuSelector",
      value: function getContextMenuSelector() {
        return 'tr';
      }
    }]);
  }(Table);
  /**
   * @param {Object} state
   * @returns {module:nmodule/webEditors/rc/wb/table/model/TableModel}
   */
  function stateToTableModel(state) {
    var histories = state.histories;
    var rows = histories.map(function (history) {
      //TODO: NCCB-58470 sometimes we send the wrong navChildren for a missing historyDevice so this ensure
      //we only show valid entries
      if (history.ord.startsWith("local:|history:/")) {
        //support for context menu showing the proper nav context menu for each item
        return new NavNode(history);
      }
    });
    rows = _.compact(rows);
    return new TableModel({
      rows: rows,
      columns: columns
    });
  }
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-DeviceHistoriesUxView'
      }
    };
  };

  /***
   *
   * @class
   * @alias module:nmodule/bajaui/rc/fe/DeviceHistoriesUxView
   * @extends module:bajaux/spandrel/SpandrelWidget
   * @since Niagara 4.14
   */
  var DeviceHistoriesUxView = /*#__PURE__*/function (_spandrel) {
    function DeviceHistoriesUxView(params) {
      var _this3;
      _classCallCheck(this, DeviceHistoriesUxView);
      _this3 = _callSuper(this, DeviceHistoriesUxView, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      subscriberMixIn(_this3);
      return _this3;
    }
    _inherits(DeviceHistoriesUxView, _spandrel);
    return _createClass(DeviceHistoriesUxView, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this4 = this;
        /**
         * @param {baja.Ord} navOrd ORD nav event originated from (the parent)
         * @param {string} navName name of the child nav node affected by the event
         * @returns {Promise} to be resolved after redrawing the table
         */
        var onNavEvent = function onNavEvent(navOrd, navName) {
          if (isMyHistoryDevice(navOrd, navName)) {
            // note: returned promise is for testing. bajaScript event handlers do not handle promises
            return _this4.load(_this4.value())["catch"](logSevere);
          }
        };
        var isMyHistoryDevice = function isMyHistoryDevice(navOrd, name) {
          var deviceName = _this4.state().deviceName;
          var deviceOrdString = "history:/" + deviceName;
          var navDeviceOrd = "local:|" + deviceOrdString;
          return navOrd.toString() === navDeviceOrd ||
          // history in my device
          name === deviceName && isHistorySpaceOrAllDevices(navOrd); // my device itself
        };
        var added = this.$added = function (navOrd, navNode) {
          return onNavEvent(navOrd, navNode.getNavName());
        };
        var removed = this.$removed = function (navOrd, name) {
          return onNavEvent(navOrd, name);
        };
        var renamed = this.$renamed = function (navOrd, navNode) {
          return onNavEvent(navOrd, navNode.getNavName());
        };
        baja.nav.attach('added', added);
        baja.nav.attach('removed', removed);
        baja.nav.attach('renamed', renamed);
        return _superPropGet(DeviceHistoriesUxView, "doInitialize", this, 3)(arguments);
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/Table}
       */
    }, {
      key: "$getTable",
      value: function $getTable() {
        return this.queryWidget('**/table');
      }

      /**
       * @param {baja.Component} historyDeviceExt
       * @returns {object}
       */
    }, {
      key: "toState",
      value: function toState(historyDeviceExt) {
        var _this5 = this;
        var device = compUtils.closest(historyDeviceExt, 'driver:Device');
        var deviceName = device.getName();
        return this.$resolveHistoryDevice(deviceName).then(function (historyDevice) {
          if (!historyDevice) {
            //If there is no history for the device name,
            //BDeviceHistoriesView.java also supports checking for a string slot called historyDeviceName
            var historyDeviceName = historyDeviceExt.get('historyDeviceName');
            if (historyDeviceName && baja.hasType(historyDeviceName, 'baja:String')) {
              deviceName = historyDeviceName;
              return _this5.$resolveHistoryDevice(historyDeviceName);
            }
          }
          return historyDevice;
        }).then(function (historyDevice) {
          return historyDevice && historyDevice.getNavChildren(); //force the history device to get navEvents
        }).then(function () {
          var deviceOrdString = "history:/" + deviceName;
          //TODO: NCCB-58508 Bajascript should provide Nav Description for a certain portion of the NavTree
          return baja.rpc({
            typeSpec: "box:NavNodeSessionHandler",
            method: "getNavChildren",
            args: [deviceOrdString, FACETS_ENCODING]
          });
        }).then(function (results) {
          var histories = JSON.parse(results);
          return {
            histories: histories,
            deviceName: deviceName
          };
        })["catch"](function (error) {
          logFine("Cannot obtain nav children", error);
          return {
            histories: [],
            deviceName: deviceName
          };
        });
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$resolveHistorySpace",
      value: function $resolveHistorySpace() {
        return baja.Ord.make("history:").get().then(function (historySpace) {
          return historySpace.getNavChildren(); //force the history space to get navEvents on its children
        });
      }

      /**
       * @private
       * @param {String} name
       * @returns {Promise}
       */
    }, {
      key: "$resolveHistoryDevice",
      value: function $resolveHistoryDevice(name) {
        return this.$resolveHistorySpace().then(function (children) {
          var allDeviceHistoryFolder = children.find(function (node) {
            return node.getNavName() === HISTORY_ALL_DEVICES_NAV_NAME;
          });

          //if allDeviceHistoryFolder exists, make sure to call `getNavChildren()` so we can get the navEvents for it
          return allDeviceHistoryFolder && allDeviceHistoryFolder.getNavChildren() || children;
        }).then(function (children) {
          return children.find(function (node) {
            return node.getNavName() === name;
          });
        });
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        var added = this.$added;
        var removed = this.$removed;
        var renamed = this.$renamed;
        if (added) {
          baja.nav.detach('added', added);
          delete this.$added;
        }
        if (removed) {
          baja.nav.detach('removed', removed);
          delete this.$removed;
        }
        if (renamed) {
          baja.nav.detach('renamed', renamed);
          delete this.$renamed;
        }
        return _superPropGet(DeviceHistoriesUxView, "doDestroy", this, 3)(arguments);
      }
    }]);
  }(spandrel(layoutWidget, {
    strategy: 'niagara'
  }));
  return DeviceHistoriesUxView;
});
