function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/history/rc/baja/Capacity
 */
define(['baja!', 'lex!history'], function (baja, lexs) {
  'use strict';

  var objUtil = require('bajaScript/baja/obj/objUtil');
  var _lexs = _slicedToArray(lexs, 1),
    historyLex = _lexs[0];
  var Simple = baja.Simple;
  var cacheDecode = objUtil.cacheDecode,
    cacheEncode = objUtil.cacheEncode;
  var STR_REGEX = /(\d):(-?\d+)/;
  var RESTRICT_NONE = 0;
  var RESTRICT_RECORD_COUNT = 1;
  var RESTRICT_STORAGE_SIZE = 2;

  /**
   * BajaScript representation of a `history:Capacity`.
   *
   * @class
   * @extends baja.Simple
   * @alias module:nmodule/history/rc/baja/Capacity
   */
  var Capacity = function Capacity() {
    Simple.apply(this, arguments);
  };
  Capacity.prototype = Object.create(Simple.prototype);
  Capacity.prototype.constructor = Capacity;

  /**
   * Represent an unlimited Capacity.
   * @type {number}
   */
  Capacity.RESTRICT_NONE = RESTRICT_NONE;

  /**
   * Represent a Capacity restricted by number of records.
   * @type {number}
   */
  Capacity.RESTRICT_RECORD_COUNT = RESTRICT_RECORD_COUNT;

  /**
   * Represent a Capacity restricted by storage size.
   * @type {number}
   */
  Capacity.RESTRICT_STORAGE_SIZE = RESTRICT_STORAGE_SIZE;

  /**
   * Make a new `Capacity` instance.
   *
   * @param {Number} restrictBy number indicating the capacity type; use a
   * constant like `RESTRICT_NONE`
   * @param {Number} max max number of records (only used for
   * `RESTRICT_RECORD_COUNT`; otherwise unused)
   * @returns {module:nmodule/history/rc/baja/Capacity}
   */
  Capacity.make = function (restrictBy, max) {
    switch (restrictBy) {
      case RESTRICT_NONE:
      case RESTRICT_RECORD_COUNT:
      case RESTRICT_STORAGE_SIZE:
        var cap = new Capacity();
        cap.$restrictBy = restrictBy;
        cap.$max = max;
        return cap;
      default:
        throw new Error('unknown restrictBy: ' + restrictBy);
    }
  };

  /**
   * Make a new `Capacity` instance.
   * @see module:nmodule/history/rc/baja/Capacity.make
   */
  Capacity.prototype.make = function () {
    return Capacity.make.apply(Capacity, arguments);
  };
  Capacity.prototype.decodeFromString = cacheDecode(function (str) {
    var result = STR_REGEX.exec(str);
    if (!result) {
      throw new Error('invalid history:Capacity encoding: ' + str);
    }
    return Capacity.make(parseInt(result[1], 10), parseInt(result[2], 10));
  });
  Capacity.prototype.encodeToString = cacheEncode(function () {
    return this.$restrictBy + ':' + this.$max;
  });
  Capacity.prototype.toString = function () {
    switch (this.$restrictBy) {
      case RESTRICT_NONE:
        return historyLex.get('unlimited');
      case RESTRICT_RECORD_COUNT:
        return this.$max + ' ' + historyLex.get('records');
      case RESTRICT_STORAGE_SIZE:
        return Math.floor(this.$max / 1024) + ' KB';
      default:
        return this.encodeToString();
    }
  };

  /**
   * Get the max number of records denoted by this Capacity. Returns -1 for
   * unrestricted and throws for other capacity types.
   * @returns {Number}
   * @throws {Error} if this capacity cannot be described in terms of number
   * of records
   */
  Capacity.prototype.getMaxRecords = function () {
    switch (this.$restrictBy) {
      case RESTRICT_NONE:
        return -1;
      case RESTRICT_RECORD_COUNT:
        var max = this.$max;
        return max > baja.Integer.MAX_VALUE ? baja.Integer.MAX_VALUE.valueOf() : max;
      default:
        throw new Error('Capacity not restricted by record count.');
    }
  };

  /**
   * Return true if this capacity is measured in number of records.
   * @returns {boolean}
   */
  Capacity.prototype.isByRecordCount = function () {
    return this.$restrictBy === RESTRICT_RECORD_COUNT;
  };

  /**
   * Return true if this capacity is measured in storage size.
   * @returns {boolean}
   */
  Capacity.prototype.isByStorageSize = function () {
    return this.$restrictBy === RESTRICT_STORAGE_SIZE;
  };

  /**
   * Return true if this capacity is unrestricted.
   * @returns {boolean}
   */
  Capacity.prototype.isUnlimited = function () {
    return this.$restrictBy === RESTRICT_NONE;
  };
  Capacity.DEFAULT = Capacity.UNLIMITED = Capacity.make(RESTRICT_NONE, 0);
  baja.registerType('history:Capacity', function () {
    return Capacity;
  });
  return Capacity;
});
