function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/history/rc/command/ShowWarningCommand
 */
define(['baja!', 'lex!history', 'lex!', 'Promise', 'dialogs', 'bajaux/commands/Command'], function (baja, lexs, lexjs, Promise, dialogs, Command) {
  "use strict";

  var historyLex = lexs[0];

  /**
   * A ShowWarningCommand shows a dialog box with warnings in the form of unordered
   * list.
   *
   * @class
   * @alias module:nmodule/history/rc/command/ShowWarningCommand
   * @extends module:bajaux/commands/Command
   */
  var ShowWarningCommand = function ShowWarningCommand() {
    var that = this;
    that.$warningMap = {};
    Command.call(this, {
      module: 'history',
      lex: 'history.warning',
      enabled: false,
      func: function func() {
        return showWarnings(that.$warningMap);
      }
    });
  };
  ShowWarningCommand.prototype = Object.create(Command.prototype);
  ShowWarningCommand.prototype.constructor = ShowWarningCommand;

  /**
   * Resolve the warning lexicons and show them in a dialog box as an unordered
   * list
   * @param {Object} warningMap
   * @return {Promise.<string|undefined>}
   */
  function showWarnings(warningMap) {
    var numberOfWarnings = Object.keys(warningMap).length;
    if (warningMap && numberOfWarnings) {
      return resolveGetWarningDialogContent(warningMap).then(function (content) {
        return dialogs.showOk({
          title: historyLex.get("history.warning.title", numberOfWarnings),
          content: content
        });
      });
    }
    return Promise.resolve();
  }

  /**
   * The warning dialog box content is an unordered (bulleted) list.
   * Each list item represents a new warning. The warning can have a title and
   * a msg in the lexicon form along with title args and msg args respectively.
   * The msg after it is resolved is shown in preformatted text form.
   * If the lexicon keys are missing from the module.lexicon, the key itself will
   * be shown in the warning dialog box.
   * @inner
   * @param {Object} warningMap a key-value map of warning messages
   * @return {Promise.<string>} the content of the dialog box
   */
  function resolveGetWarningDialogContent(warningMap) {
    var content = "<ul>";
    return Promise.all(Object.keys(warningMap).map(function (key) {
      var module = warningMap[key].module;
      return Promise.all([resolveLexiconValue(module, [warningMap[key].title, warningMap[key].titleArgs]), resolveLexiconValue(module, [warningMap[key].msg, warningMap[key].msgArgs.join(warningMap[key].coaleseable)])]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
          title = _ref2[0],
          msg = _ref2[1];
        content += "<li>";
        content += (title || warningMap[key].title) + "<br/>";
        content += "<pre>" + (msg || warningMap[key].msg) + "</pre>";
        content += "</li>";
      });
    })).then(function () {
      content += "</ul>";
      return content;
    });
  }

  /**
   * resolves the given lexicon key from the given lexicon module
   * @inner
   * @param {String} lexModule the module to look for the lexicons
   * @param {object} lexiconKey the given lexicon key with args
   * @return {Promise.<String>|undefined} the resolved lexicon value
   */
  function resolveLexiconValue(lexModule, lexiconKey) {
    var key, args;
    if (Array.isArray(lexiconKey)) {
      key = lexiconKey[0];
      args = lexiconKey.slice(1);
    } else {
      key = lexiconKey;
    }
    if (lexModule && lexiconKey) {
      return lexjs.module(lexModule).then(function (lex) {
        return lex.getSafe({
          key: key,
          args: [args]
        });
      });
    }
  }

  /**
   * clear the warningMap and disable the command
   */
  ShowWarningCommand.prototype.resetWarnings = function () {
    this.setEnabled(false);
    this.$warningMap = {};
  };

  /**
   * Set the warning into the warningMap
   * if coaleseable delimiter is provided, group the warnings together based
   * on title & msg so as to show the msgArgs grouped together, delimited
   * by the coaleseable delimiter,
   * else, put the warning messages as individual notifications per msgArgs.
   * @param warning
   */
  ShowWarningCommand.prototype.setWarning = function (warning) {
    var that = this;
    if (warning && Object.keys(warning).length) {
      var module = warning.module,
        title = warning.title || "",
        titleArgs = warning.titleArgs || "",
        msg = warning.msg || "",
        msgArgs = warning.msgArgs || "",
        key;
      if (warning.coaleseable) {
        key = module + title + titleArgs + msg;
      } else {
        key = module + title + titleArgs + msg + msgArgs;
      }
      if (warning.coaleseable && that.$warningMap[key] && msgArgs) {
        that.$warningMap[key].msgArgs.push(msgArgs);
      } else {
        that.$warningMap[key] = {
          module: module,
          title: title,
          titleArgs: titleArgs,
          msg: msg,
          msgArgs: [msgArgs],
          coaleseable: warning.coaleseable
        };
      }
      that.setEnabled(true);
    } else {
      that.setEnabled(false);
    }
  };
  return ShowWarningCommand;
});
