function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/history/rc/fe/CollectionIntervalEditor
 */
define(['baja!', 'lex!history', 'bajaux/events', 'jquery', 'Promise', 'underscore', 'nmodule/history/rc/baja/CollectionInterval', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'css!nmodule/history/rc/history'], function (baja, lexs, events, $, Promise, _, CollectionInterval, fe, BaseEditor, OrderedMapEditor) {
  'use strict';

  var historyLex = lexs[0],
    DESTROY_EVENT = events.DESTROY_EVENT,
    DISABLE_EVENT = events.DISABLE_EVENT,
    ENABLE_EVENT = events.ENABLE_EVENT,
    INITIALIZE_EVENT = events.INITIALIZE_EVENT,
    LOAD_EVENT = events.LOAD_EVENT,
    MODIFY_EVENT = events.MODIFY_EVENT,
    READONLY_EVENT = events.READONLY_EVENT,
    WRITABLE_EVENT = events.WRITABLE_EVENT;
  var TYPES = function () {
    var map = new baja.OrderedMap();
    map.put(historyLex.get('regular'), false);
    map.put(historyLex.get('irregular'), true);
    return map;
  }();

  /**
   * Editor for working with `history:CollectionInterval` values.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/history/rc/fe/CollectionIntervalEditor
   */
  var CollectionIntervalEditor = function CollectionIntervalEditor(params) {
    BaseEditor.call(this, _.extend({
      formFactor: 'mini'
    }, params));
  };
  CollectionIntervalEditor.prototype = Object.create(BaseEditor.prototype);
  CollectionIntervalEditor.prototype.constructor = CollectionIntervalEditor;

  /**
   * Get the editor for the regular/irregular dropdown.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/OrderedMapEditor}
   */
  CollectionIntervalEditor.prototype.$getTypesEditor = function () {
    return this.jq().children('.intervalType').data('widget');
  };

  /**
   * Get the editor for the interval value.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/RelTimeEditor}
   */
  CollectionIntervalEditor.prototype.$getIntervalEditor = function () {
    return this.jq().children('.interval').data('widget');
  };

  /**
   * Called whenever the regular/irregular dropdown changes, hides the interval
   * editor when 'irregular' is selected.
   *
   * @private
   */
  CollectionIntervalEditor.prototype.$intervalTypeChanged = function () {
    var irregular = this.$getTypesEditor().getSelectedValue(),
      intervalEd = this.$getIntervalEditor();
    intervalEd.jq().css('display', irregular ? 'none' : '');
  };

  /**
   * Initialize editors for the regular/irregular selection and interval
   * RelTime.
   *
   * @param {jQuery} dom
   */
  CollectionIntervalEditor.prototype.doInitialize = function (dom) {
    var that = this;
    dom.on([DESTROY_EVENT, DISABLE_EVENT, ENABLE_EVENT, INITIALIZE_EVENT, LOAD_EVENT, READONLY_EVENT, WRITABLE_EVENT].join(' '), '.editor', false);
    dom.on(MODIFY_EVENT, '.intervalType', function () {
      that.$intervalTypeChanged();
      that.setModified(true);
      return false;
    });
    dom.on(MODIFY_EVENT, '.interval', function () {
      that.setModified(true);
      return false;
    });
    return Promise.all([fe.buildFor({
      dom: $('<div class="intervalType"/>').appendTo(dom),
      formFactor: 'mini',
      type: OrderedMapEditor,
      value: TYPES
    }), fe.buildFor({
      dom: $('<div class="interval"/>').appendTo(dom),
      formFactor: 'mini',
      value: baja.RelTime.DEFAULT
    })]);
  };

  /**
   * Set the regular/irregular and interval values.
   *
   * @param {module:nmodule/history/rc/baja/CollectionInterval} ci
   */
  CollectionIntervalEditor.prototype.doLoad = function (ci) {
    return Promise.all([this.$getTypesEditor().setSelectedValue(ci.isIrregular()), this.$getIntervalEditor().load(ci.getInterval())]);
  };

  /**
   * Resolve a new `history:CollectionInterval` with the regular/irregular
   * and interval values set.
   *
   * @returns {Promise}
   */
  CollectionIntervalEditor.prototype.doRead = function () {
    return this.getChildEditors().readAll().then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        irregular = _ref2[0],
        interval = _ref2[1];
      return irregular ? CollectionInterval.IRREGULAR : CollectionInterval.make(interval);
    });
  };

  /**
   * Destroy all child editors.
   *
   * @returns {Promise}
   */
  CollectionIntervalEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };

  /**
   * Set all child editors readonly/writable.
   *
   * @param {Boolean} readonly
   * @returns {Promise}
   */
  CollectionIntervalEditor.prototype.doReadonly = function (readonly) {
    return this.getChildEditors().setAllReadonly(readonly);
  };

  /**
   * Set all child editors enabled/disabled.
   *
   * @param {Boolean} enabled
   * @returns {Promise}
   */
  CollectionIntervalEditor.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };
  return CollectionIntervalEditor;
});
