function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Tony Richards
 */

/**
 * API Status: **Private**
 * @module nmodule/history/rc/fe/HistoryTableStateHandler
 */
define(['baja!', 'baja!bql:FilterSet,bql:DynamicTimeRange', 'Promise', 'underscore', 'nmodule/webEditors/rc/util/SyncedSessionStorage'], function (baja, types, Promise, _, SyncedSessionStorage) {
  'use strict';

  var CACHE_STORAGE_KEY = 'niagara.webhistorytable.cache';

  /**
   * History Table State Handler
   * 
   * Handles state for WebHistoryTable.  This allows WebHistoryTable to 
   * persist (to session storage) its state, so that when a user navigates
   * away from the history table for a given ord, and then navigates back
   * to that order later, its state is restored.
   * 
   * Specifically, the types of things that are stored and restored should be:
   * - filter
   * - sort
   * - page row count
   * - page number
   * 
   * Constructor not to be called directly. Call `.make()` instead.
   * 
   * @class
   * @alias module:nmodule/history/rc/fe/HistoryTableStateHandler
   */
  var HistoryTableStateHandler = function HistoryTableStateHandler() {};

  /**
   * Create a HistoryTableStateHandler
   * 
   * @param {Storage} [storage]
   * @returns {Promise<HistoryTableStateHandler>} resolves to a HistoryTableStateHandler
   */
  HistoryTableStateHandler.make = function (storage) {
    return Promise.resolve(storage || SyncedSessionStorage.getInstance()).then(function (storage) {
      var handler = new HistoryTableStateHandler();
      handler.$storage = storage;
      return handler;
    });
  };

  /**
   * Save the state for the specified WebHistoryTable
   * 
   * @param {module:nmodule/history/rc/fe/WebHistoryTable} historyTable 
   *  for which to save state
   */
  HistoryTableStateHandler.prototype.save = function (historyTable) {
    var state = {};
    var key = this.getKeyForSessionStorage();
    this.doSave(historyTable, state);

    // Get the current value for all history tables
    var allStates = JSON.parse(this.$storage.getItem(key) || '{}');

    // Update the value for the current ord
    allStates[historyTable.getOrdBody()] = state;

    // Save the value in session storage
    this.$storage.setItem(key, JSON.stringify(allStates));
  };

  /**
   * Restore the state from session storage for the specified ordBody
   * 
   * @param {String} ordBody
   * @returns {Promise.<Object>} restored state
   */
  HistoryTableStateHandler.prototype.restore = function (ordBody) {
    var key = this.getKeyForSessionStorage();
    var allStates = JSON.parse(this.$storage.getItem(key));
    if (allStates && allStates.hasOwnProperty(ordBody)) {
      var encoded = allStates[ordBody];
      return this.doDecode(encoded);
    } else {
      return Promise.resolve({});
    }
  };

  /**
   * Get the key for the session storage
   * 
   * @returns {String}
   */
  HistoryTableStateHandler.prototype.getKeyForSessionStorage = function () {
    return baja.getUserName() + '.' + CACHE_STORAGE_KEY;
  };

  /**
   * Apply the state to the WebHistoryTable
   * 
   * Typically the API user should call `HistoryTableStateHandler#save` instead
   * of calling `doSave`.
   * 
   * @param {module:nmodule/history/rc/fe/WebHistoryTable} historyTable 
   *  for which to save state
   * @param {Object} state to be populated with the WebHistoryTable state, 
   * in a JSON serializable form (baja components have been bson encoded).
   */
  HistoryTableStateHandler.prototype.doSave = function (historyTable, state) {
    state.currentPage = historyTable.getCurrentPage();
    var filterSet = historyTable.getFilterSet();
    if (filterSet) {
      state.filterSet = baja.bson.encodeValue(historyTable.getFilterSet());
    }
    state.rowsPerPage = historyTable.getRowsPerPage();
    state.timeRange = baja.bson.encodeValue(historyTable.getTimeRange());
    state.delta = historyTable.getDelta();
    state.live = historyTable.getLive();
    var tableModel = historyTable.$getTable().getModel(),
      sortColumn = tableModel && tableModel.$getSortColumn();
    if (sortColumn) {
      state.sortColumn = sortColumn;
      state.sortDirection = tableModel.$getSortDirection(sortColumn);
    }
  };

  /**
   * Decode the state
   * 
   * Typically the API user should call `HistoryTableStateHandler#restore` instead
   * of calling `doDecode`.
   * 
   * @returns {Promise.<Object>} decoded state
   */
  HistoryTableStateHandler.prototype.doDecode = function (state) {
    return Promise.all([state.filterSet && baja.bson.decodeAsync(state.filterSet), baja.bson.decodeAsync(state.timeRange)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        filterSet = _ref2[0],
        timeRange = _ref2[1];
      var decodedState = _.pick(state, 'currentPage', 'rowsPerPage', 'delta', 'live', 'sortColumn', 'sortDirection');
      if (filterSet) {
        decodedState.filterSet = filterSet;
      }
      decodedState.timeRange = timeRange;
      return decodedState;
    });
  };
  return HistoryTableStateHandler;
});
