/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @module baja/boxcs/AddRelationKnobOp
 * @private
 */
define(["bajaScript/bson", "bajaScript/baja/boxcs/SyncOp"], function (baja, SyncOp) {
  "use strict";

  var subclass = baja.subclass,
    callSuper = baja.callSuper,
    bsonDecodeRelationKnob = baja.bson.decodeRelationKnob;

  /**
   * @class Add Relation Knob SyncOp
   *
   * @name AddRelationKnobOp
   * @extends SyncOp
   * @inner
   * @private
   */
  function AddRelationKnobOp() {
    callSuper(AddRelationKnobOp, this, arguments);
    throw new Error("Unsupported");
  }
  subclass(AddRelationKnobOp, SyncOp);
  AddRelationKnobOp.id = "m";

  /**
   * Decode and commit the SyncOp.
   *
   * @name AddRelationKnobOp.decodeAndCommit
   * @function
   * @private
   *
   * @param comp the Component the knob will be added too.
   * @param sp the syncOp data structure to be decoded.
   */
  AddRelationKnobOp.decodeAndCommit = function (comp, sp) {
    return comp && comp.$fw("installRelationKnob", bsonDecodeRelationKnob(sp.nrk), {
      commit: true,
      serverDecode: true
    });
  };
  return AddRelationKnobOp;
});
