/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @module baja/boxcs/LoadOp
 * @private
 */
define(["bajaScript/bson", "bajaScript/baja/boxcs/SyncOp", "bajaScript/baja/boxcs/syncUtil"], function (baja, SyncOp, syncUtil) {
  "use strict";

  var subclass = baja.subclass,
    callSuper = baja.callSuper;
  var syncComp = syncUtil.syncComp;
  var serverDecodeContext = baja.$serverDecodeContext;

  /**
   * @class Load a Component's Slots SyncOp.
   *
   * @name LoadOp
   * @extends SyncOp
   * @inner
   * @private
   */
  function LoadOp() {
    callSuper(LoadOp, this, arguments);
  }
  subclass(LoadOp, SyncOp);
  LoadOp.id = "l";

  /**
   * Decode and commit the SyncOp. This contains a BSON encoding of a real component from the
   * station, so that its current slot values can be applied to the proxy component that lives in
   * the browser. This typically happens because of a `loadSlots` network call.
   *
   * @name LoadOp.decodeAndCommit
   * @function
   * @private
   *
   * @param {baja.Component} comp the Component to be loaded.
   * @param {object} sp the syncOp data structure to be decoded.
   */
  LoadOp.decodeAndCommit = function (comp, sp) {
    if (comp !== null) {
      return baja.bson.decodeAsync(sp.b, serverDecodeContext).then(function (compFromStation) {
        return syncComp(compFromStation, comp);
      });
    }
  };
  return LoadOp;
});
