/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @module baja/boxcs/ReorderOp
 * @private
 */
define(["bajaScript/sys", "bajaScript/baja/boxcs/SyncOp"], function (baja, SyncOp) {
  "use strict";

  var subclass = baja.subclass,
    callSuper = baja.callSuper;

  /**
   * @class Reorder a Component's dynamic Slots SyncOp.
   *
   * @name ReorderOp
   * @extends SyncOp
   * @inner
   * @private
   *
   * @param comp the Component the reorder is happening on.
   * @param {Array} dynamicProperties a String array of dynamic Property names that specifies the new order.
   */
  function ReorderOp(comp, dynamicProperties) {
    callSuper(ReorderOp, this, arguments);

    // Encode argument to a data structure
    var a = {
      nm: this.getId(),
      h: comp.getHandle(),
      o: dynamicProperties.join(";")
    };
    this.$arg = a;
  }
  subclass(ReorderOp, SyncOp);
  ReorderOp.id = "o";

  /**
   * Decode and commit the SyncOp.
   *
   * @name ReorderOp.decodeAndCommit
   * @function
   * @private
   *
   * @param comp the Component the reorder will happen upon.
   * @param sp the syncOp data structure to be decoded.
   */
  ReorderOp.decodeAndCommit = function (comp, sp) {
    if (comp !== null) {
      var order = sp.o;
      comp.reorder({
        "dynamicProperties": order.split(";"),
        "cx": {
          commit: true,
          serverDecode: true
        }
      });
    }
  };
  return ReorderOp;
});
