/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @module baja/boxcs/SetFlagsOp
 * @private
 */
define(["bajaScript/sys", "bajaScript/baja/comp/Flags", "bajaScript/baja/boxcs/SyncOp"], function (baja, Flags, SyncOp) {
  "use strict";

  var subclass = baja.subclass,
    callSuper = baja.callSuper;

  /**
   * @class Set Slot Flags SyncOp.
   *
   * @name SetFlagsOp
   * @extends SyncOp
   * @inner
   * @private
   *
   * @param comp the Component for the slot the flags are being set upon.
   * @param {baja.Slot} slot the target slot for the flags change.
   * @param {Number} flags the new Slot flags.
   */
  function SetFlagsOp(comp, slot, flags) {
    callSuper(SetFlagsOp, this, arguments);

    // Encode argument to a data structure
    var a = {
      nm: this.getId(),
      h: comp.getHandle(),
      n: slot.getName(),
      f: Flags.encodeToString(flags)
    };
    this.$arg = a;
  }
  subclass(SetFlagsOp, SyncOp);
  SetFlagsOp.id = "f";

  /**
   * Decode and commit the SyncOp.
   *
   * @private
   *
   * @param comp the Component the set flags op will happen upon.
   * @param sp the syncOp data structure to be decoded.
   */
  SetFlagsOp.decodeAndCommit = function (comp, sp) {
    if (comp !== null) {
      var name = sp.n,
        flags = Flags.decodeFromString(sp.f),
        displayName = sp.dn,
        display = sp.d;
      comp.setFlags({
        "slot": name,
        "flags": flags,
        "cx": {
          commit: true,
          displayName: displayName,
          display: display,
          serverDecode: true
        }
      });
    }
  };
  return SetFlagsOp;
});
