/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * Defines {@link baja.Action}.
 * @module baja/comp/Action
 */
define(["bajaScript/sys", "bajaScript/baja/comp/Slot"], function (baja, Slot) {
  "use strict";

  var subclass = baja.subclass,
    callSuper = baja.callSuper;

  /**
   * Action Slot.
   * 
   * `Action` is a `Slot` that defines a behavior which can
   * be invoked on a `Component`.
   * 
   * A new object should never be directly created with this Constructor. All 
   * `Slot`s are created internally by BajaScript.
   *
   * @class
   * @alias baja.Action
   * @extends baja.Slot
   */
  var Action = function Action(slotName, displayName) {
    callSuper(Action, this, [slotName, displayName]);
  };
  subclass(Action, Slot);

  /**
   * Is the Slot an Action?
   *
   * @returns {Boolean}
   */
  Action.prototype.isAction = function () {
    return true;
  };
  return Action;
});
