/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * Defines `TopicProperty` (not exposed on `baja` namespace).
 * @module baja/comp/TopicProperty
 */
define(["bajaScript/sys", "bajaScript/baja/comp/Struct"], function (baja, Struct) {
  "use strict";

  var subclass = baja.subclass,
    callSuper = baja.callSuper;

  /**
   * Represents a `baja:Topic` in BajaScript.
   * 
   * Please note: this represents the `Property`'s value and not the `Property`
   * itself.
   *
   * @class
   * @alias module:baja/comp/TopicProperty
   * @extends baja.Struct
   * @private
   */
  var TopicProperty = function TopicProperty() {
    callSuper(TopicProperty, this, arguments);
    this.$eventType = null;
  };
  subclass(TopicProperty, Struct);

  /**
   * Return the Topic's event Type.
   *
   * @returns {Type} event Type (or null if the Topic has no event Type).
   */
  TopicProperty.prototype.getEventType = function () {
    return this.$eventType;
  };

  /**
   * Called when the Topic Property is fired.
   * 
   * @private
   *
   * @param {baja.Component} target the Component target the Topic is being fired upon.
   * @param {baja.Value} event the event for the Topic.
   * @param {Object} cx the Context for the Topic being fired (could be null).
   */
  TopicProperty.prototype.fire = function (target, event, cx) {};
  return TopicProperty;
});
