function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * Defines {@link baja.CategoryMask}.
 * @private
 * @module baja/obj/CategoryMask
 */
define(['bajaScript/baja/obj/Simple'], function (Simple) {
  'use strict';

  /**
   * @class
   * @alias module:baja/obj/CategoryMask
   * @private
   * @extends baja.Simple
   * @since Niagara 4.14
   */
  var CategoryMask = /*#__PURE__*/function (_Simple) {
    /**
     * @param {string} hex the hex encoding for this mask
     */
    function CategoryMask(hex) {
      var _this;
      _classCallCheck(this, CategoryMask);
      _this = _callSuper(this, CategoryMask);
      validateHex(hex);
      _this.$hex = hex;
      return _this;
    }

    /**
     * @param {number} categoryIndex
     * @returns {boolean} true if the bit for that category index is set
     */
    _inherits(CategoryMask, _Simple);
    return _createClass(CategoryMask, [{
      key: "get",
      value: function get(categoryIndex) {
        var hex = this.$hex;
        if (hex === '*') {
          return true;
        }
        var bitIndex = categoryIndex - 1; // category 1 lives in bit 0
        var bitInChar = bitIndex % 4; // each char holds 4 bits
        var charIndex = Math.floor(bitIndex / 4);
        var hexChar = hex[hex.length - 1 - charIndex];
        return !!(parseInt(hexChar, 16) & 1 << bitInChar);
      }

      /**
       * @returns {number} the number of categories represented by this mask
       */
    }, {
      key: "size",
      value: function size() {
        var hex = this.$hex;
        var largestChar = parseInt(hex[0], 16);
        if (!largestChar) {
          return 0;
        }
        var rest = (hex.length - 1) * 4;
        if (largestChar & 8) {
          return 4 + rest;
        }
        if (largestChar & 4) {
          return 3 + rest;
        }
        if (largestChar & 2) {
          return 2 + rest;
        }
        return 1 + rest;
      }

      /**
       * @returns {boolean} true if this is the null/default instance
       */
    }, {
      key: "isNull",
      value: function isNull() {
        return this === CategoryMask.DEFAULT;
      }

      /**
       * @param {string|number[]} hex the hex string, or an array of category indices (1-indexed)
       * @returns {module:baja/obj/CategoryMask}
       */
    }, {
      key: "make",
      value:
      /**
       * @param {string|number[]} hex the hex string, or an array of category indices (1-indexed)
       * @returns {module:baja/obj/CategoryMask}
       */
      function make(hex) {
        return CategoryMask.make(hex);
      }

      /**
       * @param {string} str
       * @returns {module:baja/obj/CategoryMask}
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(str) {
        return this.make(str);
      }

      /**
       * @returns {string}
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        return this.$hex;
      }
    }], [{
      key: "make",
      value: function make(hex) {
        if (Array.isArray(hex)) {
          var bytes = [];
          hex.forEach(function (categoryIndex) {
            categoryIndex--; // 1-based to 0-based
            var byteIndex = Math.floor(categoryIndex / 4);
            bytes[byteIndex] = (bytes[byteIndex] || 0) | 1 << categoryIndex % 4;
          });
          for (var i = 0, len = bytes.length; i < len; ++i) {
            bytes[i] = bytes[i] || 0;
          }
          var hexString = bytes.reverse().map(function (b) {
            return b.toString(16);
          }).join('');
          return CategoryMask.make(hexString);
        }
        return hex ? new CategoryMask(hex) : CategoryMask.DEFAULT;
      }
    }]);
  }(Simple);
  CategoryMask.DEFAULT = new CategoryMask('');

  /** @param {string} hex */
  function validateHex(hex) {
    if (hex === '*') {
      return;
    }
    if (hex[0] === '0') {
      throw new Error('No leading zero allowed');
    }
    for (var i = 0, len = hex.length; i < len; ++i) {
      var _char = hex[i];
      if (!_char.match(/[0-9a-f]/)) {
        throw new Error('Invalid char ' + _char);
      }
    }
  }
  return CategoryMask;
});
