function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * Defines {@link baja.OrdToCategoryMap}.
 * @private
 * @module baja/obj/OrdToCategoryMap
 */
define(['bajaScript/baja/obj/CategoryMask', 'bajaScript/baja/ord/Ord', 'bajaScript/baja/obj/Simple'], function (CategoryMask, Ord, Simple) {
  'use strict';

  /**
   * @class
   * @alias module:baja/obj/OrdToCategoryMap
   * @private
   * @extends baja.Simple
   * @since Niagara 4.14
   */
  var OrdToCategoryMap = /*#__PURE__*/function (_Simple) {
    /**
     * @param {Array.<object>} pairs ord/mask pairs
     */
    function OrdToCategoryMap(pairs) {
      var _this;
      _classCallCheck(this, OrdToCategoryMap);
      _this = _callSuper(this, OrdToCategoryMap);
      _this.$pairs = pairs;
      return _this;
    }

    /**
     * @param {number} i
     * @returns {baja.Ord|undefined} the ord at this index or undefined if not present
     */
    _inherits(OrdToCategoryMap, _Simple);
    return _createClass(OrdToCategoryMap, [{
      key: "getOrd",
      value: function getOrd(i) {
        var pair = this.$pairs[i];
        return pair && pair.ord;
      }

      /**
       * @param {number|baja.Ord} i numeric index, or an ORD to check
       * @returns {module:baja/obj/CategoryMask|undefined} the category mask matching this index or ORD,
       * or undefined if not present
       */
    }, {
      key: "getCategoryMask",
      value: function getCategoryMask(i) {
        var pairs = this.$pairs;
        var pair;
        if (typeof i === 'number') {
          pair = pairs[i];
        } else {
          // In NCCB-63126, we re-allowed some "station:" based ORDs to be case-sensitive (which
          // had been made lowercase since NCCB-56823). In order to be backwards compatible, we'll also
          // check for a lowercase match and use the lowercase match only if an exact match
          // isn't found first
          var ordStr = String(i.relativizeToSession());
          pair = pairs.find(function (_ref) {
            var $str = _ref.$str;
            return $str === ordStr;
          });
          if (!pair) {
            var lowerCaseOrdStr = ordStr.toLowerCase();
            pair = pairs.find(function (_ref2) {
              var $str = _ref2.$str;
              return $str === lowerCaseOrdStr;
            });
          }
        }
        return pair && pair.mask;
      }

      /**
       * @returns {number} the number of pairs in this map
       */
    }, {
      key: "size",
      value: function size() {
        return this.$pairs.length;
      }

      /**
       * @returns {Array.<object>} returns ord/mask pairs
       */
    }, {
      key: "pairs",
      value: function pairs() {
        return this.$pairs.slice();
      }

      /**
       * @param {object} params
       * @param {Array.<baja.Ord>} params.ords
       * @param {Array.<module:baja/obj/CategoryMask>} params.masks
       * @returns {module:baja/obj/OrdToCategoryMap}
       */
    }, {
      key: "make",
      value: function make(_ref3) {
        var ords = _ref3.ords,
          masks = _ref3.masks;
        if (ords.length !== masks.length) {
          throw new Error('ords.length != masks.length');
        }
        if (!ords.length) {
          return OrdToCategoryMap.DEFAULT;
        }
        var pairs = ords.map(function (ord, i) {
          return makePair(ord, masks[i]);
        });
        pairs.sort(function (p1, p2) {
          return p2.ord.toString().length - p1.ord.toString().length;
        });
        return new OrdToCategoryMap(pairs);
      }

      /**
       * @returns {string}
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        return this.$pairs.map(function (_ref4) {
          var ord = _ref4.ord,
            mask = _ref4.mask;
          return "".concat(ord, "=").concat(mask);
        }).join('\n');
      }

      /**
       * @param {string} str
       * @returns {module:baja/obj/OrdToCategoryMap}
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(str) {
        if (!str) {
          return OrdToCategoryMap.DEFAULT;
        }
        var pairs = str.split('\n').map(function (line) {
          var _exec = /^([^=]+)=(.*)$/.exec(line),
            _exec2 = _slicedToArray(_exec, 3),
            ord = _exec2[1],
            mask = _exec2[2];
          return makePair(ord, CategoryMask.make(mask));
        });
        return new OrdToCategoryMap(pairs);
      }
    }]);
  }(Simple);
  OrdToCategoryMap.DEFAULT = new OrdToCategoryMap([]);
  function makePair(ord, mask) {
    var ordStr = String(ord);
    // NCCB-63126: ORDs that start with "station:" (e.g. virtuals) are case-sensitive, while others
    // are not (use lowercase form)
    return {
      ord: Ord.make(ord),
      mask: mask,
      $str: ordStr.startsWith('station:|') ? ordStr : ordStr.toLowerCase()
    };
  }
  return OrdToCategoryMap;
});
