/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * Defines {@link baja.ViewScheme}.
 * @module baja/ord/ViewScheme
 */
define(["bajaScript/sys", "bajaScript/baja/ord/OrdScheme"], function (baja, OrdScheme) {
  "use strict";

  var subclass = baja.subclass,
    callSuper = baja.callSuper;

  /**
   * View ORD Scheme.
   * 
   * This scheme is used to process View query related information.
   *
   * @class
   * @alias baja.ViewScheme
   * @extends baja.OrdScheme
   * @private
   */
  var ViewScheme = function ViewScheme() {
    callSuper(ViewScheme, this, arguments);
  };
  subclass(ViewScheme, OrdScheme);

  /**
   * Default View Scheme instance.
   * @private
   * @type {baja.ViewScheme}
   */
  ViewScheme.DEFAULT = new ViewScheme();

  /**
   * Called when an ORD is resolved.
   *
   * @private
   *
   * @see baja.OrdScheme#resolve
   *
   * @param {module:baja/ord/OrdTarget} target  the current ORD Target.
   * @param {baja.OrdQuery} query  the ORD Query used in resolving the ORD.
   * @param {module:baja/ord/OrdQueryListCursor} cursor  the ORD Query List 
   * cursor used for helping to 
   * asynchronously resolve the ORD.
   * @param {Object} options  options used for resolving an ORD.
   */
  ViewScheme.prototype.resolve = function (target, query, cursor, options) {
    // Note down the view query information onto the ORD target so it can be accessed
    target.view = {
      id: query.getViewId(),
      params: query.getParameters()
    };
    cursor.resolveNext(target, options);
  };

  /**
   * Return an ORD Query for the scheme.
   *
   * @returns {baja.ViewQuery}
   */
  ViewScheme.prototype.parse = function (schemeName, body) {
    return new baja.ViewQuery(body);
  };
  return ViewScheme;
});
