/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @module comp
 * @private
 */
define(["bajaScript/nav", "bajaScript/baja/comp/Action", "bajaScript/baja/comp/ActionProperty", "bajaScript/baja/comp/Complex", "bajaScript/baja/comp/Component", "bajaScript/baja/comp/ComponentSpace", "bajaScript/baja/comp/ControlPoint", "bajaScript/baja/comp/Flags", "bajaScript/baja/comp/Host", "bajaScript/baja/comp/LinkCheck", "bajaScript/baja/comp/LocalHost", "bajaScript/baja/comp/Property", "bajaScript/baja/comp/Slot", "bajaScript/baja/comp/Struct", "bajaScript/baja/comp/Subscriber", "bajaScript/baja/comp/Topic", "bajaScript/baja/comp/TopicProperty"], function defineComp(baja, Action, ActionProperty, Complex, Component, ComponentSpace, ControlPoint, Flags, Host, LinkCheck, LocalHost, Property, Slot, Struct, Subscriber, Topic, TopicProperty) {
  "use strict";

  var registerType = baja.registerType;
  function registerAll(obj) {
    baja.iterate(obj, function (ctor, typeSpec) {
      registerType(typeSpec, function () {
        return ctor;
      });
    });
  }
  registerAll({
    "baja:Action": baja.ActionProperty = ActionProperty,
    "baja:Complex": baja.Complex = Complex,
    "baja:Component": baja.Component = Component,
    "baja:ComponentSpace": baja.ComponentSpace = ComponentSpace,
    "baja:Host": baja.Host = Host,
    "baja:LocalHost": baja.LocalHost = LocalHost,
    "baja:Struct": baja.Struct = Struct,
    "baja:Topic": /* not in baja */TopicProperty,
    "control:ControlPoint": /* not in baja */ControlPoint
  });
  baja.Action = Action;
  baja.Flags = Flags;
  baja.LinkCheck = LinkCheck;
  baja.Property = Property;
  baja.Slot = Slot;
  baja.Subscriber = Subscriber;
  baja.Topic = Topic;
  //TODO: baja.ActionProperty, but not baja.TopicProperty?

  return baja;
});
