/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module baja/env/mux/BoxFrameCoalescer
 */
define(['bajaScript/comm', 'bajaScript/env/mux/BoxMessageRelay', 'bajaScript/env/mux/muxUtils', 'bajaPromises'], function (baja, BoxMessageRelay, muxUtils, bajaPromises) {
  'use strict';

  /**
   * This class handles the mux/demux of outgoing BoxFrames and their incoming
   * responses.
   *
   * @class
   * @alias module:baja/env/mux/BoxFrameCoalescer
   * @param {baja/env/mux/muxUtils~MuxSettings} params
   */
  var BoxFrameCoalescer = function BoxFrameCoalescer(params) {
    var onIncomingFrame = params.onIncomingFrame;
    this.$messageRelay = new BoxMessageRelay(params);
    this.$onIncomingFrame = onIncomingFrame;
  };

  /**
   * Pulls the BOX messages out of the BOX frame and sends them on to BoxMessageRelay, who will
   * handle the work of sending the individual messages up to the station.
   *
   * @param {module:baja/env/Connection~FrameData} frameData an outgoing
   * BoxFrame
   */
  BoxFrameCoalescer.prototype.sendFrameData = function (frameData) {
    var _this = this;
    // buffer it in mux
    // sock it away by envelope id/frame number
    var frameBody = frameData.frame.$body;
    var p = frameBody.p,
      n = frameBody.n;
    return bajaPromises.all(frameBody.m.map(function (m) {
      return _this.$messageRelay.sendMessage(m);
    })).then(function (responses) {
      _this.$onIncomingFrame({
        p: p,
        n: n,
        m: responses
      });
    });
  };
  return BoxFrameCoalescer;
});
