/* global console */
/**
 * @private
 * @module nmodule/micros/rc/DatabaseSyncCommand
 */
define(['baja!', 'nmodule/micros/rc/MicrosUtils', 'nmodule/webEditors/rc/fe/feDialogs', 'bajaux/commands/Command', 'dialogs', 'Promise', 'underscore'], function (baja, MicrosUtils, feDialogs, Command, dialogs, Promise, _) {
  'use strict';

  var DB_SYNC_LABEL = 'pmc.DbSyncCmd.label',
    DB_SYNC_ARE_YOU_SURE = 'pmc.dbSync.areYouSure',
    NO_NETWORK = 'pmc.noNetwork',
    JOB_WAS_CANCELED = 'ds.job.cancelled',
    DB_SYNC_ABANDONED = 'pmc.DbSyncCmd.abandoned',
    //DB_SYNC_CMD_ERROR = 'pmc.DbSyncCmd.error',
    DB_SYNC_ORD_UNCHANGED = 'pmc.DbSyncCmd.ord.unchanged';
  var DatabaseSyncCommand = function DatabaseSyncCommand(manager) {
    var that = this;
    Command.call(that, {
      module: 'micros',
      lex: 'pmc.DbSyncCmd',
      // should mean that pmc.DbSyncCmd.icon gets used as the icon, and
      // pmc.DbSyncCmd.label is used as the button label. So ...
      displayName: MicrosUtils.microsLex(DB_SYNC_LABEL),
      enabled: true,
      func: function func() {
        // expecting manager to be MicrosPointManager
        var network = manager.getNetwork();
        if (!network) {
          console.error('DatabaseSyncCommand: ' + MicrosUtils.microsLex(NO_NETWORK));
          return dialogs.showOk(MicrosUtils.microsLex(NO_NETWORK)).ok(function () {
            return true;
          });
        }
        var sub = new baja.Subscriber();

        // subscribe to the Micros Network to listen for the DatabaseSyncJobOrd property changing
        return baja.Ord.make(network.getNavOrd()).get({
          subscriber: sub
        }).then(function () {
          var previousJobOrd = network.getDatabaseSyncJobOrd();
          sub.attach('changed', function (prop) {
            if (prop.getName() === 'databaseSyncJobOrd') {
              if (previousJobOrd === prop.$getValue()) {
                console.error(MicrosUtils.microsLex(DB_SYNC_ORD_UNCHANGED, '', [prop.$getValue()]));
                //console.error('DatabaseSyncCommand, DatabaseSyncJobOrd hasn\'t changed : ' + prop.$getValue());
                return;
              }

              //now subscribe to the job...
              baja.Ord.make({
                base: network.getNavOrd(),
                child: prop.$getValue()
              }).get({
                subscriber: sub
              })
              //              .then(function (job) {
              //                console.log('DatabaseSyncCommand, now subscribed to the job: ' + job);
              //              })
              ;
            } else if (prop.getName() === 'jobState') {
              var jobFinished,
                state = prop.$getValue(); // expecting a JobState Enum

              if (state === MicrosUtils.JobState.FAILED || state === MicrosUtils.JobState.SUCCESS) {
                jobFinished = true;
                //invoke the SyncSummaryCommand when the job has finished
                manager.$getSyncSummaryCommand().invoke();
              } else if (state === MicrosUtils.JobState.CANCELED) {
                jobFinished = true;
                dialogs.showOk(MicrosUtils.microsLex(JOB_WAS_CANCELED)).ok(function () {
                  return true;
                });
              }
              if (jobFinished) {
                // Unsubscribe the Component so we're no longer listening to live events.
                sub.unsubscribeAll();

                // Detach all subscription handlers to ensure we don't unnecessarily create memory leaks.
                sub.detach();
              }
            }
          });
          return dialogs.showYesNo(MicrosUtils.microsLex(DB_SYNC_ARE_YOU_SURE)).yes(function (dialog) {
            return network.databaseSync().then(function () {
              return true;
            })["catch"](feDialogs.error);
          }).no(function (dialog) {
            console.log(MicrosUtils.microsLex(DB_SYNC_ABANDONED));
            return true;
          });
        })
        //.catch(feDialogs.error);
        ["catch"](function (err) {
          //console.log( MicrosUtils.microsLex(DB_SYNC_CMD_ERROR, '', [err]) );
          feDialogs.error(err);
        });
      } // end function
    });
  };
  DatabaseSyncCommand.prototype = Object.create(Command.prototype);
  DatabaseSyncCommand.prototype.constructor = DatabaseSyncCommand;
  return DatabaseSyncCommand;
});
