/**
 * @file Start the alarm app.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam and Gareth Johnson
 */
require(['Promise', 'mobile/util/mobile/views/widgetViewUtil', 'nmodule/alarm/rc/console/AlarmConsole', 'bajaux/Widget'], function (Promise, widgetViewUtil, AlarmConsole, Widget) {
  'use strict';

  widgetViewUtil.loadPageView(function () {
    var console = new AlarmConsole("alarm", "AlarmUxConsole", Widget.formfactor.max);

    console.toDisplayName = function () {
      var value = this.value();
      return Promise.resolve(value && value.getDisplayName());
    };

    return console;
  });
});
