var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @private
 * @module mobile/fieldeditors/mobile/TimeEditor
 */
define(['baja!', 'lex!mobile', 'jquery', 'jqmDatebox', 'underscore', 'mobile/fieldeditors/MobileFieldEditor', 'mobile/fieldeditors/mobile/feUtils', 'mobile/util/time'], function (baja, lexs, $, jqmDatebox, _, MobileFieldEditor, feUtils, timeUtil) {

  'use strict';

  var dateboxArmHandlers = feUtils.dateboxArmHandlers,
      getBajaTimeFormat = feUtils.getBajaTimeFormat,
      getDateboxDefaultOptions = feUtils.getDateboxDefaultOptions,
      MILLIS_IN_HOUR = timeUtil.MILLIS_IN_HOUR,
      MILLIS_IN_MINUTE = timeUtil.MILLIS_IN_MINUTE,
      MILLIS_IN_SECOND = timeUtil.MILLIS_IN_SECOND,
      _lexs = _slicedToArray(lexs, 1),
      mobileLex = _lexs[0];

  /**
   * @private
   * @class
   * @alias module:mobile/fieldeditors/mobile/TimeEditor
   * @extends module:mobile/fieldeditors/MobileFieldEditor
   */


  var TimeEditor = function TimeEditor() {
    MobileFieldEditor.apply(this, arguments);
  };
  TimeEditor.prototype = Object.create(MobileFieldEditor.prototype);
  TimeEditor.prototype.constructor = TimeEditor;

  /**
   * @param {JQuery} dom
   */
  TimeEditor.prototype.doInitialize = function (dom) {
    dom.append(makeTimeInput(this.name));
    dateboxArmHandlers(dom);
  };

  TimeEditor.prototype.doLoad = function (value) {
    if (value === null || value === undefined) {
      return;
    }

    var timeInput = this.jq().find('input:jqmData(role="datebox")');

    return value.toTimeString({ textPattern: getBajaTimeFormat() || 'HH:mm' }).then(function (str) {
      timeInput.trigger('datebox', { method: 'set', value: str });
    });
  };

  TimeEditor.prototype.doRead = function () {
    return getBajaTimeFromDatebox(this, 'minute');
  };

  function getBajaTimeFromDatebox(editor, accuracy) {
    var timeInput = editor.jq().find('input[name$=time]'),
        theDate = timeInput.datebox('getTheDate'),
        ms = 0,
        index = _.indexOf(['hour', 'minute', 'second', 'millisecond'], accuracy || 'millisecond');

    if (index < 0) {
      throw new Error("invalid accuracy argument " + accuracy);
    }
    if (index >= 0) {
      ms += theDate.getHours() * MILLIS_IN_HOUR;
    }
    if (index >= 1) {
      ms += theDate.getMinutes() * MILLIS_IN_MINUTE;
    }
    if (index >= 2) {
      ms += theDate.getSeconds() * MILLIS_IN_SECOND;
    }
    if (index >= 3) {
      ms += theDate.getMilliseconds();
    }

    return baja.Time.make(ms);
  }

  function makeTimeInput(slotName) {
    var timeInput = $('<input type="text" data-role="datebox" ' + 'id="' + slotName + '_time" name="' + slotName + '_time"/>'),
        options = getDateboxDefaultOptions();

    options.mode = 'timebox';
    options.useDialogForceFalse = true;
    options.lockInput = false;
    options.centerHoriz = true;
    options.centerVert = true;
    options.setTimeButtonLabel = mobileLex.get({
      key: 'propsheet.datebox.setTimeButtonLabel',
      def: 'Set Time'
    });

    timeInput.attr('data-options', JSON.stringify(options));

    return timeInput;
  }

  return TimeEditor;
});
