/**
 * @file ORD-related utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file AOP utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Mobile-related utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Niagara Mobile Utils - Pages
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @file Functions related to the management and display of JQM
 * dialog boxes.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Niagara Mobile Utils - functions relating to the
 * "available commands" button and associated dialog in our JQM page headers
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @file Niagara Mobile Utils - functions relating to the
 * "available views" button and associated dialog in our JQM page headers
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @file
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Functions relating to navbar management in Niagara apps.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Functions relating to navbar management in Niagara mobile apps.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file A view to take up an entire JQM page.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file The base ViewManager class, used for management of and
 * navigation between views.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file A manager for navigating back and forth between PageViews.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Slot-related utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Functions relating to the BaseFieldEditor object that all
 * field editors in Niagara mobile apps extend from. Also, functions relating
 * to registering field editors on Types.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Base field editor from which all others inherit.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Composite field editors.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Dialogs relating to field editors, including action invocation.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file A base class for views used in JQM apps.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file A view for constructing a JQM list.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Color utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Gradient utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Functions for calculating the gradients on a property
 * sheet status swatch.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file A view listing slots of a component for use in a property sheet.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file A view for the property sheet app containing a property
 * sheet list view plus extra buttons.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file A view for navigating between property sheets.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Field editors for use in a JQM app.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Time-related utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file The built-in field editors available to all Niagara Mobile
 * apps. These field editors make use of jQuery Mobile with the Datebox plugin.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Functions relating to the Niagara Mobile Property Sheet
 * user interface, HTML generation, event handling, etc.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Run the property sheet app.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define("mobile/util/ord",["baja!"],function(e){"use strict";function t(e){if(!e)return"";e=String(e);var t=e.length,n=e.substring(t-1,t),i=e.substring(t-2,t-1);return"/"===n&&":"!==i?e=e.substring(0,t-1):":"===n&&(e+="/"),e}function n(t,n){return t=e.Ord.make(t),void 0===n&&(n=!0),t.get({lease:n})}function i(e){e=unescape(String(e)),e.match(/\/$/)&&(e=e.substring(0,e.length-1));var n=e.split("/"),i=0,r=[];for(i=0;i<n.length;i++)r.push(t(n.slice(0,i+1).join("/")));return r}function r(t,n){return!(!t||!n)&&e.Ord.make(t).relativizeToSession().equals(e.Ord.make(n).relativizeToSession())}function o(t){if(t){if(t instanceof e.Ord||"string"==typeof t)return t.toString();if(t.getType().isComponent()&&t.isMounted())return t.getNavOrd().relativizeToSession().toString();if(t.getType().isComplex()){var n=o(t.getParent());if(n)return n+"/"+t.getPropertyInParent()}}}return{chopLastSlash:t,deriveOrd:o,equivalent:r,get:n,makeOrdHistory:i}});var _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};define("mobile/util/aop",["baja!"],function(e){"use strict";function t(t,n){return e.iterate(t,function(e){return e[n]},function(e){return e.prototype})}function n(e,i,r,o){if("function"!=typeof o)throw"missing AOP function wrapper";var a,l;if("function"==typeof e&&"function"==typeof i)return r=e,a=i,l=o(r,a),l.prototype=a.prototype,l;if("object"!==(void 0===e?"undefined":_typeof(e))&&"function"!=typeof e||"string"!=typeof i||"function"!=typeof r)throw"AOP functions must be called with argument signature [Function, Function] or [Object, String, Function]";a=t(e,i),e[i]=n(r,a,null,o)}function i(e,t,i){return n(e,t,i,function(e,t){return function(){var n=Array.prototype.slice.call(arguments),i=e.call(this,n);if(!1!==i)return t.apply(this,i||n)}})}function r(e,t,i){return n(e,t,i,function(e,t){return function(){var n=Array.prototype.slice.call(arguments),i=t.apply(this,n),r=e.call(this,n,i);return void 0===r?i:r}})}function o(t,n){e.strictArg(t,Object),n=e.objectify(n);var o=n.before||{},a=n.after||{};return e.iterate(o,function(e,n){i(t,n,e)}),e.iterate(a,function(e,n){r(t,n,e)}),t}function a(t,n){return e.strictArg(t,Function),o(t.prototype,n),t}return{advise:o,advisePrototype:a,after:r,before:i}}),define("mobile/util/mobile/mobile",["baja!","jquery","jquerymobile","Promise"],function(e,t,n,i){"use strict";function r(e){return String(e).replace(/[&<>"'\/]/g,function(e){return D[e]})}function o(){n.loading("show")}function a(){n.loading("hide")}function l(e){var n=e.find(':jqmData(role="header")'),i=e.find(':jqmData(role="footer")'),r=window.innerHeight||t(window).height();return n.length&&(r-=n.outerHeight()),i.length&&(r-=i.outerHeight()),r}function u(e,t){var n=t||e.children(':jqmData(role="content")'),i=l(e),r=n.outerHeight()-n.height();n.height(i-r),n.parent().height(Math.max(n.parent().height(),i)),setTimeout(function(){n.trigger("updatelayout")},100)}function s(e,n,i){e.on(n,i);var r=t._data(e[0]),o=r.events,a=o[n];a.length>1&&a.splice(0,0,a.pop())}function c(t,n,i){var r=this;r.$ticket=setTimeout(function(){r.$ticket&&o()},t),n&&(r.$timeoutTicket=setTimeout(function(){if(r.$ticket){var t="timeout "+n+"ms reached";"function"==typeof i?i(t):e.error(t)}r.hide()},n))}function d(e,t,n){return new c(e||1e3,t,n)}function f(e,t){e.toggleClass("ui-listview-inset ui-corner-all ui-shadow",t);var n=e.children("li"),i=n.first(),r=n.last();i.toggleClass("ui-corner-top",t),r.toggleClass("ui-corner-bottom",t),i.children("a").last().toggleClass("ui-corner-tr",t),r.children("a").last().toggleClass("ui-corner-br",t)}function p(e){f(e,!0)}function m(e){f(e,!1)}function h(e){e.on("click","a",function(){var e=t(this);setTimeout(function(){e.removeClass(function(e,t){return"ui-btn-active "+(t.match(/\bui-btn-hover-\w/g)||[]).join(" ")})},100)})}function g(e){return e=String(e),"#"===e.charAt(0)&&(e=e.substring(1)),e.replace(C,function(e){return"_"+e.charCodeAt(0).toString(16).toUpperCase()})}function v(e){if(!e)return e;e=e instanceof t?e.attr("id"):String(e);var n=/\_([A-Z0-9][A-Z0-9])/g;return e=e.replace(n,function(e){return String.fromCharCode(parseInt(e.substring(1,e.length),16))}),unescape(e)}function b(t){var n=t&&t.viewQuery;return n||(t=e.objectify(t,"viewQuery"),n=t.viewQuery),"string"==typeof n||n&&n.id?n=new e.ViewQuery(n):!n&&t.id&&(n=new e.ViewQuery(t)),t.viewQuery=n,t}function y(t,n){n=b(n);var i;i=n.viewQuery?e.Ord.make({base:t,child:n.viewQuery}):e.Ord.make(t),window.location.assign(i.toUri())}function w(n,i){i=b(i);var r;r=i.viewQuery?e.Ord.make({base:n,child:i.viewQuery}):e.Ord.make(n),t.mobile.changePage(r.toUri(),i)}function j(n,r){var o=d(1e3);return i.resolve(t.ajax({url:e.Ord.make(n).toUri(),type:"POST",headers:{"niagara-mobile-rpc":"typeSpec"}})).then(function(e){return o.hide(),e.typeSpec===niagara.view.typeSpec?w(n,r):y(n,r)},function(e){return o.hide(),y(n,r)})}function k(e,t){S().pagecontainer("change",e,t)}function S(){return t(":mobile-pagecontainer")}function x(){return S().pagecontainer("getActivePage")}function T(e){S().length?e():t(window).one("pagecontainercreate",e)}var C=/[^\w-_]/g,D={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","/":"&#x2F;"};return c.prototype.hide=function(){a();var e=this;clearTimeout(e.$ticket),delete e.$ticket,clearTimeout(e.$timeoutTicket),delete e.$timeoutTicket},{applyListviewInset:p,changePage:k,decodePageId:v,encodePageId:g,escapeHtml:r,getActivePage:x,getPageContainer:S,getVisibleHeight:l,hidePageLoadingMsg:a,linkToOrd:j,linkToOrdExternal:y,linkToOrdInternal:w,onPageContainerCreate:T,prependEventHandler:s,preventNavbarHighlight:h,removeListviewInset:m,setContentHeight:u,showPageLoadingMsg:o,spinnerTicket:d}}),define("mobile/util/mobile/pages",["baja!","jquery","jquerymobile","mobile/util/mobile/mobile"],function(e,t,n,i){"use strict";function r(e,t){1===arguments.length&&(t=e,e=M);var n=e;return"string"==typeof n&&(n=function(t){return e===t}),N.push({isMatch:n,handler:t}),t}function o(e){if(!e)return null;var t;for(t=0;t<N.length;++t)if(N[t].isMatch(e))return N[t].handler;return null}function a(e){var t=e.page.attr("id")||M,n=o(t);n&&"function"==typeof n[e.eventName]&&n[e.eventName](e)}function l(t){t=e.objectify(t,"eventName");var n;for(n=0;n<N.length;++n)"function"==typeof N[n].handler[t.eventName]&&N[n].handler[t.eventName](t)}function u(){return D.attr("id")||""}function s(){return o(u())}function c(){return D}function d(){return E.attr("id")||""}function f(){return E}function p(){return o(d())}function m(){return C}function h(e,n){var i,r=n.toPage;n&&n.prevPage&&(i=t(n.prevPage)),D||(i=r),a({page:r,prevPage:i,event:e,eventName:"pageshow"}),"dialog"!==r.jqmData("role")&&(D=E,E=r)}function g(e,n){var i,r=t(e.target);r&&(n&&n.prevPage&&(i=t(n.prevPage)),D||(i=r),a({page:r,prevPage:i,event:e,eventName:e.type}))}function v(e,n){var i;n&&n.nextPage&&(i=t(n.nextPage)),a({page:E,nextPage:i,event:e,eventName:"pagehide"})}function b(e,n){C=!1;var i;n&&n.nextPage&&(i=t(n.nextPage)),a({page:E,nextPage:i,event:e,eventName:e.type})}function y(e,n){a({page:t(e.target),event:e,eventName:e.type})}function w(e){return e=decodeURIComponent(e),"/"!==e.charAt(0)&&"#"!==e.charAt(0)||(e=e.substring(1)),e.match(/^ord[\?\/]/)?"ord?"+encodeURI(e.substring(4)):encodeURI(e)}function j(e){return I(w(e))}function k(e,t,n){if(!e||"function"!=typeof e.createPage)throw new Error("No page handler (or no createPage function) found for id "+t);e.createPage(n)}function S(n,i){if(!O){var r,a=o(n),l=P();O=!0,i.pageData&&a&&"function"==typeof a.encodeUrl&&(n=a.encodeUrl(i.pageData)),r=j(n),l.children("#"+r).length||k(a,r,t.extend(i,{ok:function(e){e.attr("id",r),l.append(e),e.jqmData("pageData",i.pageData),e.page(),O=!1,t.mobile.changePage(e,i)},fail:function(t){O=!1,e.fail(t)}}))}}function x(n,i){if("string"==typeof i.toPage){var r,l,u,s=t.mobile.path.parseUrl(i.toPage),c=w(s.pathname+s.search),d=w(s.hash||""),f=w(s.pathname||""),p=d,m=P();if(!(d.indexOf("&ui-state=dialog")>-1)&&(r=o(p),r||(p=f,r=o(p)),r||(p=c,r=o(p)),r)){if(l=m.children("#"+j(p)),!l.length&&d&&(l=m.children("#"+j(d))),l.length||(l=m.children("#"+j(c))),d&&l.length||(i.options.dataUrl="/"+c),!l.length){if("function"!=typeof r.createPage)return;u=r.decodeUrl&&r.decodeUrl(s),i.options.pageData=u,i.options.url=s,e.started(function(){S(p,i.options)})}i.options.role&&"dialog"===i.options.role||l.is(".ui-dialog")||(l.length&&t.mobile.changePage(l,i.options),n.preventDefault())}}else if(i.toPage instanceof t){if(i.consumed)return;i.consumed=!0,"dialog"!==i.toPage.jqmData("role")&&(i.options.fromPage&&"dialog"!==i.options.fromPage.jqmData("role")&&a({page:i.options.fromPage,nextPage:i.toPage,event:n,eventName:"pagebeforechange",options:i.options}),n.isDefaultPrevented()||setTimeout(function(){i.toPage.trigger("pagelayout")},0))}}function T(){var e=P();e.on("pagebeforecreate pagecreate pageinit pagelayout","div",y).on("pagecontainershow",h).on("pagebeforeshow","div",g).on("pagecontainerhide",v).on("pagebeforehide","div",b),e.on("pagecontainerbeforechange",x)}var C=!0,D=null,E=null,N=[],O=!1,I=i.encodePageId,P=i.getPageContainer,q=i.onPageContainerCreate,M="____DEFAULT_PAGE_$_$";return q(T),{register:r,getPrevName:u,getPrev:c,getPrevHandler:s,getCurrentName:d,getCurrent:f,getCurrentHandler:p,getHandler:o,fire:a,fireAll:l,isFirst:m}});var _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,o=void 0;try{for(var a,l=e[Symbol.iterator]();!(i=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);i=!0);}catch(e){r=!0,o=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw o}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/util/mobile/dialogs",["baja!","lex!mobile","jquery","jquerymobile","Promise","mobile/util/mobile/pages","mobile/util/mobile/mobile","css!mobile/util/mobile/dialogs"],function(e,t,n,i,r,o,a){"use strict";function l(t,i){return t instanceof n?(i.html(t),r.resolve()):"object"===(void 0===t?"undefined":_typeof(t))||"string"==typeof t?(t instanceof Error&&e.error(t),i.text(String(t)),r.resolve()):"function"==typeof t?r.try(function(){return t(i.empty())}):void 0}function u(e){var t=o.getCurrent();return"string"==typeof e&&(e=f(e),e=n("#"===e.charAt(0)?e:"#"+e)),!t||!e||t[0]!==e[0]}function s(t,i){var r=n(w.patternReplace({theme:"a"})),o=r.children(":jqmData(role=content)").children(".dialogButtons");return e.iterate(i,function(e,t){var i=n(j.patternReplace({value:e}));i.text(v.get({key:e,def:e})),i.appendTo(o)}),r.attr("id",t),0===t.indexOf("error")&&r.addClass("error"),r.appendTo(m()),r}var c=e.callbackify,d=a.decodePageId,f=a.encodePageId,p=a.getActivePage,m=a.getPageContainer,h=a.hidePageLoadingMsg,g=_slicedToArray(t,1),v=g[0],b={},y=void 0,w=void 0,j=void 0,k=!1;w='<div data-role="dialog" class="dynamicDialog" data-overlay-theme="b">\n<div class="dynamicDialogHeader" data-role="header" data-theme="a">\n<h1 class="title" />\n</div>\n<div class="dynamicDialogContent" data-role="content" data-theme="c">\n<div class="dialogDisplay"></div>\n<div class="dialogButtons" data-role="controlgroup" data-type="horizontal"></div>\n</div>\n</div>',j='<a data-value="{value}" data-role="button" data-theme="a"></a>';var S=function(t,n){this.$params=e.objectify(t,"content"),this.$returnPage=t.returnPage,this.$page=n,k=!0};b.DialogInvocation=S,S.prototype.close=function(e){e=e||"cancel";var t=this,r=t.$options,o=t.$returnPage;"string"==typeof o&&0!==o.indexOf("ord?")&&"#"!==o.charAt(0)&&(o="#"+o),o instanceof n||"string"==typeof o?i.changePage(o,n.extend({transition:"none",changeHash:u(o)},r)):"function"==typeof o?o.call(this,e):i.changePage(location.href,{transition:"none",changeHash:!1}),y=void 0},S.prototype.invoke=function(t,n){function i(e){k=!1,u.fail(e),n.fail(e),k||a.close(t)}var r=e.ok,o=b.error;n=c(n,r,o);var a=this,l=a.$params,u=c(l.callbacks,r,o),s="function"==typeof t?t:l[t];"function"!=typeof s&&(s=function(e){e.ok()});try{k=!1,s.call(a,{ok:function(){k||a.close(t),u.ok(),n.ok()},fail:i})}catch(e){i(e)}},S.prototype.redirect=function(e,t){this.$returnPage=e,this.$options=t||{}},S.prototype.load=function(){var e=this,t=e.$page,i=e.$params,r=t.find(":jqmData(role=header)"),o=t.find(":jqmData(role=content)"),a=o.children(".dialogDisplay"),u=r.find("a:jqmData(icon=delete)"),s=o.find(".dialogButtons a");return r.find("h1.title").text(i.title||""),s.off("click").addClass("ui-disabled"),u.off().on("click",function(){return e.invoke("cancel"),!1}),l(i.content||"",a).then(function(){s.on("click",function(){var t=n(this).jqmData("value");e.invoke(t)}),s.removeClass("ui-disabled"),b.repositionDialog(t)},function(e){b.error("Failed to load dynamic dialog content: "+e)})},b.repositionDialog=function(e){var t=e.children(".ui-dialog-contain"),i=e.find(":jqmData(role=header)"),r=t.outerHeight(),o=n(window).height(),a=(o-r)/2,l=Math.max(a,15);t.css("margin-top",l),i.css("margin-top",l)},b.closeCurrent=function(){y&&y.close()},b.registerDialog=function(e,t){function r(e){y?y.load():e.page.find(".dialogDisplay").empty()}function a(r){var o=n("#"+e);return o.length||(o=s(e,t)),r.returnPage=y&&y.$returnPage||r.returnPage,y=new S(r,o),i.changePage(o,{changeHash:!1,allowSamePageTransition:!0,transition:"none"}),y}var l;l={load:a,pagebeforeshow:r},o.register(e,l)},function(){var e=b.registerDialog;e("yesNoCancelDialog",["yes","no","cancel"]),e("yesNoDialog",["yes","no"]),e("okCancelDialog",["ok","cancel"]),e("okDialog",["ok"]),e("errorDialog",["ok"]),e("cancelDialog",["cancel"])}();var x=function(e,t){return o.getHandler(e).load(t)};return b.yesNoCancel=function(e){return x("yesNoCancelDialog",e)},b.ok=function(e){return x("okDialog",e)},b.okCancel=function(e){return x("okCancelDialog",e)},b.cancel=function(e){return x("cancelDialog",e)},b.yesNo=function(e){return x("yesNoDialog",e)},b.error=function(t,n){return n=n||function(e){e.ok()},"function"!=typeof t&&e.error(t),h(),x("errorDialog",{title:v.get("appError"),content:t,ok:n})},b.unrecoverableError=function(t){var i,r=function(){location.reload()};return"function"==typeof t?i=t:(i=function(e){var i=n("<div/>").css({"margin-bottom":"1em"}).text(String(t)),r=n("<div/>").text(v.get("message.clickOKToReload"));e.append(i),e.append(r)},e.error(t)),h(),x("errorDialog",{title:v.get("unrecoverableError"),content:i,ok:r})},b.confirmAbandonChanges=function(t){t=e.objectify(t);var n=function(e){e.ok()},i=t.yes||n,r=t.no||n,a=t.redirect;return t.title=v.get("abandonChanges"),t.content=v.get({key:"message.confirmUnsavedChanges",args:[t.viewName]}),t.returnPage||(t.returnPage=d(o.getCurrent())),t.yes=function(e){a&&this.redirect(a),i.call(this,e)},t.no=function(e){a&&this.redirect(a),r.call(this,e)},b.yesNoCancel(t)},b.showDialog=function(e,t){var n=o.getHandler(e);return n?n.load(t):b.error(v.get({key:"dialogs.noPageRegistered",args:[e]}))},function(){n(window).on("resize",e.throttle(function(){var e=p();"dialog"===e.jqmData("role")&&b.repositionDialog(e)},500))}(),function(){var t=window.location.hash;t.indexOf("&ui-state=dialog")>0&&e.started(function(){i.changePage(t.replace("&ui-state=dialog",""),{changeHash:!0,transition:"none"})})}(),b}),define("mobile/util/mobile/commands",["require","css!mobile/util/mobile/commands","jquerymobile","baja!","jquery","Promise","underscore","bajaux/commands/Command","mobile/util/mobile/dialogs","mobile/util/mobile/pages","mobile/util/mobile/mobile","lex!mobile"],function(e){"use strict";function t(){return m(x.patternReplace({title:j.get("menu")}))}function n(e,t,n){if(e=g.filter(e,function(e){return e.isEnabled()}),m("a.commandsButton").trigger("onShowCommands",e),n=k(n),t=t||j.get("commands.title"),0===e.length)b.ok({title:t,content:j.get("commands.noneAvailable")});else var i=b.cancel({title:t,content:function(t){var n=g.map(e,function(e){var t=m("<li/>"),n=m("<a/>").appendTo(t);return e.toDisplayName().then(function(r){return n.text(r),n.click(function(){i.invoke(function(t){e.invoke().then(t.ok,t.fail)})}),t})});return h.all(n).then(function(e){var n=m('<ul data-role="listview" data-theme="c" />').html(e);t.html(n),n.listview()})},callbacks:n})}function i(){var e=Array.prototype.slice.call(arguments);p.iterate(e,function(e){S.contains(e)||S.push(e)})}function r(){var e=Array.prototype.slice.call(arguments);p.iterate(e,function(e){S.contains(e)||(S.length?S.splice(0,0,e):S.push(e))})}function o(e){var t=Array.prototype.slice.call(arguments);t.length>1?p.iterate(t,function(e){o(e)}):p.iterate(S,function(t,n){if(t===e)return S.splice(n,1),!0})}function a(){return S.slice(0)}function l(e){S=e}function u(){var e=a(),t=y.getCurrentHandler();return t&&"function"==typeof t.getCommands&&(e=t.getCommands({commands:e,page:y.getCurrent()})),n(e),!1}function s(){return d}function c(){return f}e("css!mobile/util/mobile/commands"),e("jquerymobile");var d,f,p=e("baja!"),m=e("jquery"),h=e("Promise"),g=e("underscore"),v=e("bajaux/commands/Command"),b=e("mobile/util/mobile/dialogs"),y=e("mobile/util/mobile/pages"),w=e("mobile/util/mobile/mobile"),j=e("lex!mobile")[0],k=p.callbackify,S=[],x="<a class='commandsButton profileHeader' title='{title}' data-icon='bars' data-role='button' data-iconpos='notext'></a>";return f=new v("%lexicon(mobile:commands.logout)%",function(e){var t=location.protocol+"//"+location.host+"/logout";window.location.assign(t+"?csrfToken="+encodeURIComponent(m("#csrfToken").val()))}),"undefined"!=typeof niagara&&niagara.view.profile.showLogoutCmd&&r(f),d=new v("%lexicon(mobile:commands.home)%",function(e){w.linkToOrd(p.getUserHome())}),"undefined"!=typeof niagara&&niagara.view.profile.showHome&&r(d),{getCommandsButton:t,getHomeCmd:s,getLogoutCmd:c,showCommandsDialog:n,addDefaultCommand:i,prependDefaultCommand:r,removeDefaultCommand:o,getDefaultCommands:a,setDefaultCommands:l,showCommandsHandler:u}}),define("mobile/util/mobile/selectview",["baja!","lex!mobile","Promise","bajaux/commands/Command","mobile/util/mobile/dialogs","mobile/util/mobile/mobile","mobile/util/mobile/commands"],function(e,t,n,i,r,o,a){"use strict";function l(t){var n=t.getSlots(),i=[];return e.iterate(n,function(e){var n=t.get(e);i.push({displayName:n.get("displayName"),url:n.get("ord").toUri()})}),i}function u(t,n){var u=l(t),s=[];if(!u.length)return r.ok(d.get("views.noneAvailable"));e.iterate(u,function(e){s.push(new i(e.displayName,function(){o.linkToOrd(e.url)}))}),a.showCommandsDialog(s,void 0,n)}function s(t){return t=t||niagara.view.ord,o.showPageLoadingMsg(),e.rpc({typeSpec:"mobile:ComponentServerSideHandler",method:"getMobileAgentList",args:[String(t)]}).then(function(t){return e.bson.decodeValue(JSON.parse(t))}).then(function(e){u(e)}).catch(r.error).finally(function(){o.hidePageLoadingMsg()})}function c(){return p}var d=t[0],f="",p=new i("%lexicon(mobile:views.selectView)%",function(){return s(f)});return p.setOrd=function(e){f=e},niagara.view.profile.showViews&&a&&a.prependDefaultCommand(c()),{getViewsCommand:c}}),define("mobile/util/views/views",["baja!","lex!mobile"],function(e,t){"use strict";function n(t){if(t instanceof e.Complex)return t.getDisplayName()||t.getName()||i.get("propsheet.station")}var i=t[0];return{getComponentName:n}});var _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};define("mobile/util/nav",["baja!","bajaux/Widget","Promise","underscore","mobile/util/views/views","mobile/util/ord","mobile/util/mobile/mobile"],function(e,t,n,i,r,o,a){"use strict";function l(n){return n instanceof c?n:n instanceof e.Ord||"string"==typeof n?new d(n):n instanceof t?new p(n):n instanceof e.Complex?new f(n):n&&"object"===(void 0===n?"undefined":_typeof(n))?new m(n):void 0}function u(e,t){return e?o.equivalent(e.getNavOrd(),t)?e:i.find(e.getNavChildren(),function(e){return u(e,t)}):null}var s=r.getComponentName,c=function(e){this.$navChildren=[],this.$value=e};c.prototype.getNavOrd=function(){return this.$navOrd},c.prototype.setNavOrd=function(e){this.$navOrd=e},c.prototype.getNavDescription=function(){return this.$navDescription},c.prototype.setNavDescription=function(e){this.$navDescription=e},c.prototype.getNavIcon=function(){return this.$navIcon},c.prototype.setNavIcon=function(e){this.$navIcon=e},c.prototype.getNavChildren=function(){return this.$navChildren},c.prototype.setNavChildren=function(e){this.$navChildren=e},c.prototype.getNavParent=function(){return this.$navParent},c.prototype.setNavParent=function(e){this.$navParent=e},c.prototype.getValue=function(){return this.$value},c.prototype.setValue=function(e){this.$value=e},c.prototype.toString=function(){return String(this.$navOrd)},c.prototype.toDisplayName=function(){return n.resolve(this.$navDescription)};var d=function(t){c.apply(this,arguments);var n=e.Ord.make(t),i=String(n),r=i.split("/");this.$navOrd=n,this.$navDescription=r[r.length-1]};d.prototype=Object.create(c.prototype),d.prototype.constructor=d;var f=function(e){c.apply(this,arguments),this.$navDescription=s(e),this.$navOrd=o.deriveOrd(e),this.$navIcon=e.getIcon()};f.prototype=Object.create(c.prototype),f.prototype.constructor=d;var p=function(t){c.apply(this,arguments);var n,i,r=t.value();this.$view=t,r instanceof e.Complex&&(n=o.deriveOrd(r),i=r.getIcon()),!n&&t.pageId&&(n=a.decodePageId(t.pageId),0===n.indexOf("ord?")&&(n=n.substring(4))),this.$navOrd=n,this.$navIcon=i};p.prototype=Object.create(c.prototype),p.prototype.constructor=p,p.prototype.toDisplayName=function(){var e=this,t=e.$displayName;return t?n.resolve(t):e.$view.toDisplayName().then(function(t){return e.$displayName=t,t})};var m=function(e){this.$navOrd=e.$navOrd,this.$navDescription=e.$navDescription,this.$navIcon=e.$navIcon,this.$navChildren=e.$navChildren||[],this.$navParent=e.$navParent,this.$value=e.$value};m.prototype=Object.create(c.prototype);var h=function(){this.$selectedNode=null,this.$nodes=[],this.$changeListeners=[],this.$cutListeners=[]};e.event.mixin(h.prototype),h.prototype.add=function(e){var t=l(e);return this.pruneOtherBranch(t),this.$nodes.push(t),this},h.prototype.cut=function(t){if(!t||this.indexOf(t)<0)return this;t=l(t);var n=this,i=n.next(t);return i&&n.cut(i),n.$nodes.pop(),n.fireHandlers("cut",e.error,this,t),n},h.prototype.getSelectedNode=function(){return this.$selectedNode},h.prototype.getSelectedIndex=function(){return this.indexOf(this.getSelectedNode())},h.prototype.setSelectedNode=function(t){t=l(t),this.indexOf(t)<0&&this.add(t),this.$selectedNode=t,this.fireHandlers("change",e.error,this)},h.prototype.getNodes=function(){return this.$nodes},h.prototype.getOrds=function(){var e=[];return this.each(function(t){e.push(t.getNavOrd())}),e},h.prototype.each=function(t){return e.iterate(this.$nodes,t)},h.prototype.isEmpty=function(){return 0===this.$nodes.length},h.prototype.first=function(){return this.get(0)},h.prototype.last=function(){return this.get(this.size()-1)},h.prototype.indexOf=function(e){if(!e)return-1;e=l(e);var t,n=this,i=e.getNavOrd();return t=n.each(function(e,t){var n=e.getNavOrd();if(o.equivalent(i,n))return t}),void 0===t?-1:t},h.prototype.get=function(e){return this.$nodes[e]},h.prototype.next=function(e){var t=this.indexOf(e);return t>=0?this.get(t+1):void 0},h.prototype.prev=function(e){var t=this.indexOf(e);return t>=0?this.get(t-1):void 0},h.prototype.size=function(){return this.$nodes.length},h.prototype.pruneOtherBranch=function(t){var n=this;n.isEmpty()||n.sameBranch(t,n.last())||e.iterate(1,this.size(),function(e){var i=n.get(e);if(!n.sameBranch(t,i))return n.cut(i)})},h.prototype.sameBranch=function(e,t){var n=decodeURIComponent(String(e.getNavOrd())),i=decodeURIComponent(String(t.getNavOrd()));return n=n.replace(/\/+/g,"/"),i=i.replace(/\/+/g,"/"),0===n.indexOf(i)||0===i.indexOf(n)};var g=function(){h.call(this)};g.prototype=Object.create(h.prototype),g.prototype.constructor=g,g.prototype.add=function(t){var n=this,i=l(t),r=n.$nodes,a={},u=[],s=i.getNavOrd(),c=o.makeOrdHistory(s);return n.pruneOtherBranch(i),e.iterate(0,c.length-1,function(e){if(!r[e]){var t=c[e],n=u.length;r[e]=l(t),a["ord"+n]={ord:t,origIndex:e},u.push(t)}}),u.length&&new e.BatchResolve(u).resolve({ok:function(){var t=this.getTargetObjects();e.iterate(t,function(e,t){var n=a["ord"+t];r[n.origIndex]=l(e)}),n.fireHandlers("change",e.error,this)},fail:e.error}),r[c.length-1]=i,n.fireHandlers("change",e.error,this),this};var v=function(){var t=this;h.call(t),t.$flattenedNavFile=void 0,e.nav.navfile.getRootNode()};return v.prototype=Object.create(h.prototype),v.prototype.constructor=v,v.prototype.makeNavFileOrdHistory=function(t){var n=this,i=o.makeOrdHistory(t),r=i.length,a=[],s=[];return e.iterate(0,r,function(e){var t=i[r-1-e],o=u(n.$flattenedNavFile,t);if(o){for(;o;)a.push(o),o=o.getNavParent();return!0}a.push(l(t))}),r=a.length,e.iterate(0,r,function(e){s.push(a[r-1-e])}),s},v.prototype.add=function(t){var n,i=l(t),r=this,a={},u=[],s=i.getNavOrd(),c=r.makeNavFileOrdHistory(s);return r.pruneOtherBranch(i),n=r.$nodes[c.length-1]||c[c.length-1],n&&n.$fromNavFile&&o.equivalent(n.getNavOrd(),i.getNavOrd())&&(i=n,i.setValue(t)),c[c.length-1]=i,r.$nodes.splice(0,c.length),r.$nodes=c.concat(r.$nodes),e.iterate(0,r.$nodes.length,function(t){var n=r.$nodes[t].getValue(),i=u.length;(n instanceof e.Ord||"string"==typeof n)&&(a["ord"+i]={ord:n,origIndex:t},u.push(n))}),u.length&&new e.BatchResolve(u).resolve({ok:function(){var t=this.getTargetObjects();e.iterate(t,function(e,t){var n=a["ord"+t];r.$nodes[n.origIndex]=l(e)}),r.fireHandlers("change",e.error,this)},fail:e.error}),r.fireHandlers("change",e.error,this),this},v.prototype.sameBranch=function(t,n){var i=this,r=t.getNavOrd(),a=n.getNavOrd(),l=i.makeNavFileOrdHistory(r),u=i.makeNavFileOrdHistory(a),s=l.length,c=u.length;return!e.iterate(0,Math.min(s,c),function(e){if(!o.equivalent(l[e],u[e]))return!0})},{NavModel:h,ComponentSpaceNavModel:g,NavFileNavModel:v}}),define("mobile/util/mobile/nav",["baja!","bajaux/icon/iconUtils","jquery","Promise","underscore"],function(e,t,n,i,r){"use strict";function o(e){var t=this;e.attach("change",function(){t.refresh(e.getSelectedNode())}),this.navModel=e,this.currentIndices={},this.LEFT_TEXT="...",this.RIGHT_TEXT="..."}var a=t.toHtml;return e.event.mixin(o.prototype),o.prototype.makeDiv=function(){var t=this,o=t.currentIndices,a=o.startIndex,l=o.endIndex,u=t.navModel,s=r.range(a,l),c=r.map(s,function(i){var r,o,s=n("<li/>"),c=n('<a data-theme="b" />').appendTo(s);return i===a&&i>0?(c.addClass("scrollLeft"),c.text(t.LEFT_TEXT),s):i===l-1&&i<u.size()-1?(c.addClass("scrollRight"),c.text(t.RIGHT_TEXT),s):(c.addClass("componentLink"),r=u.get(i),o=r.getNavChildren(),c.data("node",r),o.length&&(c.data("icon","arrow-d"),c.data("iconpos","right"),c.data("children",o)),r.toDisplayName().then(function(t){return c.text(e.SlotPath.unescape(t)),s}))});return i.all(c).then(function(e){var t=n('<div class="nav" data-role="navbar" data-theme="b" />');return n("<ul/>").html(e).appendTo(t),t})},o.prototype.getNavBarIndices=function(e,t){t=t||this.navModel.size();var n=e-2,i=e+3,r=0;return i>t?r=i-t:n<0&&(r=n),i-=r,n-=r,n=Math.max(n,0),i=Math.min(i,t),{nodeIndex:e,selectedIndex:e-n,startIndex:n,endIndex:i}},o.prototype.scrollTo=function(e){this.currentIndices=this.getNavBarIndices(e)},o.prototype.scrollLeft=function(){var e=Math.max(this.currentIndices.startIndex,0);this.scrollTo(e)},o.prototype.scrollRight=function(){var e=Math.min(this.currentIndices.endIndex-1,this.navModel.size());this.scrollTo(e)},o.prototype.armHandlers=function(t){var i=this;t.on("click","a.componentLink",function(){var t=n(this),r=t.data("node");i.fireHandlers("click",e.error,i,{a:t,linkActive:t.hasClass("ui-btn-active"),node:r})}),t.on("click","a.scrollLeft",function(){i.scrollLeft(),i.replaceNavBar(i.navModel.getSelectedNode().getValue())}),t.on("click","a.scrollRight",function(){i.scrollRight(),i.replaceNavBar(i.navModel.getSelectedNode().getValue())})},o.prototype.replaceNavBar=function(e){"function"==typeof e.getPage&&(e=e.getPage());var t=this,o=e.children("div:jqmData(role=header)"),l=o.children("div:jqmData(role=navbar)");return t.makeDiv().then(function(e){return l.length?l.replaceWith(e):o.append(e),e.navbar(),t.armHandlers(e),i.all(r.map(e.find("a.componentLink"),function(e){var t=n(e),r=t.data("node"),o=r.getNavIcon(),l=n('<span class="navbar-icon-container ui-btn-text"></span>').prependTo(t);return i.resolve(o?a(o):"").then(function(e){l.append(n('<span class="bajaImage badgeSupport"/>').html(e))})})).then(function(){return e})})},o.prototype.refresh=function(e){var t=this;return i.resolve(t.$refreshPromise).then(function(){var n=t.doRefresh(e);return t.$refreshPromise=n,n}).finally(function(){delete t.$refreshPromise})},o.prototype.doRefresh=function(e){var t=this;if((e=e&&e.length?e:t.$page)&&e.length)return t.$page=e,t.scrollTo(t.navModel.getSelectedIndex()),t.replaceNavBar(e).then(function(e){var n,i=e.find("ul li a");i.length>1&&(n=i.eq(t.currentIndices.selectedIndex),n.addClass("ui-btn-active"),n.find(".ui-icon").removeClass("ui-disabled"))})},{NavBar:o}}),define("mobile/util/mobile/views/PageView",["baja!","bajaux/Widget","jquery","jquerymobile","Promise","css!mobile/util/mobile/views/PageView"],function(e,t,n,i,r){"use strict";var o=function(n){t.call(this,"mobile","PageView"),n=e.objectify(n,"contentViewConstructor"),this.contentViewConstructor=n.contentViewConstructor,this.$title=n.title,this.$ignoreProfileClasses=""};return o.prototype=Object.create(t.prototype),o.prototype.constructor=o,o.prototype.ignoreProfileClasses=function(e){this.$ignoreProfileClasses=e||""},o.prototype.createPage=function(){var e=n('<div class="ux-fullscreen-support" data-role="page" data-theme="c" />'),t=n('<div data-role="header" data-position="fixed" data-tap-toggle="false" data-theme="a" />').appendTo(e),i=n('<a href="#" class="profileHeader profileHeaderBack" data-rel="back" data-icon="arrow-l" data-iconpos="notext"></a>').appendTo(t),r=n('<h1 class="profileHeader viewName"/>').appendTo(t);return n('<div data-role="content" class="ux-root ux-fullscreen"/>').appendTo(e),i.removeClass(this.$ignoreProfileClasses),r.removeClass(this.$ignoreProfileClasses),e},o.prototype.toDisplayName=function(){return r.resolve(this.$title||this.contentView&&this.contentView.toDisplayName()||void 0)},o.prototype.getPage=function(){return this.jq()},o.prototype.getHeaderDiv=function(){return this.jq().children(":jqmData(role=header)")},o.prototype.getContentDiv=function(){return this.jq().children(":jqmData(role=content)")},o.prototype.getFooterDiv=function(){return this.jq().children(":jqmData(role=footer)")},o.prototype.getViewQuery=function(){return this.viewQuery},o.prototype.instantiateContentView=function(e){var t=this.contentViewConstructor;if(t)return new t;throw new Error("instantiateContentView not implemented")},o.prototype.isModified=function(){var e=this.contentView;return e&&e.isModified()},o.prototype.doInitialize=function(e){var t,n=this;if("page"!==e.jqmData("role"))throw new Error("PageView requires a JQM page (data-role='page')");t=e.data("pageData"),n.viewQuery=t&&t.viewQuery,n.pageId=e.attr("id")},o.prototype.doLoad=function(e){var t=this,n=t.contentView;return r.resolve(n&&n.destroy()).then(function(){n=t.contentView=t.instantiateContentView(e);var i=t.getPage().data("ord");return r.all([i?n.resolve(i):r.resolve(e),n.initialize(t.getContentDiv())])}).then(function(t){var i=t[0];return i.getType().is(e.getType())||(i=e),n.load(i)}).then(function(){return n.toDisplayName()}).then(function(e){t.getHeaderDiv().find("h1").text(e)
})},o.prototype.destroy=function(){var e=this,n=e.contentView,i=arguments;return r.resolve(n&&n.destroy()).then(function(){return t.prototype.destroy.apply(e,i)})},o.prototype.save=function(e){var t=this;return t.contentView.save(e).then(function(e){return r.resolve(t.setModified(!1)).then(function(){return e})})},o.prototype.getCommandGroup=function(){return this.contentView.getCommandGroup()},o.prototype.doLayout=function(){return r.resolve(this.contentView&&this.contentView.layout())},o}),define("mobile/util/views/ViewManager",["baja!","bajaux/Widget","Promise"],function(e,t,n){"use strict";var i=function t(){e.callSuper(t,this,arguments),this.$selectedView=void 0};return i=e.subclass(i,t),i.prototype.loadView=function(e){return n.resolve()},i.prototype.getSelectedView=function(){return n.resolve(this.$selectedView)},i.prototype.setSelectedView=function(e){var n=this;return n.getSelectedView().then(function(i){e instanceof t&&e!==i&&(n.$selectedView=e)})},i}),define("mobile/util/mobile/views/PageViewManager",["baja!","lex!mobile","jquery","jquerymobile","Promise","underscore","mobile/util/mobile/mobile","mobile/util/ord","mobile/util/nav","mobile/util/mobile/commands","mobile/util/mobile/dialogs","mobile/util/mobile/pages","mobile/util/mobile/views/PageView","mobile/util/views/ViewManager"],function(e,t,n,i,r,o,a,l,u,s,c,d,f,p){"use strict";function m(e,t){var n,i,r,a=e,u=a.$selectedView;return!!(u&&(n=a.navModel.getOrds(),i=o.indexOf(n,l.deriveOrd(u.value())),(r=o.indexOf(n,t))>=0&&i>=0&&r<i))}var h,g=a.encodePageId,v=a.decodePageId,b=t[0];return h=e.subclass(function t(i){e.callSuper(t,this,["mobile","PageViewManager "]);var r=this;r.navModel=i||new u.NavModel,r.navModel.attach("cut",function(e){var t=e.getValue();t instanceof f&&(t.destroy(),n("#"+t.pageId).remove())}),window.onbeforeunload=function(){var e=r.$selectedView;if(e.isModified()){var t;return e.toDisplayName().then(function(e){t=e}),b.get({key:"message.viewModified",args:[t]})}},e.iterate(s.getDefaultCommands(),function(e){r.getCommandGroup().add(e)})},p),h.prototype.doResolveOrd=function(t){return e.Ord.make(t).get({lease:!0})},h.prototype.createPagesHandlers=function(){function t(t){var n,i=a.spinnerTicket(1e3,5e3),r=t.pageData,o=r.ord;c.doResolveOrd(o).then(function(e){return n=e,c.instantiateView(n,r)}).then(function(e){var i=e.createPage();i.jqmData("view",e),i.jqmData("value",n),i.jqmData("ord",o),t.ok(i)}).catch(e.error).finally(function(){i.hide()})}function n(e){return"/ord/"+(e.ord||"station:|slot")}function i(t){var n,i,r=decodeURIComponent(t.pathname+t.search).replace("&ui-state=dialog","");return 0!==r.indexOf("/ord?")&&0!==r.indexOf("/ord/")?{ord:"station:|slot:"}:(n=r.substring(5),i=e.Ord.make(n).parse().get("view"),{ord:n,viewQuery:i})}function r(t){function n(t){c.addView(r,i,o,a).catch(e.error),i.off("pagelayout",n)}var i=t.page,r=i.jqmData("view"),o=i.jqmData("value"),a=i.jqmData("ord");i.on("pagelayout",n)}function o(e){var t=e.page,n=t.jqmData("view"),i=n.value(),r=i&&i.getType();r&&n.$layoutDone&&r.isComponent()&&r.is("baja:VirtualComponent")&&c.refresh(n),n.$layoutDone=!0}function l(t){var n=t.page,i=n.jqmData("view");i&&i.pageId&&(c.setSelectedView(i).catch(e.error),i.layout())}function u(e){var t,n=c.selectedView;n&&n.isModified()&&(t=v(e.nextPage.attr("id")),c.confirmAbandonChanges(t),e.event.preventDefault())}function s(e){return e.commands}var c=this;return{createPage:t,encodeUrl:n,decodeUrl:i,pagelayout:o,pageshow:l,pagecreate:r,pagebeforechange:u,getCommands:s}},h.prototype.registerPages=function(e){d.register(e||function(e){return e.match(/^ord/)},this.createPagesHandlers())},h.prototype.initializeView=function(e,t,n,i){var r=this;return e.initialize(t).then(function(){return e.load(n)}).then(function(){return r.armHandlers(e),r.attachSubscriberEvents(e),e})},h.prototype.instantiateView=function(e,t){return r.reject("instantiateView not implemented")},h.prototype.addView=function(e,t,n,i){var r=this;return r.initializeView(e,t,n,i).then(function(e){return r.navModel.add(e),r.setSelectedView(e).then(function(){return e})})},h.prototype.armHandlers=function(e){var t=this,i=e.jq();i.on("click","a.link",function(){t.linkToOrd(n(this).jqmData("ord"))}),i.on("click","a.commandsButton",function(){t.showCommands(e)})},h.prototype.showCommands=function(e){var t=e.getCommandGroup(),n=this.getCommandGroup(),i=t.merge(n,{mergeCommands:!1}).flatten({recurse:!0});s.showCommandsDialog(i)},h.prototype.attachSubscriberEvents=function(e){var t=this,i=t.navModel,r=e.contentView.getSubscriber&&e.contentView.getSubscriber();r&&(r.attach("renamed",function(t,i,r){var o=g(t.getName()),a=e.pageId+"_2F"+o,l=g(i),u=e.pageId+"_2F"+l;n("#"+u).attr("id",a)}),r.attach("unmount",function(){var n,r=i.prev(e),o=i.indexOf(r),a=i.indexOf(t.selectedView);a>o?(n=b.get({key:"propsheet.message.unmounted",def:'Component "{0}" has been unmounted.',args:[e.getDisplayName()]}),c.ok({content:n,ok:function(n){for(;r&&!r.getNavOrd();)r=i.prev(r),e=i.prev(e);var o=l.deriveOrd(r.getValue().value());o&&"null"!==o&&t.linkToOrdInternal(o),i.cut(e),n.ok()}})):i.cut(e)}))},h.prototype.confirmAbandonChanges=function(e){var t=this,n=this.$selectedView;return new r(function(i,r){n.isModified()?n.toDisplayName().then(function(o){return c.confirmAbandonChanges({yes:function(e){var o=this;n.save().then(function(){t.refresh(n).then(function(){i(),e.ok()},function(t){r(t),e.fail(t)})},function(t){o.redirect(v(n.pageId)),r(t),e.fail(t)})},no:function(e){n.setModified(!1),t.refresh(n).then(function(){i(),e.ok()},function(t){r(t),e.fail(t)})},viewName:o,redirect:e})}):i()})},h.prototype.save=function(e){return e.save()},h.prototype.saveSelected=function(){var e=this;return e.getSelectedView().then(function(t){return e.save(t)})},h.prototype.setSelectedView=function(t){var i=this;return e.callSuper("setSelectedView",h,this,[t]).then(function(){return t.toDisplayName()}).then(function(e){var r;document.title=e,r=n("#"+t.pageId.replace(/(:|\.)/g,"\\$1")),r.children(":jqmData(role=header)").children("h1.viewName").text(e),i.currentPage=r,i.navModel.setSelectedNode(t)})},h.prototype.refresh=function(e){var t=this;return e.load(e.value()).then(function(){t.attachSubscriberEvents(e)})},h.prototype.refreshSelected=function(){var e=this;return e.getSelectedView().then(function(t){return t.isModified()?e.confirmAbandonChanges(void 0):e.refresh(t)})},h.prototype.linkToOrd=function(e,t){function n(){return a.linkToOrd(e,{viewQuery:t,reverse:m(i,e)})}var i=this;return i.getSelectedView().then(function(e){return e.isModified()?i.confirmAbandonChanges(n):n()})},h.prototype.linkToOrdInternal=function(t,n){n=e.objectify(n),n.reverse=m(this,t),a.linkToOrdInternal(t,n)},h.prototype.linkToOrdExternal=function(e,t){a.linkToOrdExternal(e,t)},h.prototype.layout=function(){return this.getSelectedView().then(function(e){if(e)return e.layout()})},h}),define("mobile/util/slot",["baja!","jquery","Promise","underscore","baja!baja:Link,baja:Password,control:IWritablePoint"],function(e,t,n,i){"use strict";function r(e,t,n){if(t===n||t<0||n<0||t>=e.length||n>=e.length)return!1;var i=e.splice(t,1);return e.splice(n,0,i[0]),!0}function o(e,r,o,a){var l=e.getSlots().dynamic().toArray();return a(l,i.indexOf(l,e.getSlot(r)))?e.reorder(t.extend(o,{dynamicProperties:l})):n.resolve()}function a(e,t,n){return o(e,t,n,function(e,t){return r(e,t,t-1)})}function l(e,t,n){return o(e,t,n,function(e,t){return r(e,t,t+1)})}function u(e,t,n){return o(e,t,n,function(e,t){return r(e,t,0)})}function s(e,t,n){return o(e,t,n,function(e,t){return r(e,t,e.length-1)})}function c(t){var n=t.getFlags();return!!(e.Flags.CONFIRM_REQUIRED&n)}function d(t){return!!t.getType().is("baja:Password")||e.Flags.READONLY&t.getFlags()}function f(t){var n=t.getFlags();return!!(e.Flags.HIDDEN&n)||(!(!t.isProperty()||!t.getType().is("baja:Link"))||("wsAnnotation"===t.getName()||"displayNames"===t.getName()))}function p(e){return!e.getType().is("baja:Password")&&(!d(e)&&!f(e))}function m(e){return e.isAction()&&!f(e)}function h(t){var n,i,r=e.Facets.DEFAULT;return t&&t.getType().isComplex()&&(i=t.getSlots().properties().frozen().is("baja:Facets").firstValue(),"function"==typeof t.getFacets&&(n=t.getFacets())&&(r=e.Facets.make(r,n)),i&&(r=e.Facets.make(r,i))),r}function g(e){var t=e&&e.getType();if(t)return t.isComponent()?e:t.isComplex()?g(e.getParent()):void 0}function v(t,n){var i,r,o,a,l=e.Facets.DEFAULT,u=t&&t.getType();if(n&&t.getType().isComplex()&&(n=t.getSlot(n),n.isProperty()&&n.getType().isComplex()&&(t=t.get(n))),u&&u.isComplex()&&(i=g(t))&&(o=i.getType(),(r=h(i))&&(l=e.Facets.make(l,r))),n instanceof e.Slot){if(a=String(n),o&&o.is("control:IWritablePoint")&&(n.isFrozen()&&0===a.indexOf("in")||"set"===a||"fallback"===a||"override"===a||"emergencyOverride"===a))return l;l=e.Facets.make(l,n.getFacets())}return l}return{getFacets:v,isConfirmRequired:c,isEditable:p,isFireable:m,isHidden:f,isReadonly:d,moveDown:l,moveUp:a,moveToTop:u,moveToBottom:s}}),define("mobile/fieldeditors/fieldeditors",["baja!mobile:MobileFieldEditor","baja!","jquery","Promise","underscore","mobile/util/aop","mobile/util/slot","nmodule/js/rc/asyncUtils/asyncUtils"],function(e,t,n,i,r,o,a,l){"use strict";function u(e,t){var i=n('<div class="labeledEditor"/>').appendTo(t),r=n('<label class="editorLabel" />'),o=n('<div class="editorContainer"/>');return void 0!==e&&r.text(e),i.append(r).append(o),o}function s(e){var t=e.newCopy(!0);return t.editedSlots={},t.getSlots().properties().isComplex().each(function(e){var n=t.get(e);t.set({slot:e,value:s(n)})}),o.after(t,"set",function(e,t){var n=e[0];return this.editedSlots[String(n.slot)]=n.value,t}),t}function c(e,n){n=t.objectify(n);var r,a=n.doInitialize,l=n.doLoad,u=n.doRead,s=n.doSave;return t.strictAllArgs([a,l],[Function,Function]),r=t.subclass(function(){t.callSuper(r,this,arguments)},e),r.prototype.doInitialize=function(t){var n=this;return i.resolve(e.prototype.doInitialize.call(n,t)).then(function(){return a.call(n,t)})},r.prototype.doLoad=function(t){var n=this;return i.resolve(e.prototype.doLoad.call(n,t)).then(function(){return l.call(n,t)})},"function"==typeof u&&(r.prototype.doRead=u),"function"==typeof s&&(r.prototype.doSave=s),n.validate&&o.after(r.prototype,"postCreate",function(e){this.validators().add(n.validate)}),n.postCreate&&o.after(r.prototype,"postCreate",function(e){n.postCreate.call(this)}),n.doEnabled&&o.after(r.prototype,"doEnabled",function(e){n.doEnabled.apply(this,e)}),r}function d(e){return e?t.importTypes({typeSpecs:[e]}).then(function(e){var n=e[0];return!!n.is(N)||(!!n.is(O)||(t.error("fieldEditor facet "+n+" does not reference a sub-Type of MobileFieldEditor."),!1))},function(n){return t.error("fieldEditor facet "+e+" does not reference a known Type."),!1}):i.resolve(!1)}function f(e){function n(e){for(var t=S();e;){if(C[String(e)])return!0;if(t[String(e)])return!0;e=e.getSuperType()}}return null!==e&&void 0!==e?function(){return"string"==typeof e?t.importTypes({typeSpecs:[e]}).then(function(e){return e[0]}):e.getType?i.resolve(e.getType()):i.resolve(e)}().then(function(t){if(n(t))return!0;var i=e.getFacets&&e.getFacets();return d(i&&i.get(I))}):i.resolve(!1)}function p(e){return d(e).then(function(t){return!!t&&f(e)})}function m(e,t,n){var i="/ord/"+e;return i+="|view:mobile:MobileFieldEditorView%3FfeTypeSpec="+t+";typeSpecs="+n.join(",")}function h(e){e=String(e);var t=x(),n=S(),o=t&&t[e],a=[];return o?(r.each(o.js,function(t){a.push(m(t,e,o.agentOn))}),r.each(o.css,function(e){e.indexOf(".css")===e.length-4&&(e=e.substring(0,e.length-4)),a.push("css!"+e)}),E(a).then(function(){delete t[e],delete n[e]})):i.resolve()}function g(e){e=String(e);var t=S(),n=t&&t[e];if(!n)return i.resolve();var o=r.map(n,function(e){return h(e)});return i.all(o).then(function(){delete t[e]})}function v(e){return e.is(N)?h(e):g(e)}function b(e){return e?v(e).then(function(){return b(e.getSuperType())}):i.resolve()}function y(e,n){var r;return e?("string"==typeof e&&(e=t.lt(e)),n=n||"default",b(e).then(function(){for(;!r&&e;){if((r=C[String(e)])&&r[n])return r[n];e=e.getSuperType()}return y("baja:String","default")})):i.reject("cannot get field editor for null type")}function w(e,t,n){if(!e)throw new Error("cannot register field editor for null type");if("function"!=typeof t)throw new Error("editor is required");e=String(e),n=n||"default";var i=C[e]||{};return i[n]=t,C[e]=i,t}function j(e,n,i,r){var o,l=D;return o=n&&i?a.getFacets(n,i):a.getFacets(e),o&&(l=t.Facets.make(l,o)),r&&(l=t.Facets.make(l,r)),l}function k(){return"undefined"!=typeof niagara&&niagara.view||{}}function S(){return k().customFieldEditors||{}}function x(){return k().fieldEditorResources||{}}function T(e,n){arguments.length<2&&(n=e,e=null);try{t.strictArg(n),!1!==n.autoInitialize&&t.strictArg(n.element)}catch(e){return i.reject("element is required to initialize - did you mean to set autoInitialize = false?")}if(void 0===n.value){try{t.strictArg(n.container,t.Complex)}catch(e){return i.reject("container is required when value is undefined")}n.value=n.container.get(n.slot)}var r,o,a,l=n.value,u=!1!==n.autoInitialize,s=n.element,c=n.type||l.getType(),d=n.key;return o=n.container||l.getParent&&l.getParent(),a=n.slot||l.getPropertyInParent&&l.getPropertyInParent(),n.facets=j(l,o,a,n.facets),r=n.facets.get(I),p(r).then(function(i){function f(e){var t=new e(l,o,a,n);return u?t.initialize(s).then(function(){return t.load(l)}).then(function(){return t}):t}return i&&(c=t.lt(r)),e?f(e):y(c,d).then(f)})}var C={},D=t.Facets.make({timeFormat:t.getTimeFormatPattern(),unitConversion:t.getUnitConversion()}),E=l.doRequire,N="mobile:MobileFieldEditor",O="workbench:WbFieldEditor",I="fieldEditor";return{composite:{},defineEditor:c,isRegistered:f,makeFor:T,register:w,toLabeledEditorContainer:u,toSaveDataComponent:s}}),define("mobile/fieldeditors/BaseFieldEditor",["baja!","bajaux/Widget","jquery","Promise","underscore","bajaux/events","bajaux/mixin/batchSaveMixin","nmodule/js/rc/asyncUtils/asyncUtils"],function(e,t,n,i,r,o,a,l){"use strict";function u(e){return e.is('input[type="checkbox"]')||e.is('input[type="radio"]')}function s(t,n){e.iterate(n,function(e){t.addClass(String(e.getTypeSpec()).replace(":","-"))},function(e){return e.getSuperType()})}function c(t,n){var i=e.$(n).decodeFromString(t),r=m[n.toString()];return i.getDataTypeSymbol=function(){return r},i}function d(e,t){var n=e.getType&&e.getType();return!(!n||!n.isComponent())&&(!e.editedSlots&&e!==t)}var f=l.doRequire,p=a.COMMIT_READY,m={"baja.Boolean":"b","baja:Integer":"i","baja:Long":"l","baja:Float":"f","baja:Double":"d","baja:String":"s","baja:DynamicEnum":"e","baja:EnumRange":"E","baja:AbsTime":"a","baja:RelTime":"r","baja:TimeZone":"z","baja:Unit":"u"},h=r.once(function(){return f("mobile/fieldeditors/fieldeditors")}),g=function(n,i,r,o){if(t.call(this,"mobile","BaseFieldEditor"),void 0===n||null===n)return this;o=e.objectify(o),n.getType().isComplex()&&!n.getType().isComponent()&&(n=n.newCopy()),this.$value=n,this.container=i||n.getParent&&n.getParent(),this.slot=r||n.getName&&n.getName(),this.name=String(this.slot),this.params=o,this.facets=o.facets||e.Facets.DEFAULT,this.label=o.label||i&&i.getDisplayName&&r&&i.getDisplayName(r)||n.getName&&n.getName()||r&&String(r),this.parent=o.parent,this.$enabled=!o.readonly,this.$kids=[],this.postCreate(),a(this)};return g.prototype=Object.create(t.prototype),g.prototype.constructor=g,g.prototype.setModified=function(i,r){if(!this.isLoading()){t.prototype.setModified.apply(this,[i]),r=e.objectify(r);var o=this,a=o.parent,l=o.jq();i&&(a&&a.setModified(!0,n.extend({silent:!0},r)),l&&!r.silent&&l.trigger("modified.view",[o,r]))}},g.prototype.postCreate=function(){},g.prototype.doEnabled=function(e){var t=this.jq(),n=t&&t.find("select,input,textarea");n&&(e?n.removeAttr("disabled"):n.attr("disabled","disabled"))},g.$detectChangeEvent=function(){var e,t=n(this),i=t.closest("div.editor"),r=i.data("editor"),o=t.data("oldValue");e=u(t)?t.is(":checked"):t.val(),r.isLoading()||void 0===o||o===e||r.setModified(!0,{oldValue:o,newValue:e,element:t}),t.data("oldValue",e)},g.prototype.buildAndLoad=function(e){var t=this;return t.initialize(e).then(function(){return t.load(t.value())})},g.prototype.load=function(e){var i=this;return t.prototype.load.apply(i,arguments).then(function(e){var t=i.jq();return null!==e&&void 0!==e&&s(t,e.getType()),t.find("input,select,textarea").each(function(){var e=n(this);u(e)?e.data("oldValue",e.is(":checked")):e.data("oldValue",e.val())}),e})},g.prototype.initialize=function(e){return e=n('<div class="editor ui-field-contain"/>').data("editor",this).appendTo(e),e.on("change keyup","input,select,textarea",g.$detectChangeEvent),t.prototype.initialize.apply(this,[e])},g.prototype.read=function(){var n=this,i=n.value(),r=e.hasType(i)&&i.getType();return t.prototype.read.apply(n,arguments).then(function(e){return r&&r.is("baja:Simple")&&!r.is("baja:String")&&e.getType().is("baja:String")?c(e,r):e})},g.prototype.save=function(e){var t,n,i=this;return i.validate().then(function(r){if(t=r,n=r.getType&&r.getType(),d(t,i.value()))throw new Error("Component editors must support edit-by-ref semantics");return i.doSave(t,e)}).then(function(){var r=i.container,o=i.slot,a=e&&e.batch,l=e&&e.progressCallback;if(n&&!n.isComponent()&&r&&o){var u=r.set({slot:o,value:t,batch:a});return l&&l(p),u}return t}).then(function(){i.trigger(o.SAVE_EVENT),i.setModified(!1),i.$value=t})},g.prototype.doSave=function(t,n){var r=[],o=this.value();if(o.getType().isSimple())return t;if(t instanceof e.Component&&!t.editedSlots)throw new Error("provided raw instance of Component (type "+t.getType()+") to defaultDoSave - does your field editor use niagara.fieldEditors.toSaveDataComponent()?");var a=new e.comm.Batch;return e.iterate(t.editedSlots||t,function(e,t){r.push(o.set({slot:t,value:e.newCopy(!0),batch:a}))}),a.commit(),i.all(r).then(function(){return o})},g.prototype.makeChildFor=function(e){var t=this,n=t.$kids;return e.element=e.element||t.jq(),void 0===e.readonly&&(e.readonly=!t.isEnabled()),h().then(function(t){return t.makeFor(e)}).then(function(e){return n.push(e),e.parent=t,e})},g}),define("mobile/fieldeditors/fieldeditors.composite",["baja!","jquery","Promise","underscore","mobile/util/slot","mobile/fieldeditors/BaseFieldEditor","mobile/fieldeditors/fieldeditors"],function(e,t,n,i,r,o,a){"use strict";function l(e){var t={};return e.getSlots().properties().each(function(e){r.isEditable(e)&&(t[String(e)]="default")}),t}function u(i){return function(r,o){var u=this,s=u.value(),c=[],d=[];return e.iterate(i||l(s),function(e,n){var i=t('<div class="subEditor"/>').appendTo(r),l=s.getSlot(n),f=s.getDisplayName(l);c.push(u.makeChildFor({key:e.key,value:e.defaultValue||s.get(n),slot:l,container:s,facets:u.facets,autoInitialize:!1}).then(function(e){var t=a.toLabeledEditorContainer(f,i);return u.subEditorMap[l]=e,d.push(e.initialize(t,o)),e}))}),n.all(c).then(function(){return n.all(d)})}}function s(t){return function(i,r){var o=this,a=[],u=o.subEditorMap;return null===i||void 0===i?n.resolve(i):(e.iterate(t||l(i),function(e,t){var n=u[t],o=e.defaultValue||i.get(t);a.push(n.load(o,r))}),n.all(a))}}function c(t){return function(){var i=this.subEditorMap,r=[],o=this.value(),u=a.toSaveDataComponent(o);return e.iterate(t||l(o),function(e,t){var n=i[t];r.push(n.read().then(function(e){return u.set({slot:t,value:e})}))}),n.all(r).then(function(){return u})}}function d(t){return function(n){var i=this.subEditorMap,r=this.value();e.iterate(t||l(r),function(e,t){i[t].setEnabled(n)})}}function f(t){return function(){var i=[],r=this.subEditorMap,o=this.value();return e.iterate(t||l(o),function(e,t){var n=r[t];i.push(n.validate())}),n.all(i)}}var p={};return p.makeComposite=function(t,n,i){t=t||[],e.strictArg(t,Array);var r;return t.length&&(r={},e.iterate(t,function(e){"string"==typeof e?r[e]={key:"default"}:r[e.slot]={key:e.key||"default",defaultValue:e.defaultValue}})),a.defineEditor(n||o,{doInitialize:u(r),doLoad:s(r),doRead:c(r),doEnabled:d(r),validate:f(r),postCreate:function(){this.subEditorMap={},i&&i.validate&&this.validators().add(i.validate)}})},p.allSlots=function(){var e=p.makeComposite(),t=e.prototype.doInitialize;return e.prototype.doInitialize=function(e){e.addClass("allSlots"),t.call(this,e)},e},p}),define("mobile/fieldeditors/fieldeditors.dialogs",["baja!","lex!mobile","jquery","Promise","mobile/fieldeditors/fieldeditors","mobile/fieldeditors/fieldeditors.composite","bajaux/commands/Command","mobile/util/mobile/dialogs","mobile/util/mobile/commands","mobile/util/slot"],function(e,t,n,i,r,o,a,l,u,s){"use strict";function c(t){function n(n){return new i(function(i,u){l.okCancel({title:t.title||String(a.getType()),content:function(e){return t.element=e,r.makeFor(n,t).then(function(e){o=e})},ok:function(t){var n=new e.comm.Batch;o.save({batch:n}).then(function(){return o.read()}).then(function(e){i(e),t.ok()},function(e){u(e),t.fail(e)}),n.commit()},cancel:function(e){i(null),e.ok()}})})}var o,a=t.value;return r.isRegistered(a.getType()).then(function(e){return n(e?null:p)})}function d(t){function r(){return e.clock.schedule(function(){e.station.sync()},500),g.invoke({slot:a,value:f})}function o(){return d?g.getActionParameterDefault({slot:a}).then(function(e){return f=e,t&&!t.facets&&(t.facets=s.getFacets(g)),c(n.extend(t,{title:g.getDisplayName(a),value:f})).then(function(e){return null!==e?(f=e,r()):null})}):r()}t=e.objectify(t);var a,u,d,f=null,p=t.slot,h=e.def(t.parameter,""),g=t.component;if(e.strictArg(g,e.Component),a=g.getSlot(p),!a.isAction())throw new Error("slot '"+p+"' is not an action");if(u=a.getParamType(),h.equals("")||null===u||(h.getType().is(u)?f=h:"string"==typeof h&&u.isSimple()&&(f=u.getInstance().decodeFromString(h))),d=null===f&&null!==u,(g.getFlags(a)&e.Flags.CONFIRM_REQUIRED)===e.Flags.CONFIRM_REQUIRED)return new i(function(e,t){l.yesNo({content:m.get({key:"invoke.confirm",args:[g.getDisplayName(a)]}),yes:function(){o().then(e,t)},no:function(){e(null)}})});var v=o();return d||l.closeCurrent(),v}function f(e){var t=[];e.getSlots(function(e){return s.isFireable(e)}).each(function(n){t.push(new a(e.getDisplayName(n),function(){return d({component:e,slot:n,facets:e.get("facets")||{}})}))}),u.showCommandsDialog(t,m.get("actions"))}var p=o.allSlots(),m=t[0];return{action:d,fieldEditor:c,showAvailableActions:f}}),define("mobile/util/mobile/views/MobileView",["baja!","jquery","Promise","bajaux/Widget"],function(e,t,n,i){"use strict";var r=function(){i.apply(this,arguments)};return r.prototype=Object.create(i.prototype),r.prototype.constructor=r,r.prototype.doInitialize=function(e){return n.resolve(i.prototype.doInitialize.call(this,e)).then(function(){e.enhanceWithin()})},r}),define("mobile/util/mobile/views/ListView",["baja!","jquery","jquerymobile","Promise","underscore","mobile/util/slot","mobile/util/ord","mobile/util/mobile/mobile","mobile/util/mobile/views/MobileView","bajaux/icon/iconUtils","bajaux/mixin/subscriberMixIn"],function(e,t,n,i,r,o,a,l,u,s,c){"use strict";function d(e){return e.getType().isComplex()}var f=l.encodePageId,p=l.decodePageId,m=l.getActivePage,h=s.toHtml,g=function(){u.apply(this,arguments),c(this)};return g.prototype=Object.create(u.prototype),g.prototype.constructor=g,g.prototype.shouldIncludeSlot=function(e){return e.isProperty()&&!e.isAction()&&!e.isTopic()},g.prototype.doInitialize=function(n){var i=this;return u.prototype.doInitialize.call(this,n).then(function(){n.on("click","a.expandable",function(){var n=t(this).children("span.slotName").text();return i.doExpand(n).catch(e.error),!1}),n.on("click","a.link",function(e){var n=t(this),r=n.parents("li.property").attr("id");i.linkClicked(p(r),n)})})},g.prototype.doLoad=function(t){var n=this;e.strictArg(t,e.Complex);var i=this.$highlightedSlot;return this.makeListView(t).then(function(e){n.$ul=e,n.jq().empty().append(e).enhanceWithin(),i&&n.highlight(i)})},g.prototype.scrollExpandedDivIntoView=function(e){var i=m(),r=e.offset().top+e.height(),o=i.children(":jqmData(role=header)").height(),a=i.children(":jqmData(role=footer)").height(),l=t(window),u=l.scrollTop(),s=u+l.height()-a;if(r>s){var c=e.prev().offset().top-o;n.silentScroll(Math.min(c,u+(r-s)))}},g.prototype.doExpand=function(e){var n=this,r=function(e){return"ui-icon-carat-"+e},o=this.value().getSlot(e),a=f(o.getName()),l=this.$ul.children("li#"+a),u=l.children(".expandable").removeClass("udrl".split("").map(r).join(" ")),s=l.next(".expanded");return new i(function(e){var i=function(t){u.addClass(r(t)),n.scrollExpandedDivIntoView(s),e()};s.length?s.is(":visible")?s.hide("fast",function(){return i("d")}):s.show("fast",function(){return i("u")}):(s=t('<div class="expanded"/>').insertAfter(l).hide(),n.populateExpandedDiv(o,s),s.show("fast",function(){return i("u")}))})},g.prototype.highlight=function(e){this.removeHighlight();var t=this.$ul,n=f(e);this.$highlightedSlot=e,t.children("li#"+n).addClass("ui-btn-active")},g.prototype.removeHighlight=function(){delete this.$highlightedSlot,this.$ul.children().removeClass("ui-btn-active")},g.prototype.linkClicked=function(e,t){this.highlight(e)},g.prototype.populateExpandedDiv=function(e,t){},g.prototype.makeListView=function(e){var n=this,a=e.getSlots(function(e){return n.shouldIncludeSlot(e)&&!o.isHidden(e)}).toArray(),l=r.map(a,function(t){return n.makeListItem(e,t)});return i.all(l).then(function(e){return t('<ul data-role="listview" data-theme="c" />').html(e)})},g.prototype.prependIcons=function(e,t){return t?h(t).then(function(t){return e.find(".bajaImage").html(t)}):i.resolve()},g.prototype.makeListItem=function(e,n){var i=this,r=t('<li class="property" data-icon="carat-r"/>').attr("id",f(String(n))).append('<span class="bajaImage"></span>');return this.makeListItemParams(e,n).then(function(e){return i.prependIcons(r,e.icon).then(function(){if(t('<label class="title" />').text(e.title||"").appendTo(r),t('<span class="hidden slotName" />').text(String(n)).appendTo(r),t('<div class="display" />').text(e.display||"").appendTo(r),e.linkable||e.expandable){var i=t("<a />");i.jqmData("ord",e.ord),e.expandable?(i.addClass("expandable"),r.attr("data-icon","carat-d")):i.addClass("link"),r.wrapInner(i)}return r})})},g.prototype.makeListItemParams=function(t,n){var r=t.get(n),l=a.deriveOrd(r);return n.getType().is("baja:VirtualGateway")&&(l+="|virtual:/"),i.resolve({ord:l,title:t.getDisplayName(n),display:e.SlotPath.unescape(t.getDisplay(n)),icon:r.getIcon(),expandable:o.isEditable(n),linkable:d(n)&&!o.isReadonly(n)})},g.prototype.updateDisplay=function(e){if(!this.$ul)return i.resolve();var t=f(String(e)),n=this.$ul.find("li.property#"+t),r=n.find("div.display"),o=this.value(),a=o.get(e);return r.length&&r.text(o.getDisplay(e)),i.resolve(a&&a.getType().isComponent()&&this.prependIcons(n,a.getIcon()))},g.prototype.getSubscriber=function(){var t=this,n=this.$subscriber;return n||(n=this.$subscriber=new e.Subscriber,n.attach("changed",function(e){return t.updateDisplay(e)}),n.attach("renamed",function(e,n){var i=f(e.getName()),r=f(n),o=t.$ul.children("li.property#"+r),l=t.value(),u=a.deriveOrd(l.get(e));o.find("label.title").addClass("renamed").text(l.getDisplayName(e)),o.find("span.slotName").text(e.getName()),o.find("a.link").jqmData("ord",u),o.attr("id",i)}),n.attach("removed",function(e){var n=f(e.getName()),i=t.$ul.children("li.property#"+n);i.find("a").removeClass("link expandable"),i.find("label.title").addClass("removed").append(" (removed)")}),n.attach("added",function(n){var i=t.value();t.makeListItem(i,n).then(function(e){return t.$ul.append(e).listview("refresh")}).catch(e.error)}),n)},g}),define("mobile/util/color",["jquery"],function(e){"use strict";function t(e,t){return Math.max(0,Math.min(e,t))}function n(e){var t=Math.round(e).toString(16);return 1===t.length?"0"+t:t}function i(e,t,n,i){return e=Math.round(e),t=Math.round(t),n=Math.round(n),"number"==typeof i?"rgba("+e+","+t+","+n+","+i+")":"rgb("+e+","+t+","+n+")"}function r(e){return parseInt(e,16)}function o(e){if("%"===e.charAt(e.length-1)){var t=parseInt(e.substring(0,e.length-1),10);return Math.round(2.55*t)}return parseInt(e,10)}function a(e,t,n){return.2126*e+.7152*t+.0722*n}function l(e,n,i){e=t(e,255)/255,n=t(n,255)/255,i=t(i,255)/255;var r,o=Math.max(e,n,i),a=Math.min(e,n,i),l=o,u=o-a,s=0===o?0:u/o;if(o===a)r=0;else{switch(o){case e:r=(n-i)/u+(n<i?6:0);break;case n:r=(i-e)/u+2;break;case i:r=(e-n)/u+4}r/=6}return[r,s,l]}function u(e,t,i){return"#"+n(e)+n(t)+n(i)}function s(e,t,n,r,o){var a=l(e,t,n),s=this;"number"!=typeof r&&(r=255),s.red=e,s.green=t,s.blue=n,s.alpha=r,s.css="string"==typeof o?o:i(e,t,n,r/255),s.hexString=u(e,t,n),s.h=a[0],s.s=a[1],s.v=a[2]}function c(e,n,i){e=t(e,1),n=t(n,1),i=t(i,1);var r,o,a,l=Math.floor(6*e),u=6*e-l,c=i*(1-n),d=i*(1-u*n),f=i*(1-(1-u)*n);switch(l%6){case 0:r=i,o=f,a=c;break;case 1:r=d,o=i,a=c;break;case 2:r=c,o=i,a=f;break;case 3:r=c,o=d,a=i;break;case 4:r=f,o=c,a=i;break;case 5:r=i,o=c,a=d}return new s(255*r,255*o,255*a)}function d(n){if(n instanceof s)return n;var i,a,l,u,c,d,f,y=v[n],w=0,j=0,k=0,S=255;if(e.isArray(n))return w=t(n[0],255),j=t(n[1],255),k=t(n[2],255),"number"==typeof n[3]?(S=t(n[3],255),new s(w,j,k,S)):new s(w,j,k);if("string"!=typeof n)throw new Error("invalid input to parseRgba: "+n);if(b[n])return b[n];if("string"==typeof y&&(n=y),i=p.exec(n),i&&(a=i[1],l=i[2],u=i[3],c=i[4],c?(S=r(a)/255,w=r(l),j=r(u),k=r(c),d="rgba("+w+","+j+","+k+","+S+")"):(w=r(a),j=r(l),k=r(u),d=n)),i||(i=m.exec(n))&&(a=i[1],l=i[2],u=i[3],w=r(a+a),j=r(l+l),k=r(u+u),d=n),i||(i=h.exec(n))&&(w=o(i[1]),j=o(i[2]),k=o(i[3]),d="rgb("+w+","+j+","+k+")"),i||(i=g.exec(n))&&(w=o(i[1]),j=o(i[2]),k=o(i[3]),S=255*parseFloat(i[4]),d="rgba("+w+","+j+","+k+","+S/255+")"),!i)throw new Error("could not parse string: "+n);return b[n]=f=new s(w,j,k,S,d),f}function f(e,t){var n=e.red,i=e.green,r=e.blue,o=e.alpha/255,a=t.red,l=t.green,u=t.blue;return n=Math.round(o*(n-a)+a),i=Math.round(o*(i-l)+l),r=Math.round(o*(r-u)+u),new s(n,i,r)}var p=/^\#([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})?$/,m=/^\#([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])$/,h=/^rgb\([\s]*?([0-9]+[%]?)[\s]*?,[\s]*?([0-9]+[%]?)[\s]*?,[\s]*?([0-9]+[%]?)[\s]*?\)$/,g=/^rgba\([\s]*?([0-9]+[%]?)[\s]*?,[\s]*?([0-9]+[%]?)[\s]*?,[\s]*?([0-9]+[%]?)[\s]*?,[\s]*?([0-9\.]+)[\s]*?\)$/,v={transparent:"rgba(0, 0, 0, 0)",aliceBlue:"#f0f8ff",antiqueWhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedAlmond:"#ffebcd",blue:"#0000ff",blueViolet:"#8a2be2",brown:"#a52a2a",burlyWood:"#deb887",cadetBlue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerBlue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkBlue:"#00008b",darkCyan:"#008b8b",darkGoldenrod:"#b8860b",darkGray:"#a9a9a9",darkGreen:"#006400",darkGrey:"#a9a9a9",darkKhaki:"#bdb76b",darkMagenta:"#8b008b",darkOliveGreen:"#556b2f",darkOrange:"#ff8c00",darkOrchid:"#9932cc",darkRed:"#8b0000",darkSalmon:"#e9967a",darkSeaGreen:"#8fbc8f",darkSlateBlue:"#483d8b",darkSlateGray:"#2f4f4f",darkSlateGrey:"#2f4f4f",darkTurquoise:"#00ced1",darkViolet:"#9400d3",deepPink:"#ff1493",deepSkyBlue:"#00bfff",dimGray:"#696969",dimGrey:"#696969",dodgerBlue:"#1e90ff",firebrick:"#b22222",floralWhite:"#fffaf0",forestGreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostWhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenYellow:"#adff2f",grey:"#808080",honeydew:"#f0fff0",hotPink:"#ff69b4",indianRed:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderBlush:"#fff0f5",lawnGreen:"#7cfc00",lemonChiffon:"#fffacd",lightBlue:"#add8e6",lightCoral:"#f08080",lightCyan:"#e0ffff",lightGoldenrodYellow:"#fafad2",lightGray:"#d3d3d3",lightGreen:"#90ee90",lightGrey:"#d3d3d3",lightPink:"#ffb6c1",lightSalmon:"#ffa07a",lightSeaGreen:"#20b2aa",lightSkyBlue:"#87cefa",lightSlateGray:"#778899",
lightSlateGrey:"#778899",lightSteelBlue:"#b0c4de",lightYellow:"#ffffe0",lime:"#00ff00",limeGreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumAquamarine:"#66cdaa",mediumBlue:"#0000cd",mediumOrchid:"#ba55d3",mediumPurple:"#9370db",mediumSeaGreen:"#3cb371",mediumSlateBlue:"#7b68ee",mediumSpringGreen:"#00fa9a",mediumTurquoise:"#48d1cc",mediumVioletRed:"#c71585",midnightBlue:"#191970",mintCream:"#f5fffa",mistyRose:"#ffe4e1",moccasin:"#ffe4b5",navajoWhite:"#ffdead",navy:"#000080",oldLace:"#fdf5e6",olive:"#808000",oliveDrab:"#6b8e23",orange:"#ffa500",orangeRed:"#ff4500",orchid:"#da70d6",paleGoldenrod:"#eee8aa",paleGreen:"#98fb98",paleTurquoise:"#afeeee",paleVioletRed:"#db7093",papayaWhip:"#ffefd5",peachPuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderBlue:"#b0e0e6",purple:"#800080",red:"#ff0000",rosyBrown:"#bc8f8f",royalBlue:"#4169e1",saddleBrown:"#8b4513",salmon:"#fa8072",sandyBrown:"#f4a460",seaGreen:"#2e8b57",seaShell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyBlue:"#87ceeb",slateBlue:"#6a5acd",slateGray:"#708090",slateGrey:"#708090",snow:"#fffafa",springGreen:"#00ff7f",steelBlue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whiteSmoke:"#f5f5f5",yellow:"#ffff00",yellowGreen:"#9acd32"},b={};return{COLOR_CONSTANTS:v,Color:s,alphaBlend:f,hsvToRgb:c,luma:a,parseRgba:d,rgbToHsv:l,toHexCssString:u,toRgbCssString:i}}),define("mobile/util/gradient",["mobile/util/color"],function(e){"use strict";function t(e){var t=e*Math.PI/180,n=Math.cos(t),i=Math.sin(t),r=1/Math.max(Math.abs(i),Math.abs(n)),o=n*r,a=-i*r,l=-o,u=-a;return l=Math.round(50*(l+1)),u=Math.round(50*(u+1)),o=Math.round(50*(o+1)),a=Math.round(50*(a+1)),l+"% "+u+"%, "+o+"% "+a+"%"}function n(e,n){var i,r,o,a=t(e);for(r="(linear, "+a,o=0;o<n.length;++o)i=n[o],r+=", color-stop("+i[0]+", "+i[1].css+")";return r+=")"}function i(e,t){var n,i,r=t.length,o=0;for(n="("+e+"deg, ";o<r;)i=t[o],n+=i[1].css+" "+i[0],++o<r&&(n+=", ");return n+=")"}function r(e,t,n){return u.patternReplace({gradientType:e?"0":"1",startColor:t.hexString,endColor:n.hexString})}function o(e){var t,n,i=[];for(n=0;n<e.length;n++)t=e[n],i[n]=[t[0],a(t[1])];return i}var a=e.parseRgba,l=["-webkit-","-moz-","-ms-","-o-"],u="progid:DXImageTransform.Microsoft.gradient(GradientType={gradientType},startColorstr='{startColor}', endColorstr='{endColor}')",s={};return s.createLinearGradientCss=function(e,t){if(!t||!t.length)return null;t=o(t);var a={},l=t[0],u=l[1],s=t[t.length-1],c=s[1];return a.background=u.hexString,a.filter=r(e,u,c),a.webkitGradient=n(e,t),a.linearGradientNonStandard=i(e,t),a.linearGradient=i(90-e,t),a},s.applyLinearGradientBackground=function(e,t,n){var i,r=s.createLinearGradientCss(t,n);if(null!==r){for(e.css("background",r.background),e.css("filter",r.filter),e.css("background","-webkit-gradient"+r.webkitGradient),i=0;i<l.length;i++)e.css("background",l[i]+"linear-gradient"+r.linearGradientNonStandard);e.css("background","linear-gradient"+r.linearGradient)}},s}),define("mobile/propsheet/statusgradients",["mobile/util/color","mobile/util/gradient"],function(e,t){"use strict";function n(e){if(e){var t=niagara.view.status;return e.isDisabled()?t.disabled:e.isFault()?t.fault:e.isDown()?t.down:e.isAlarm()?t.alarm:e.isStale()?t.stale:e.isOverridden()?t.overridden:void 0}}function i(e,n){var i,r=l,o=[],a=t.createLinearGradientCss(270,n);for(o.push("-webkit-gradient"+a.webkitGradient),i=0;i<r.length;i++)o.push(r[i]+"-linear-gradient"+a.linearGradientNonStandard);return o.push("linear-gradient",a.linearGradient),e.css.background=a.background,e.css.filter=a.filter,e.bkImg=o,e}function r(t,r){var l,s,c=n(r);if(t.toggle(!!c),c){if(!(l=a[c])){l=a[c]={css:{},bkImg:[]};var d=e.parseRgba(c),f=d.h,p=d.s,m=d.v,h=o(f,.5*p,Math.max(m,.85)),g=o(f,1.1*p,m),v=o(f,1.2*p,.7*m),b=o(f,.7*p,.55*m),y=[["0%",h],["10%",g],["90%",v],["100%",b]],w="1px solid "+b.css,j=u;for(l.css["background-color"]=c,l.css.border=w,s=0;s<j.length;s++)l.css[j[s]+"box-shadow"]="0 0 2x "+b.css;l=i(l,y)}for(t.css(l.css),s=0;s<l.bkImg.length;++s)t.css("background-image",l.bkImg[s])}}var o=e.hsvToRgb,a={},l=["-webkit","-moz","-ms","-o"],u=["-webkit-","-moz-",""];return{applyStatusCSS:r}}),define("mobile/propsheet/PropertySheetListView",["baja!","lex!mobile","jquery","jquerymobile","Promise","underscore","mobile/util/slot","mobile/util/mobile/dialogs","mobile/util/mobile/mobile","mobile/util/mobile/views/ListView","mobile/fieldeditors/fieldeditors","mobile/fieldeditors/BaseFieldEditor","mobile/propsheet/statusgradients","bajaux/commands/Command","bajaux/events"],function(e,t,n,i,r,o,a,l,u,s,c,d,f,p,m){"use strict";function h(t){return e.strictArg(t,Object),t.facets=t.facets||{},c.makeFor(t)}function g(){var e,t,n=new r(function(n,i){e=n,t=i});return{resolve:e,reject:t,promise:n}}function v(t){if(t instanceof e.Complex)return t.getDisplayName()||t.getName()}function b(e,t){f.applyStatusCSS(e,t)}var y,w=u.encodePageId,j=t[0],k=m.MODIFY_EVENT;return y=e.subclass(function t(){var n=this,i=new p({displayName:"%lexicon(mobile:save)%",enabled:!1,func:function(){return n.save()}}),r=new p({displayName:"%lexicon(mobile:refresh)%",func:function(){return n.refresh()}});e.callSuper(t,n,arguments),n.fieldEditorMap={},n.$saveCommand=i,n.$refreshCommand=r,n.getCommandGroup().add(i,r)},s),y.prototype.doInitialize=function(e){var t=this;return s.prototype.doInitialize.call(this,e).then(function(){e.on(k,function(e,n){n instanceof d&&t.setModified(!0)})})},y.prototype.doLoad=function(){var t=this;return s.prototype.doLoad.apply(this,arguments).then(function(){var n=new e.comm.Batch,i=t.doSubscribing(n);return n.commit(),i})},y.prototype.doDestroy=function(){var t=this;return r.resolve(s.prototype.doDestroy.apply(t,arguments)).then(function(){var n=new e.comm.Batch,i=t.doUnsubscribing(n);return n.commit(),i})},y.prototype.setModified=function(t){e.callSuper("setModified",y,this,arguments),this.$saveCommand.setEnabled(t)},y.prototype.toDisplayName=function(){var e=this.value(),t=v(e);return r.resolve(t||j.get("propsheet.station"))},y.prototype.loadEditorParams=function(t){e.strictArg(t,Object),e.strictArg(t.container,e.Complex),e.strictArg(t.slot,e.Slot),e.strictArg(t.element,n);var i=this,r=u.spinnerTicket(1e3);return h(t).then(function(e){i.fieldEditorMap[t.slot]=e}).finally(function(){r.hide()})},y.prototype.populateExpandedDiv=function(t,n){var i=this.jq().children("ul"),r=w(t);return this.loadEditorParams({container:this.value(),slot:t,element:n}).then(function(){n.on(k,function(e,t){i.children("li#"+r).find("div.display").addClass("dirty")})},e.error)},y.prototype.save=function(){var t=this,n=new e.comm.Batch,i=u.spinnerTicket(1e3),a=o.filter(t.fieldEditorMap,function(e){return e.isModified()}),l=o.map(a,function(e){return e.validate()});return r.all(l).then(function(){var e=o.map(a,function(e){return e.save({batch:n})});return setTimeout(function(){n.commit()},150),r.all(e)}).then(function(){t.jq().find("div.display.dirty").removeClass("dirty").addClass("editable"),t.setModified(!1)}).finally(i.hide())},y.prototype.refresh=function(){var e=this;return e.isModified()?e.toDisplayName().then(function(t){var n=g();return l.confirmAbandonChanges({yes:function(t){e.save().then(function(){return e.load(e.value())}).then(function(){n.resolve(),t.ok()},function(e){n.reject(e),t.fail(e)})},no:function(t){e.setModified(!1),e.load(e.value()).then(function(){n.resolve(),t.ok()},function(e){n.reject(e),t.fail(e)})},viewName:t}),n.promise}):e.load(e.value())},y.prototype.doSubscribing=function(t){var n=this.childrenSubscriber,i=this,r=i.value(),o=[];if(r.getType().isComponent())return n||(n=new e.Subscriber,n.attach("changed",function(e,t){i.updateDisplay(this.getPropertyInParent())}),this.childrenSubscriber=n),r.getSlots(function(e){if(!e.isProperty())return!1;var t=e.getType();return t.isComponent()&&(t.is("baja:IStatus")||t.is("baja:VirtualComponent"))}).each(function(e){this.get(e).isSubscribed()||o.push(this.get(e))}),n.subscribe({comps:o,batch:t})},y.prototype.doUnsubscribing=function(e){var t=this.childrenSubscriber,n=this.value();if(t&&n.getType().isComponent())return t.unsubscribeAll({batch:e})},y.prototype.makeListItem=function(t,i){return e.callSuper("makeListItem",y,this,arguments).then(function(r){var o,l=n('<div class="statusBg"></div>').prependTo(r);return a.isEditable(i)&&r.find("div.display").addClass("editable"),i.getType().is("baja:IStatus")&&(o=e.Status.getStatusFromIStatus(t.get(i)),b(l,o)),r})},y.prototype.updateDisplay=function(t){e.callSuper("updateDisplay",y,this,arguments);var n,i;t.getType().is("baja:IStatus")&&(n=this.jq().find("li.property#"+w(t)),i=e.Status.getStatusFromIStatus(this.value().get(t)),b(n.find("div.statusBg"),i))},y.prototype.makeListItemParams=function(t,n){return e.callSuper("makeListItemParams",y,this,arguments).then(function(e){return e.expandable?c.isRegistered(n).then(function(t){return t||(e.expandable=!1),e}):e})},y}),define("mobile/propsheet/PropertySheet",["lex!mobile","baja!","jquery","jquerymobile","Promise","mobile/fieldeditors/fieldeditors.dialogs","mobile/util/slot","mobile/util/mobile/mobile","mobile/util/mobile/commands","mobile/util/mobile/dialogs","mobile/util/mobile/views/PageView","mobile/propsheet/PropertySheetListView","bajaux/events"],function(e,t,n,i,r,o,a,l,u,s,c,d,f){"use strict";function p(e){s.ok({content:e,title:v.get({key:"propsheet.validationError",def:"Validation Error"})})}var m,h,g,v=e[0],b=l.escapeHtml,y=f.LOAD_EVENT,w=f.MODIFY_EVENT,j=f.UNMODIFY_EVENT;return m='<div data-role="footer" data-position="fixed" data-theme="b" data-tap-toggle="false">\n<div data-role="navbar"><ul>\n<li><a data-icon="check" class="saveLink">{save}</a></li>\n<li><a data-icon="refresh" class="refreshLink">{refresh}</a></li>\n<li><a data-icon="gear" class="actionsLink">{actions}</a></li>\n</ul></div>\n</div>',h='<div data-role="navbar"><ul><li><a class="componentLink">{title}</a></li></ul></div>',g=t.subclass(function e(){t.callSuper(e,this,arguments)},c),g.prototype.instantiateContentView=function(){return new d},g.prototype.doInitialize=function(e){var t=this;return e.on([y,w,j].join(" "),function(){t.updateBars()}),e.on("click","a.saveLink",function(){var e=n(this);t.contentView.$saveCommand.invoke().then(function(){e.addClass("ui-disabled")}).catch(p)}),e.on("click","a.refreshLink",function(){t.contentView.$refreshCommand.invoke()}),e.on("click","a.actionsLink",function(){o.showAvailableActions(t.value())}),c.prototype.doInitialize.call(this,e)},g.prototype.createPage=function(){var e=c.prototype.createPage.call(this),t=e.children(":jqmData(role=header)"),i=n(h.patternReplace({title:v.getSafe("loading")})),r=n(m.patternReplace({save:b(v.get("save")),refresh:b(v.get("refresh")),actions:b(v.get("actions"))}));return e.append(r),l.preventNavbarHighlight(r),t.append(u.getCommandsButton().removeClass(this.$ignoreProfileClasses)),t.append(i),e},g.prototype.doDestroy=function(){this.getContentDiv().find("input:jqmData(role=datebox)").each(function(){var e=n(this).jqmData("datebox"),t=e&&e.pickPage;t&&t.remove()})},g.prototype.hasFireableActions=function(){return!!this.value().getSlots(function(e){return a.isFireable(e)}).next()},g.prototype.updateBars=function(){var e=this,t=e.value(),n=e.getHeaderDiv(),i=e.getFooterDiv(),r=i.find("a"),o=r.filter(".actionsLink"),a=n.find(".commandsButton"),l=r.filter(".saveLink");t.getType().isComponent()?a.show():a.hide(),o.toggleClass("ui-disabled",!this.hasFireableActions()),l.toggleClass("ui-disabled",!this.isModified()),a.toggleClass("red",this.isModified())},g}),define("mobile/propsheet/PropertySheetManager",["baja!","jquery","Promise","mobile/util/ord","mobile/util/aop","mobile/util/nav","mobile/util/mobile/nav","mobile/util/mobile/views/PageViewManager","mobile/propsheet/PropertySheet"],function(e,t,n,i,r,o,a,l,u){"use strict";function s(e){var t=e.contentView.getSubscriber();t.attach("reordered flagsChanged facetsChanged",function(t,n){e.contentView.refresh()}),t.attach("added removed changed",function(t){"displayNames"===t.getName()&&e.refresh()})}var c,d=o.ComponentSpaceNavModel;return c=e.subclass(function t(){e.callSuper(t,this,arguments);var n=this,r=new d;l.call(n,r),n.navbar=new a.NavBar(r),n.navbar.attach("click",function(e){var t=e.node,r=t.getNavChildren();i.equivalent(t.getNavOrd(),i.deriveOrd(n.$selectedView.value()))&&r.length?n.showNavChildren(t):n.linkToOrd(t.getNavOrd())})},l),c.prototype.instantiateView=function(e,t){return n.resolve(new u)},r.advisePrototype(c,{after:{attachSubscriberEvents:function(e,t){s(e[0])},setSelectedView:function(e,t){var n=e[0];this.navbar.refresh(n.getPage())}}}),c}),define("mobile/fieldeditors/MobileFieldEditor",["baja!","jquery","jquerymobile","mobile/fieldeditors/BaseFieldEditor"],function(e,t,n,i){"use strict";var r=e.subclass(function(e,t,n,r){i.call(this,e,t,n,r)},i);return r.prototype.refreshWidgets=function(){var e=this.jq(),t=e.find("select"),n=e.find("input"),i=t.filter(".ui-slider-switch"),r=t.filter(".ui-select select"),o=n.filter(".ui-checkbox input"),a=n.filter(".ui-input-datebox input");i.length&&i.slider("refresh"),r.length&&r.selectmenu("refresh"),o.length&&o.checkboxradio("refresh"),a.length&&a.datebox("refresh"),e.removeClass("ui-br")},r.prototype.doEnabled=function(e){var t=this,n=this.jq();n&&t.updateReadonlyStatus(n)},r.prototype.updateReadonlyStatus=function(e){var t=this.isEnabled(),n=e.find("select"),i=e.find("input"),r=t?"enable":"disable",o=e.find("textarea"),a=n.filter(":jqmData(role=slider)"),l=n.filter(":jqmData(role!=slider)"),u=i.filter('[type="checkbox"]'),s=i.filter(':jqmData(role="datebox")'),c=i.filter('[type="text"]');a.length&&a.slider(r),l.length&&l.selectmenu(r),u.length&&u.checkboxradio(r),s.length&&s.datebox(r),c.length&&c.textinput(r),o.length&&o.textinput(r)},r.prototype.initialize=function(e){var t=this;return i.prototype.initialize.call(this,e).then(function(){e.enhanceWithin(),t.updateReadonlyStatus(e)})},r.prototype.load=function(e){var t=this;return i.prototype.load.call(t,e).then(function(){t.refreshWidgets()})},r});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,o=void 0;try{for(var a,l=e[Symbol.iterator]();!(i=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);i=!0);}catch(e){r=!0,o=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw o}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/AbsTimeEditor",["baja!","bajaux/events","jquery","Promise","mobile/fieldeditors/MobileFieldEditor"],function(e,t,n,i,r){"use strict";var o=t.MODIFY_EVENT,a=function(){r.apply(this,arguments)};return a.prototype=Object.create(r.prototype),a.prototype.constructor=a,a.prototype.doLoad=function(e){var t=this,n=t.jq(),r=e.getDate(),a=e.getTime();return n.empty(),t.$offset=e.$offset||0,i.join(t.makeChildFor({value:r,element:n}),t.makeChildFor({value:a,element:n})).spread(function(e,n){function i(){return t.setModified(!0),!1}t.$dateEditor=e,t.$timeEditor=n,e.jq().on(o,i),n.jq().on(o,i)})},a.prototype.doRead=function(){var t=this.$offset;return i.all([this.$dateEditor.read(),this.$timeEditor.read()]).then(function(n){var i=_slicedToArray(n,2),r=i[0],o=i[1];return e.AbsTime.make({date:r,time:o,offset:t})})},a.prototype.doEnabled=function(e){var t=this;t.$dateEditor&&t.$dateEditor.doEnabled(e),t.$timeEditor&&t.$timeEditor.doEnabled(e)},a});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,o=void 0;try{for(var a,l=e[Symbol.iterator]();!(i=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);i=!0);}catch(e){r=!0,o=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw o}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/feUtils",["baja!","lex!mobile","jquery","Promise","mobile/util/slot","nmodule/js/rc/asyncUtils/asyncUtils"],function(e,t,n,i,r,o){"use strict";function a(e){var t,n,i="",r="",o=0;for(n=0;n<e.length;n++)switch(t=e.charAt(n)){case"Y":case"M":case"D":case"W":case"w":case"z":case"s":i="";break;case"h":case"H":case"m":case"a":i.length&&(r+=i,i=""),r+=t,o++;break;default:o>0&&(i+=t)}return r}function l(){var e,t,n,i=p.getBajaTimeFormat(),r=[],o="",a=[],l=12;for(e=0;e<i.length;e++)n=i.charAt(e),r.length>0&&r[r.length-1].ch===n?r[r.length-1].count++:r.push({ch:n,count:1});for(e=0;e<r.length;e++)switch(r[e].ch){case"Y":o+=r[e].count<=2?"%y":"%Y";break;case"M":switch(r[e].count){case 1:o+="%-m";break;case 2:o+="%m";break;case 3:o+="%b";break;case 4:default:o+="%B"}break;case"D":o+=1===r[e].count?"%-d":"%d";break;case"h":o+=1===r[e].count?"%-l":"%l",a.push("h"),l=12;break;case"H":o+=1===r[e].count?"%-k":"%k",a.push("h"),l=24;break;case"m":o+=1===r[e].count?"%-M":"%M",a.push("i");break;case"s":o+="ss";break;case"a":o+="%p",a.push("a");break;case"z":case"Z":break;case"W":o+=1===r[e].count?"%a":"%A";break;case"w":o+="%W";break;case"%":for(t=0;t<r[e].count;t++)o+="%%";break;default:for(t=0;t<r[e].count;t++)o+=r[e].ch}return{timeOutput:o,timeFieldOrder:a,timeFormat:l}}var u=o.doRequire,s=_slicedToArray(t,1),c=s[0],d=void 0,f=void 0,p={};return p.dateboxArmHandlers=function(e){e.find("input:jqmData(role=datebox)").on("keyup",function(){var e=n(this),t=e.val();e.trigger("datebox",{method:"set",value:t})})},p.getBajaTimeFormat=function(){return d||(d=e.getTimeFormatPattern()||"HH:mm",d=a(d),d.match(/a\S+/g)&&(d=d.replace("a","a "))),d},p.getDateboxDefaultOptions=function(){var e={centerHoriz:!0,centerVert:!0,daysOfWeek:c.get({key:"propsheet.datebox.daysOfWeek",def:"Sunday Monday Tuesday Wednesday Thursday Friday Saturday"}).split(" "),daysOfWeekShort:c.get({key:"propsheet.datebox.daysOfWeekShort",def:"Su Mo Tu We Th Fr Sa"}).split(" "),monthsOfYear:c.get({key:"propsheet.datebox.monthsOfYear",def:"January February March April May June July August September October November December"}).split(" "),monthsOfYearShort:c.get({key:"propsheet.datebox.monthsOfYearShort",def:"Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec"}).split(" "),setDateButtonLabel:c.get({key:"propsheet.datebox.setDateButtonLabel",def:"Set Date"})};return f=f||l(),e.overrideTimeOutput=f.timeOutput,e.overrideTimeFieldOrder=f.timeFieldOrder,e.overrideTimeFormat=f.timeFormat,e},p.getEnumRangeDisplay=function(t,n){return i.try(function(){var i=n.getOptions().get("lexicon"),r=n.get(t),o=r.getTag();return i?u(["lex!"+i]).spread(function(e){return e.get({key:o,def:o})}):e.SlotPath.unescape(r.toString())}).catch(function(){return String(t)})},p.getFacets=function(t){var n=t.facets,i=t.container;return n&&n!==e.Facets.NULL?n:i?r.getFacets(i,t.slot):e.Facets.DEFAULT},p.minMaxCheck=function(e,t,n,r){return new i(function(i,o){var a;void 0!==t&&null!==t&&r<t||void 0!==n&&null!==n&&r>n?(a='Cannot save property "'+e.slot+'". ',a+=r<t?r+" < "+t:r+" > "+n,a+=" ["+t+" - "+n+"]",o(new Error(a))):i()})},p});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,o=void 0;try{for(var a,l=e[Symbol.iterator]();!(i=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);i=!0);}catch(e){r=!0,o=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw o}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/BooleanEditor",["baja!","lex!baja","jquery","Promise","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/feUtils"],function(e,t,n,i,r,o){"use strict";function a(t){var n,r,o=t.facets;return o&&o.get("trueText")&&o.get("falseText")||(o=l(t)),o&&(n=o.get("trueText"),r=o.get("falseText")),n&&r||(n=s.get("true"),r=s.get("false")),i.join(e.Format.format({pattern:n}),e.Format.format({pattern:r}))}var l=o.getFacets,u=_slicedToArray(t,1),s=u[0],c=function(){r.apply(this,arguments)};return c.prototype=Object.create(r.prototype),c.prototype.constructor=c,c.prototype.doInitialize=function(e){var t=this;return a(t).spread(function(i,r){var o=t.name,a=n('<select data-role="slider" />').attr("name",o),l=n("<option/>").val("true").text(i),u=n("<option/>").val("false").text(r);a.append(u).append(l).appendTo(e)})},c.prototype.doLoad=function(e){this.jq().find("select").val(e?"true":"false")},c.prototype.doRead=function(){return"true"===this.jq().find("select").val()},c}),define("mobile/fieldeditors/mobile/BooleanCheckboxEditor",["baja!","jquery","mobile/fieldeditors/MobileFieldEditor","mobile/util/mobile/mobile"],function(e,t,n,i){"use strict";var r=i.encodePageId,o=function(){n.apply(this,arguments)};return o.prototype=Object.create(n.prototype),o.prototype.constructor=o,o.prototype.doInitialize=function(e){var n=this.label,i=r(n),o=t('<fieldset data-role="controlgroup"/>'),a=t("<label/>").attr("for",i).text(n),l=t('<input type="checkbox" data-theme="b"/>').attr("name",i).attr("id",i);o.append(l).append(a),e.append(o)},o.prototype.doLoad=function(e){this.jq().find("input").attr("checked",e).checkboxradio("refresh")},o.prototype.doRead=function(){return this.jq().find("input").is(":checked")},o}),define("mobile/fieldeditors/mobile/DateEditor",["baja!","jquery","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/feUtils"],function(e,t,n,i){"use strict";function r(t){var n=t.jq().find("input[name$=date]"),i=n.datebox("getTheDate");return e.Date.make({year:i.getFullYear(),month:i.getMonth(),day:i.getDate()})}function o(e){var n=t('<input type="date" data-role="datebox" name="'+e+'_date" />'),i=l();return i.mode="calbox",i.useDialogForceFalse=!0,i.calHighToday=!1,n.attr("data-options",JSON.stringify(i)),n}var a=i.dateboxArmHandlers,l=i.getDateboxDefaultOptions,u=function(){n.apply(this,arguments)};return u.prototype=Object.create(n.prototype),u.prototype.constructor=u,u.prototype.doInitialize=function(e){e.append(o(this.name)),a(e)},u.prototype.doLoad=function(e){var t=this.jq().find("input:jqmData(role=datebox)");return e.toDateString({textPattern:"YYYY-MM-DD"}).then(function(e){t.trigger("datebox",{method:"set",value:e})})},u.prototype.doRead=function(){return r(this)},u});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,o=void 0;try{for(var a,l=e[Symbol.iterator]();!(i=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);i=!0);}catch(e){r=!0,o=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw o}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/EnumEditor",["baja!","lex!mobile","jquery","Promise","underscore","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/feUtils"],function(e,t,n,i,r,o,a){"use strict";var l=a.getEnumRangeDisplay,u=_slicedToArray(t,1),s=u[0],c=function(){o.apply(this,arguments)};return c.prototype=Object.create(o.prototype),c.prototype.constructor=c,c.prototype.doInitialize=function(e){var t=n('<select data-theme="a" />').attr("name",this.name);n("<option/>").attr("value","n/a").val(s.get("loading")).appendTo(t),t.appendTo(e)},c.prototype.doLoad=function(t){var o=this.jq().find("select").empty(),a=this.facets.get("range")||t.getRange(),u=a.getOrdinals();this.range=a;var s=r.map(u,function(e){return l(e,a)});return i.all(s).then(function(i){var a=r.map(i,function(t,i){return n("<option/>").val(u[i]).text(e.SlotPath.unescape(t))});o.html(a),o.val(String(t.getOrdinal())).selectmenu("refresh")})},c}),define("mobile/fieldeditors/mobile/DynamicEnumEditor",["baja!","mobile/fieldeditors/mobile/EnumEditor"],function(e,t){"use strict";var n=function(){t.apply(this,arguments)};return n.prototype=Object.create(t.prototype),n.prototype.constructor=n,n.prototype.doRead=function(){var t=this.jq().find("select"),n=this.range;return e.DynamicEnum.make({ordinal:Number(t.val()),range:n})},n}),define("mobile/fieldeditors/mobile/FacetsEditor",["baja!","jquery","Promise","mobile/fieldeditors/MobileFieldEditor","mobile/util/mobile/dialogs"],function(e,t,n,i,r){"use strict";function o(e,t,n){var i=e.jq(),r=e.facetValues[n];void 0!==r&&e.makeChildFor({value:r,element:t.empty()}).then(function(t){delete e.currentEditor,delete e.currentKey,i.trigger("create"),i.trigger("updatelayout"),e.currentEditor=t,e.currentKey=n})}function a(e,t){return t&&t.isModified()?t.read().then(function(t){e.facetValues[e.currentKey]=t}):n.resolve()}var l=function(){i.apply(this,arguments),this.currentEditor=null,this.currentKey=null};return l.prototype=Object.create(i.prototype),l.prototype.constructor=l,l.prototype.doInitialize=function(e){var n=this,i=t('<select data-role="selectmenu" data-theme="a"><option value="-1">loading</option></select>'),l=t('<div class="subEditor"/>');i.appendTo(e),l.appendTo(e),e.undelegate(),i.on("change",function(){var e=t(this).val();a(n,n.currentEditor).then(function(){o(n,l,e),n.$lastKey=e},function(e){r.error(e),i.val(n.$lastKey)})})},l.prototype.doLoad=function(n){var i=this,r=i.jq().find("select"),o=i.facetValues={},a=n,l=null;r.empty(),e.iterate(a.getKeys(),function(e){var n=t("<option/>").attr("value",e).text(e);r.append(n),o[e]=a.get(e),l=l||e}),r.val(l).trigger("change"),i.$lastKey=l},l.prototype.doRead=function(){var t=this;return a(t,t.currentEditor).then(function(){var n=[],i=[];return e.iterate(t.facetValues,function(e,t){n.push(t),i.push(e)}),e.Facets.make(n,i)})},l}),define("mobile/fieldeditors/mobile/FrozenEnumEditor",["mobile/fieldeditors/mobile/EnumEditor"],function(e){"use strict";var t=function(){e.apply(this,arguments)};return t.prototype=Object.create(e.prototype),t.prototype.constructor=t,t.prototype.doRead=function(){var e=this.jq().find("select");return this.value().get(Number(e.val()))},t});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,o=void 0;try{for(var a,l=e[Symbol.iterator]();!(i=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);i=!0);}catch(e){r=!0,o=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw o}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/NonEditableEditor",["lex!mobile","jquery","mobile/fieldeditors/MobileFieldEditor"],function(e,t,n){"use strict";var i=_slicedToArray(e,1),r=i[0],o=function(){n.apply(this,arguments)};return o.prototype=Object.create(n.prototype),o.prototype.constructor=o,o.prototype.doInitialize=function(e){e.append('<span class="nonEditable" />')},o.prototype.doLoad=function(e){var t=this.jq().find("span"),n=r.get({key:"propsheet.message.nonEditable",def:"Not Editable In Mobile Property Sheet"});t.text(e.getType()+" "+n)},o}),define("mobile/fieldeditors/mobile/StringEditor",["baja!","jquery","Promise","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/feUtils"],function(e,t,n,i,r){"use strict";var o=r.getFacets,a=r.minMaxCheck,l=function(){var e=this;i.apply(this,arguments),this.validators().add(function(t){var n=o(e);if(n)return a(e,n.get("min"),n.get("max"),t.length)})};return l.prototype=Object.create(i.prototype),l.prototype.constructor=l,l.prototype.doInitialize=function(e){var n,i,r=o(this);r&&r.get("multiLine")?(i=r.get("fieldWidth"),n=t('<textarea cols="40" rows="10"></textarea>'),i&&n.attr("cols",i)):n=t('<input type="text"/>'),n.attr("name",this.name).appendTo(e).textinput()},l.prototype.doLoad=function(t){if(null!==t&&void 0!==t){var n;"function"==typeof t.encodeToString?n=t.encodeToString():(n=JSON.stringify(e.bson.encodeValue(t)),this.setEnabled(!1)),this.jq().find("input,textarea").val(n)}},l.prototype.doRead=function(){return this.jq().find("input,textarea").val()},l}),define("mobile/fieldeditors/mobile/NumericEditor",["baja!","jquery","Promise","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/StringEditor","mobile/fieldeditors/mobile/feUtils"],function(e,t,n,i,r,o){"use strict";function a(t){var i=d(t),r=i.get("units"),o=i.get("unitConversion");return!r||r.equals(e.Unit.NULL)?n.resolve(null):o?e.UnitDatabase.get().then(function(t){var n=l(o),i=e.$("baja:UnitConversion",n).getTag();return t.convertUnit(i,r)}):n.resolve(r)}function l(t){return e.hasType(t,"baja:Enum")?t.getOrdinal():e.hasType(t,"baja:Number")?t.valueOf():null}function u(t){var n=d(t).get("units");return n&&!n.equals(e.Unit.NULL)?n:null}function s(e){var t=Number(r.prototype.doRead.call(e));return a(e).then(function(n){return n&&!isNaN(t)&&(t=n.convertTo(u(e),t)),t})}function c(t){return e.hasType(t,"baja:Number")}var d=o.getFacets,f=o.minMaxCheck,p=function(){var e=this;i.apply(this,arguments),this.validators().add(function(t){var n=d(e);if(n)return f(e,n.get("min"),n.get("max"),t)})};return p.prototype=Object.create(i.prototype),p.prototype.constructor=p,p.prototype.doInitialize=function(e){var n=t('<div class="numericWrapper"/>'),i=t('<label class="unitsDisplay"/>').appendTo(n),r=t('<span class="inputWrapper"/>').appendTo(n),o=t('<input type="text" data-theme="c"/>').attr("name",this.name).appendTo(r);return a(this).then(function(t){t?(t.getIsPrefix()&&(i.css("order","0"),o.css("text-align","left")),i.text(t.getSymbol()),i.show()):i.hide(),n.appendTo(e)})},p.prototype.doLoad=function(e){var t=this,n=e.valueOf(),i=d(t),o=i&&i.get("precision");return a(t).then(function(e){if(e){var i=u(t);n=i.convertTo(e,n)}return c(n)&&c(o)&&(n=n.toFixed(Math.min(o,20))),r.prototype.doLoad.call(t,n)})},p.prototype.doRead=function(){var t=this.value().getType(),n=r.prototype.doRead.call(this);return s(this).then(function(i){if(t.is("baja:Integer"))switch(n.toLowerCase()){case"min":return e.Integer.MIN_VALUE;case"max":return e.Integer.MAX_VALUE;default:if(isNaN(i))throw new Error(n+" is not a valid Integer value");return e.Integer.make(i)}else if(t.is("baja:Long"))switch(n.toLowerCase()){case"min":return e.Long.MIN_VALUE;case"max":return e.Long.MAX_VALUE;default:if(isNaN(i))throw new Error(n+" is not a valid Long value");return e.Long.make(i)}else if(t.is("baja:Float"))switch(n.toLowerCase()){case"nan":return e.Float.NAN;case"-inf":return e.Float.NEGATIVE_INFINITY;case"+inf":return e.Float.POSITIVE_INFINITY;default:if(isNaN(i))throw new Error(n+" is not a valid Float value");return e.Float.make(i)}else{if(!t.is("baja:Double")){if(isNaN(i))throw new Error(n+" is not a valid numeric value");return i}switch(n.toLowerCase()){case"nan":return e.Double.NaN;case"-inf":return e.Double.NEGATIVE_INFINITY;case"+inf":return e.Double.POSITIVE_INFINITY;default:if(isNaN(i))throw new Error(n+" is not a valid Double value");return e.Double.make(i)}}})},p});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,o=void 0;try{for(var a,l=e[Symbol.iterator]();!(i=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);i=!0);}catch(e){r=!0,o=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw o}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/OrdComponentSelector",["baja!","lex!mobile","jquery","mobile/fieldeditors/MobileFieldEditor","mobile/util/ord"],function(e,t,n,i,r){"use strict";function o(e){if(e=String(e),e.indexOf("slotPathOrd")<0||e.indexOf("displayName")<0)throw"Must select slotPathOrd and displayName"}var a=r.equivalent,l=_slicedToArray(t,1),u=l[0],s=function(){i.apply(this,arguments)};return s.prototype=Object.create(i.prototype),s.prototype.constructor=s,s.prototype.doInitialize=function(e){n('<select data-role="selectmenu" data-theme="a" />').attr("name",this.name).appendTo(e).append(n("<option/>").text(u.get("loading")))},s.prototype.doLoad=function(t){var i=this.jq(),r=i.find("select")
;r.html(n("<option/>").text(u.get("loading")));try{o(t)}catch(e){i.text(e)}return e.Ord.make(String(t)).get({cursor:{before:function(){r.empty()},each:function(){var e=this.get("slotPathOrd"),i=this.get("displayName"),o=n("<option/>").val(e).text(i);a(t,e)&&o.attr("selected","selected"),o.appendTo(r)},after:function(){r.selectmenu("refresh")},limit:100}})},s.prototype.doRead=function(){return e.Ord.make(this.jq().find("select").val())},s}),define("mobile/util/time",["baja!"],function(e){"use strict";function t(t){return t=(t+l)%l,e.Time.make(t)}function n(n){return n instanceof Date?n.getTime()%l:n instanceof e.Time?n.getTimeOfDayMillis():"number"==typeof n?t(n).getTimeOfDayMillis():void 0}function i(n){return n instanceof Date?n.getTime()%u:n instanceof e.Time?n.getTimeOfDayMillis()%u:"number"==typeof n?t(n).getTimeOfDayMillis()%u:void 0}function r(t){var i=n(t),r=Math.round(i/s)*s;return t instanceof Date?new Date(r):t instanceof e.Time?e.Time.make({relTime:e.RelTime.make(r)}):"number"==typeof t?r:void 0}function o(e){return(e<10?"0":"")+e}function a(e,t,n){return[o(e),o(t),o(n||0)].join(":")}var l=864e5,u=36e5,s=18e5;return{MILLIS_IN_DAY:l,MILLIS_IN_HOUR:u,MILLIS_IN_HALF_HOUR:s,MILLIS_IN_MINUTE:6e4,MILLIS_IN_SECOND:1e3,makeTime:t,millisOfDay:n,millisOfHour:i,roundToHalfHour:r,toTimeString:a,zeroPad:o}});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,o=void 0;try{for(var a,l=e[Symbol.iterator]();!(i=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);i=!0);}catch(e){r=!0,o=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw o}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/RelTimeEditor",["baja!","lex!mobile","jquery","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/feUtils","mobile/util/time"],function(e,t,n,i,r,o){"use strict";function a(t){var n,i=l(t),r=i.get("max"),o=i.get("min"),a=null,u=null;return r&&r.getType().is("baja:RelTime")&&(a=r.getMillis()),o&&o.getType().is("baja:RelTime")&&(u=o.getMillis()),null!==u&&null!==a&&u>a&&(u=null,a=null),null===a&&null===u||(n="["+(u===e.Long.MIN_VALUE?"-inf":e.RelTime.make(u).encodeToString()+"ms")+" - "+(a===e.Long.MAX_VALUE?"+inf":e.RelTime.make(a).encodeToString()+"ms")+"]"),{min:u,max:a,str:n,normalize:function(e){return null!==a&&e>a?a:null!==u&&e<u?u:e}}}var l=r.getFacets,u=r.minMaxCheck,s=o.toTimeString,c=_slicedToArray(t,1),d=c[0],f=function(){i.apply(this,arguments),this.validators().add(function(e){var t=a(this);return u.call(this,t.min,t.max,e.getMillis())})};return f.prototype=Object.create(i.prototype),f.prototype.constructor=f,f.prototype.doInitialize=function(e){var t,i,r=this,o=r.name,l=r.params,u=n('<input type="text" data-role="datebox" />').attr("name",o),s=a(r);t={mode:"durationbox",useDialogForceFalse:!0,lockInput:!1,defaultValue:new Date,durationLabel:d.get({key:"propsheet.datebox.durationLabel",def:"Days Hours Minutes Seconds"}).split(" "),setDurationButtonLabel:d.get({key:"propsheet.datebox.setDurationButtonLabel",def:"Set Duration"}),durationFormat:l.durationFormat,durationOrder:l.durationOrder},u.attr("data-options",JSON.stringify(t)),u.appendTo(e),e.on("datebox",'input:jqmData(role="datebox")',function(e,t){function r(){var e=n(".ui-datebox-container .ui-datebox-controls"),t=e.prev();t.hasClass("relTimeRange")||(t=n('<div class="relTimeRange"></div>').insertBefore(e)),t.text(s.str)}var o=n(this);"open"===t.method&&r(),"open"===t.method||"offset"===t.method?i=function(){var e,t=o.datebox("getTheDate"),n=new Date(o.datebox("getOption","defaultValue")),i=t-n,r=i%1e3,a=i-r+(r?1e3:0);(e=s.normalize(a))!==a&&(o.datebox("setTheDate",new Date(n.getTime()+e)),o.datebox("refresh"))}:"postrefresh"===t.method&&i&&(i(),i=void 0,r())})},f.prototype.doLoad=function(e){if(e){var t=this,n=t.jq(),i=n.find('input:jqmData(role="datebox")'),r=e.getDaysPart(),o=e.getHoursPart(),a=e.getMinutesPart(),l=e.getSecondsPart(),u="";u+=r+" Day"+(r>1?"s":"")+", ",u+=s(o,a,l),i.trigger("datebox",{method:"set",value:u})}},f.prototype.doRead=function(){var t=this.jq().find('input:jqmData(role="datebox")'),n=new Date(t.datebox("getOption","defaultValue")),i=t.datebox("getTheDate"),r=i.getTime()-n.getTime();return r=1e3*Math.ceil(r/1e3),e.RelTime.make(r)},f}),define("mobile/fieldeditors/mobile/DurationSelectRelTimeEditor",["baja!","jquery","underscore","mobile/fieldeditors/mobile/RelTimeEditor","nmodule/js/rc/asyncUtils/asyncUtils"],function(e,t,n,i,r){"use strict";var o=r.doRequire,a=[["override.perm",0],["override.min1",6e4],["override.min15",9e5],["override.min30",18e5],["override.hour1",36e5],["override.hour2",72e5],["override.hour3",108e5],["override.custom",-1]],l=function(){i.apply(this,arguments)};return l.prototype=Object.create(i.prototype),l.prototype.constructor=l,l.prototype.doInitialize=function(e){var i=t('<select class="durationChoice" data-theme="a" />'),r=this;return o("lex!control").spread(function(o){function l(e,n){var r=t('<option value="'+n+'"/>');r.text(o.get(e)),r.appendTo(i)}var u=r.facets.get("max");null===u||u.getType().is("baja:RelTime")||(u=null),n.each(a,function(e){var t=e[0],n=e[1];(null===u||-1===n||n>0&&n<=u.getMillis())&&l(t,n)}),e.append(i)})},l.prototype.doLoad=function(e){var t=e?e.getMillis():"-1",n=this.jq().find("select");n.find('option[value="'+t+'"]').length?n.val(String(t)):n.val("-1"),n.trigger("change"),n.selectmenu("refresh")},l.prototype.doRead=function(){var t=this.jq().find("select"),n=Number(t.val());return-1===n?-1:e.RelTime.make(Number(n))},l}),define("mobile/fieldeditors/mobile/OverrideRelTimeEditor",["baja!","jquery","Promise","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/DurationSelectRelTimeEditor","mobile/fieldeditors/mobile/RelTimeEditor"],function(e,t,n,i,r,o){"use strict";var a=function(){i.apply(this,arguments)};return a.prototype=Object.create(i.prototype),a.prototype.constructor=a,a.prototype.doInitialize=function(n){function i(i){return null!==i&&(s.facets=e.Facets.make(s.facets,{max:i,min:e.RelTime.make(1e3)}),s.maxOverride=i,u.facets=e.Facets.make(u.facets,{max:i,min:e.RelTime.make(1e3)})),u.initialize(n).then(function(){return s.initialize(n).then(function(){return i&&s.load(i)})}).then(function(){a.$durationSelectEditor=u,a.$relTimeEditor=s,n.on("change","select",function(){var n=t(this).val();"-1"===n?(s.setEnabled(!0),s.load(e.RelTime.make(0))):(s.setEnabled(!1),s.load(e.RelTime.make(Number(n)))),a.setModified(!0)})})}var a=this,l=a.value(),u=new r(e.RelTime.make(0),l,"duration",{parent:a}),s=new o(e.RelTime.make(0),l,"duration",{parent:a}),c=a.facets.get("maxOverrideDuration");return null!==c?i(c):e.Ord.make("station:|slot:/").get({lease:100}).then(function(e){return i(e.get("sysInfo").get("maxOverrideDuration"))})},a.prototype.doLoad=function(e){var t=this,i=t.$durationSelectEditor,r=t.$relTimeEditor,o=r.maxOverride;return delete r.maxOverride,i.load(o||e).then(function(){return i.read()}).then(function(i){return n.join(r.load(o||e),r.setEnabled(!t.isEnabled()||-1===i))})},a.prototype.doRead=function(){return this.$relTimeEditor.read()},a});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,o=void 0;try{for(var a,l=e[Symbol.iterator]();!(i=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);i=!0);}catch(e){r=!0,o=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw o}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/TimeEditor",["baja!","lex!mobile","jquery","jqmDatebox","underscore","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/feUtils","mobile/util/time"],function(e,t,n,i,r,o,a,l){"use strict";function u(t,n){var i=t.jq().find("input[name$=time]"),o=i.datebox("getTheDate"),a=0,l=r.indexOf(["hour","minute","second","millisecond"],n||"millisecond");if(l<0)throw new Error("invalid accuracy argument "+n);return l>=0&&(a+=o.getHours()*p),l>=1&&(a+=o.getMinutes()*m),l>=2&&(a+=o.getSeconds()*h),l>=3&&(a+=o.getMilliseconds()),e.Time.make(a)}function s(e){var t=n('<input type="text" data-role="datebox" id="'+e+'_time" name="'+e+'_time"/>'),i=f();return i.mode="timebox",i.useDialogForceFalse=!0,i.lockInput=!1,i.centerHoriz=!0,i.centerVert=!0,i.setTimeButtonLabel=v.get({key:"propsheet.datebox.setTimeButtonLabel",def:"Set Time"}),t.attr("data-options",JSON.stringify(i)),t}var c=a.dateboxArmHandlers,d=a.getBajaTimeFormat,f=a.getDateboxDefaultOptions,p=l.MILLIS_IN_HOUR,m=l.MILLIS_IN_MINUTE,h=l.MILLIS_IN_SECOND,g=_slicedToArray(t,1),v=g[0],b=function(){o.apply(this,arguments)};return b.prototype=Object.create(o.prototype),b.prototype.constructor=b,b.prototype.doInitialize=function(e){e.append(s(this.name)),c(e)},b.prototype.doLoad=function(e){if(null!==e&&void 0!==e){var t=this.jq().find('input:jqmData(role="datebox")');return e.toTimeString({textPattern:d()||"HH:mm"}).then(function(e){t.trigger("datebox",{method:"set",value:e})})}},b.prototype.doRead=function(){return u(this,"minute")},b}),define("mobile/fieldeditors/mobile/UnitEditor",["baja!","jquery","underscore","mobile/fieldeditors/MobileFieldEditor"],function(e,t,n,i){"use strict";function r(){return e.UnitDatabase.get().then(function(e){function t(){return s}function i(e){return n.filter(s,function(e){var t=e.getName(),n=t.match(o);return n&&n[0]})}function r(e){return n.find(s,function(t){return t.getName()===e})}function a(e){var t=i(String(e.getDimension()));return n.find(t,function(t){return n.find(t.getUnits(),function(t){return e.equivalent(t)})})}function l(e){var t=r(e);return t&&t.getUnits()}function u(e,t){function r(t){return t.getSymbol()===e}for(var o=i(t),a=0;a<o.length;a++){var l=n.find(o[a].getUnits(),r);if(l)return l}}var s=e.getQuantities();return{getQuantities:t,getQuantityFromUnit:a,getUnits:l,getUnitFromSymbolAndDimension:u}})}var o=/\(\S*\)/,a=n.once(r),l=function(){i.apply(this,arguments)};return l.prototype=Object.create(i.prototype),l.prototype.constructor=l,l.prototype.doInitialize=function(e){var i=t('<select data-role="selectmenu" data-theme="a" name="quantity" />').append("<option>loading</option>"),r=t('<select data-role="selectmenu" data-theme="a" name="units" />').append("<option>loading</option>");return e.append(i),e.append(r),a().then(function(o){i.html(n.map(o.getQuantities(),function(e){var n=e.getName();return t("<option/>").attr("value",n||"").text(n)})),i.on("change",function(){var e=t(this).find("option:selected").text(),i=o.getUnits(e);r.html(n.map(i,function(e){return t("<option/>").val(e.getUnitName()).text(e.getUnitName()+" ("+e.getSymbol()+")").jqmData("unit",e)})),r.selectmenu("refresh").trigger("updatelayout")}),i.appendTo(e),r.appendTo(e)})},l.prototype.doLoad=function(e){var t=this.jq(),n=t.find("select[name=quantity]"),i=t.find("select[name=units]");return a().then(function(t){var r=t.getQuantityFromUnit(e);r&&(n.val(r.getName()).trigger("change"),i.val(e.getUnitName()).trigger("change"))})},l.prototype.doRead=function(){return this.jq().find("select[name=units]").find("option:selected").jqmData("unit")},l});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,o=void 0;try{for(var a,l=e[Symbol.iterator]();!(i=(a=l.next()).done)&&(n.push(a.value),!t||n.length!==t);i=!0);}catch(e){r=!0,o=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw o}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/fieldeditors.mobile",["baja!baja:Month,baja:UnitConversion","jqmDatebox","css!mobile/fieldeditors/fieldeditors","baja!","lex!mobile","jquery","jquerymobile","Promise","underscore","mobile/fieldeditors/fieldeditors","mobile/fieldeditors/fieldeditors.composite","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/AbsTimeEditor","mobile/fieldeditors/mobile/BooleanEditor","mobile/fieldeditors/mobile/BooleanCheckboxEditor","mobile/fieldeditors/mobile/DateEditor","mobile/fieldeditors/mobile/DynamicEnumEditor","mobile/fieldeditors/mobile/FacetsEditor","mobile/fieldeditors/mobile/FrozenEnumEditor","mobile/fieldeditors/mobile/NonEditableEditor","mobile/fieldeditors/mobile/NumericEditor","mobile/fieldeditors/mobile/OrdComponentSelector","mobile/fieldeditors/mobile/OverrideRelTimeEditor","mobile/fieldeditors/mobile/RelTimeEditor","mobile/fieldeditors/mobile/StringEditor","mobile/fieldeditors/mobile/TimeEditor","mobile/fieldeditors/mobile/UnitEditor"],function(e,t,n,i,r,o,a,l,u,s,c,d,f,p,m,h,g,v,b,y,w,j,k,S,x,T,C){var D=s.register,E=s.toSaveDataComponent,N=_slicedToArray(r,1),O=N[0],I={};return I=function(){function e(e){var t="nulldefault"+a++,n=o('<fieldset data-role="controlgroup" class="nulldefault"/>'),i=o('<input type="checkbox" data-theme="a" name="nulldefault"/>').attr("id",t).addClass("hidden"),r=o("<label/>").attr("for",t).text(O.get("propsheet.nullDefault"));n.append(i).append(r),e.append(n)}function t(e){return e.find("input[name=nulldefault]").is(":checked")?i.Status.nullStatus:i.Status.ok}function n(e){var t=e.find("input[type=text], textarea"),n=e.find("select");e.find("input[type=checkbox]").is(":checked")?(t.attr("disabled","disabled"),n.filter(':jqmData(role="slider")').slider("disable"),n.filter(':jqmData(role!="slider")').selectmenu("disable")):(t.removeAttr("disabled"),n.filter(':jqmData(role="slider")').slider("enable"),n.filter(':jqmData(role!="slider")').selectmenu("enable"))}function r(r){return function(o,a,u,s){var c=new r(o,a,u,s),d=c.$validators.$validators;return c.doInitialize=function(t){var i=this;return l.resolve(r.prototype.doInitialize.call(i,t)).then(function(){e(t),t.find('input[type="checkbox"]').change(function(){i.isEnabled()&&n(t)})})},i.iterate(d,function(e,t){d[t]=function(t){return e.call(this,t.getValue())}}),c.doEnabled=function(){var e=this;r.prototype.doEnabled.apply(e,arguments),e.isEnabled()&&n(e.jq())},c.doLoad=function(e){var t=e;if(t)return l.resolve(r.prototype.doLoad.call(this,t.getValue())).then(function(){var e=t.getStatus();c.jq().find('input[type="checkbox"]').prop("checked",e.isNull())})},c.doRead=function(){return l.resolve(r.prototype.doRead.call(this)).then(function(e){var n=t(c.jq()),i=c.value(),r=E(i);return r.set({slot:"value",value:e}),r.set({slot:"status",value:n}),r})},c.refreshWidgets=function(){var e=this;r.prototype.refreshWidgets.apply(e,arguments),e.isEnabled()&&n(e.jq())},c}}var a=0;return{wrapWithStatus:r}}(),function(){function e(e){i.iterate(e,function(e,t){D(t,e)})}var t,n,r,o;t={"baja:AbsTime":f,"baja:Boolean":p,"baja:Date":h,"baja:DynamicEnum":g,"baja:FrozenEnum":b,"baja:Number":w,"baja:RelTime":S,"baja:String":x,"baja:Time":T,"baja:Facets":v,"baja:Unit":C},n={"baja:StatusBoolean":I.wrapWithStatus(t["baja:Boolean"]),"baja:StatusEnum":I.wrapWithStatus(t["baja:DynamicEnum"]),"baja:StatusNumeric":I.wrapWithStatus(t["baja:Number"]),"baja:StatusString":I.wrapWithStatus(t["baja:String"])},r={"control:BooleanOverride":c.makeComposite([{slot:"duration",key:"override"},"value"]),"control:EnumOverride":c.makeComposite([{slot:"duration",key:"override"},"value"]),"control:NumericOverride":c.makeComposite([{slot:"duration",key:"override"},"value"]),"control:Override":c.makeComposite([{slot:"duration",key:"override"}]),"control:StringOverride":c.makeComposite([{slot:"duration",key:"override"},"value"]),"baja:AbsTimeRange":c.makeComposite(["startTime","endTime"]),"baja:TimeRange":c.makeComposite(["startTime","endTime"])},o={"baja:EnumRange":y,"baja:Password":y,"baja:TimeZone":y},e(t),e(n),e(r),e(o),D("baja:Boolean",m,"checkbox")}(),function(){D("baja:RelTime",k,"override"),D("baja:Ord",j,"componentSelector")}(),{status:I}}),define("mobile/propsheet/propsheet.ui",["baja!","jquery","jquerymobile","mobile/util/ord","mobile/util/aop","mobile/util/mobile/selectview","mobile/util/mobile/pages","mobile/propsheet/PropertySheetManager","mobile/fieldeditors/fieldeditors.mobile","css!mobile/propsheet/propsheet"],function(e,t,n,i,r,o,a,l){"use strict";function u(){s=new l,r.after(s,"attachSubscriberEvents",function(e){e[0].contentView.getSubscriber().attach("renamed",function(e,t,n){s.getSelectedView().then(function(e){return s.navbar.refresh(e)})})}),a.register({pageshow:function(){t(document).on("onShowCommands","a.commandsButton",function(){s.getSelectedView().then(function(e){e&&o.getViewsCommand().setOrd(i.deriveOrd(e.value()))})}),t.mobile.changePage(e.Ord.make(niagara.view.ord).toUri(),{transition:"none",changeHash:!1})}}),s.registerPages()}var s;return u}),require(["jquery","bajaux/bajaux.built.min"],function(e){"use strict";e(document).on("mobileinit",function(){e.mobile.autoInitializePage=!1,e.mobile.defaultPageTransition="slide"}),require(["jquerymobile","mobile/propsheet/propsheet.ui"],function(e,t){t(),e.initializePage()})}),define("mobile/propsheet/propsheet.run",function(){});